/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.util.BrowserUtils;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;

public class S1tbxAboutBox
extends JPanel {
    private static final String releaseNotesHTTP = "https://github.com/senbox-org/s1tbx/blob/master/ReleaseNotes.md";

    public S1tbxAboutBox() {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        ImageIcon aboutImage = new ImageIcon(S1tbxAboutBox.class.getResource("about_s1tbx.jpg"));
        JLabel iconLabel = new JLabel(aboutImage);
        this.add((Component)iconLabel, "Center");
        this.add((Component)this.createVersionPanel(), "South");
    }

    private JPanel createVersionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        ModuleInfo moduleInfo = Modules.getDefault().ownerOf(S1tbxAboutBox.class);
        panel.add(new JLabel("<html><b>Sentinel-1 Toolbox (S1TBX) version " + moduleInfo.getImplementationVersion() + "</b>", 4));
        URI releaseNotesURI = this.getReleaseNotesURI();
        if (releaseNotesURI != null) {
            JLabel releaseNoteLabel = new JLabel("<html><a href=\"" + releaseNotesURI.toString() + "\">Release Notes</a>", 4);
            releaseNoteLabel.setCursor(new Cursor(12));
            releaseNoteLabel.addMouseListener((MouseListener)new BrowserUtils.URLClickAdaptor(releaseNotesHTTP));
            panel.add(releaseNoteLabel);
        }
        return panel;
    }

    private URI getReleaseNotesURI() {
        try {
            return new URI(releaseNotesHTTP);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

