/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.terrasarx;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.terrasarx.TerraSarXConstants;
import org.esa.s1tbx.io.terrasarx.TerraSarXProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class TerraSarXProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        String filename = file.getName().toUpperCase();
        for (String header : TerraSarXConstants.HEADER_PREFIX) {
            if (!filename.startsWith(header) || !filename.endsWith(".XML")) continue;
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return TerraSarXConstants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new TerraSarXProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return TerraSarXConstants.getFormatNames();
    }

    public String[] getDefaultFileExtensions() {
        return TerraSarXConstants.getForamtFileExtensions();
    }

    public String getDescription(Locale locale) {
        return TerraSarXConstants.getPluginDescription();
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(TerraSarXConstants.getFormatNames()[0]);
            this.setExtensions(TerraSarXConstants.getForamtFileExtensions());
            this.setDescription(TerraSarXConstants.getPluginDescription());
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String name = file.getName().toUpperCase();
                if (file.isDirectory()) {
                    return true;
                }
                for (String header : TerraSarXConstants.HEADER_PREFIX) {
                    if (!name.startsWith(header)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

