/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sunraster;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class SunRasterReader
extends AbstractProductReader {
    private ImageInputStream inStream;
    private int width;
    private int height;
    private int depth;
    private static final int RAS_MAGIC = 1504078485;
    private static final int COMPRESSION_NONE = 1;
    private static final int RAS_HEADER_SIZE = 32;

    public SunRasterReader() {
        super(null);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        this.inStream = new FileImageInputStream(inputFile);
        this.inStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.readHeader();
        Product product = new Product(inputFile.getName(), "SunRaster", this.width, this.height);
        product.setProductReader((ProductReader)this);
        product.setFileLocation(inputFile);
        Band band = new Band("data", 30, this.width, this.height);
        band.setUnit("amplitude");
        product.addBand(band);
        return product;
    }

    private void readHeader() throws IOException {
        byte[] header = new byte[32];
        this.inStream.readFully(header);
        int magic = SunRasterReader.getIntBE(header, 0);
        if (magic != 1504078485) {
            throw new IOException("This stream is not a valid Sun RAS stream (bad magic: " + Integer.toHexString(magic) + " instead of " + Integer.toHexString(1504078485));
        }
        this.width = SunRasterReader.getIntBE(header, 4);
        this.height = SunRasterReader.getIntBE(header, 8);
        if (this.width < 1 || this.height < 1) {
            throw new IOException("Width and height must both be larger than zero; found width=" + this.width + ", height=" + this.height + ".");
        }
        this.depth = SunRasterReader.getIntBE(header, 12);
    }

    private static int getIntBE(byte[] src, int srcOffset) {
        return src[srcOffset + 3] & 0xFF | (src[srcOffset + 2] & 0xFF) << 8 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset] & 0xFF) << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int elemSize = destBuffer.getElemSize();
        int headerOffset = 32;
        long lineSizeInBytes = this.width * elemSize;
        ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)sourceWidth);
        pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
        try {
            int destPos = 0;
            for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                ImageInputStream imageInputStream = this.inStream;
                synchronized (imageInputStream) {
                    long lineStartPos = 32L + (long)sourceY * lineSizeInBytes;
                    this.inStream.seek(lineStartPos + (long)(elemSize * sourceOffsetX));
                    lineData.readFrom(0, sourceWidth, this.inStream);
                }
                for (int x = 0; x < sourceWidth; ++x) {
                    destBuffer.setElemDoubleAt(destPos++, lineData.getElemDoubleAt(x));
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        super.close();
    }
}

