/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.snaphu;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.esa.snap.dataio.envi.Header;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class SNAPHUReader
extends EnviProductReader {
    private Header header;
    private boolean isComplex = false;
    private ImageInputStream inStream;

    public SNAPHUReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        try (BufferedReader headerReader = this.getHeaderReader(inputFile);){
            this.header = new Header(headerReader);
        }
        int dataType = this.header.getDataType();
        if (dataType == 6) {
            return this.createComplexProduct(inputFile, this.header, 30);
        }
        if (dataType == 9) {
            return this.createComplexProduct(inputFile, this.header, 31);
        }
        return super.readProductNodesImpl();
    }

    private Product createComplexProduct(File inputFile, Header header, int bandType) throws IOException {
        int width = header.getNumSamples();
        int height = header.getNumLines();
        Product product = new Product(inputFile.getName(), "RAT", width, height);
        product.setProductReader((ProductReader)this);
        product.setFileLocation(inputFile);
        product.setDescription(header.getDescription());
        product.getMetadataRoot().addElement(header.getAsMetadata());
        this.initGeoCoding(product, header);
        SNAPHUReader.applyBeamProperties((Product)product, (Header.BeamProperties)header.getBeamProperties());
        Band tgtBandI = new Band("i_band", bandType, width, height);
        tgtBandI.setUnit("real");
        product.addBand(tgtBandI);
        Band tgtBandQ = new Band("q_band", 30, width, height);
        tgtBandQ.setUnit("imaginary");
        product.addBand(tgtBandQ);
        ReaderUtils.createVirtualIntensityBand((Product)product, (Band)tgtBandI, (Band)tgtBandQ, (String)"_band");
        this.isComplex = true;
        String ratFilePath = inputFile.getPath().substring(0, inputFile.getPath().length() - 4);
        this.inStream = new FileImageInputStream(new File(ratFilePath));
        this.inStream.setByteOrder(header.getJavaByteOrder());
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        if (this.isComplex) {
            int sourceMaxY = sourceOffsetY + sourceHeight - 1;
            Product product = destBand.getProduct();
            int elemSize = destBuffer.getElemSize();
            int headerOffset = this.header.getHeaderOffset();
            int bandIndex = product.getBandIndex(destBand.getName());
            int numBands = 2;
            long lineSizeInBytes = this.header.getNumSamples() * numBands * elemSize;
            ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)(sourceWidth * numBands));
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    ImageInputStream imageInputStream = this.inStream;
                    synchronized (imageInputStream) {
                        long lineStartPos = (long)headerOffset + (long)sourceY * lineSizeInBytes;
                        this.inStream.seek(lineStartPos + (long)(elemSize * sourceOffsetX * numBands));
                        lineData.readFrom(0, sourceWidth * numBands, this.inStream);
                    }
                    for (int x = 0; x < sourceWidth; ++x) {
                        destBuffer.setElemDoubleAt(destPos++, lineData.getElemDoubleAt(x * numBands + bandIndex));
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        } else {
            super.readBandRasterDataImpl(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
        }
    }

    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        super.close();
    }
}

