/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.s1tbx.io.sentinel1.Sentinel1Constants;
import org.esa.s1tbx.io.sentinel1.Sentinel1ProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class Sentinel1ProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null) {
            File manifest;
            String filename = file.getName().toLowerCase();
            if (filename.equals("manifest.safe") && (Sentinel1ProductReaderPlugIn.isLevel1(file) || Sentinel1ProductReaderPlugIn.isLevel2(file) || Sentinel1ProductReaderPlugIn.isLevel0(file))) {
                return DecodeQualification.INTENDED;
            }
            if (filename.endsWith(".zip") && filename.startsWith("s1") && (ZipUtils.findInZip((File)file, (String)"s1", (String)"manifest.safe") || ZipUtils.findInZip((File)file, (String)"rs2", (String)"manifest.safe"))) {
                return DecodeQualification.INTENDED;
            }
            if (filename.startsWith("s1") && filename.endsWith(".safe") && file.isDirectory() && (manifest = new File(file, "manifest.safe")).exists() && (Sentinel1ProductReaderPlugIn.isLevel1(manifest) || Sentinel1ProductReaderPlugIn.isLevel2(manifest) || Sentinel1ProductReaderPlugIn.isLevel0(manifest))) {
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public static boolean isLevel1(File file) {
        if (ZipUtils.isZip((File)file)) {
            if (ZipUtils.findInZip((File)file, (String)"s1", (String)".tiff")) {
                return true;
            }
            String name = file.getName().toUpperCase();
            return name.contains("_1AS") || name.contains("_1AD") || name.contains("_1SS") || name.contains("_1SD");
        }
        File baseFolder = file.getParentFile();
        File annotationFolder = new File(baseFolder, "annotation");
        if (annotationFolder.exists()) {
            return Sentinel1ProductReaderPlugIn.checkFolder(annotationFolder, ".xml");
        }
        File measurementFolder = new File(baseFolder, "measurement");
        return measurementFolder.exists() && Sentinel1ProductReaderPlugIn.checkFolder(measurementFolder, ".tiff");
    }

    public static boolean isLevel2(File file) {
        if (ZipUtils.isZip((File)file)) {
            return ZipUtils.findInZip((File)file, (String)"s1", (String)".nc");
        }
        File baseFolder = file.getParentFile();
        File measurementFolder = new File(baseFolder, "measurement");
        return measurementFolder.exists() && Sentinel1ProductReaderPlugIn.checkFolder(measurementFolder, ".nc");
    }

    public static boolean isLevel0(File file) {
        if (ZipUtils.isZip((File)file)) {
            return ZipUtils.findInZip((File)file, (String)"s1", (String)".dat");
        }
        File baseFolder = file.getParentFile();
        return Sentinel1ProductReaderPlugIn.checkFolder(baseFolder, ".dat");
    }

    static void validateInput(File file) throws IOException {
        if (ZipUtils.isZip((File)file)) {
            if (!ZipUtils.findInZip((File)file, (String)"s1", (String)".tiff")) {
                throw new IOException("measurement folder is missing in product");
            }
        } else {
            File baseFolder = file.getParentFile();
            File annotationFolder = new File(baseFolder, "annotation");
            if (!annotationFolder.exists()) {
                throw new IOException("annotation folder is missing in product");
            }
            File measurementFolder = new File(baseFolder, "measurement");
            if (!measurementFolder.exists()) {
                throw new IOException("measurement folder is missing in product");
            }
        }
    }

    private static boolean checkFolder(File folder, String extension) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                String name = f.getName().toLowerCase();
                if (!f.isFile() || !name.startsWith("s1") && !name.startsWith("asa") && !name.startsWith("rs2") || extension != null && !name.endsWith(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public Class[] getInputTypes() {
        return Sentinel1Constants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new Sentinel1ProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return Sentinel1Constants.getFormatNames();
    }

    public String[] getDefaultFileExtensions() {
        return Sentinel1Constants.getForamtFileExtensions();
    }

    public String getDescription(Locale locale) {
        return Sentinel1Constants.getPluginDescription();
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(Sentinel1Constants.getFormatNames()[0]);
            this.setExtensions(Sentinel1Constants.getForamtFileExtensions());
            this.setDescription(Sentinel1Constants.getPluginDescription());
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String name = file.getName().toUpperCase();
                if (file.isDirectory() || name.startsWith("MANIFEST") && name.endsWith(Sentinel1Constants.getIndicationKey()) || name.startsWith("S1") && name.endsWith(".ZIP")) {
                    return true;
                }
            }
            return false;
        }
    }
}

