/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.sentinel1.DataCache;
import org.esa.s1tbx.io.sentinel1.Sentinel1Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level0Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level1Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level2Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class Sentinel1ProductReader
extends SARReader {
    protected Sentinel1Directory dataDir = null;
    private DataCache cache = new DataCache();

    public Sentinel1ProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this.dataDir != null) {
            this.dataDir.close();
            this.dataDir = null;
        }
        super.close();
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        try {
            File fileFromInput = ReaderUtils.getFileFromInput((Object)this.getInput());
            if (fileFromInput.isDirectory()) {
                fileFromInput = new File(fileFromInput, "manifest.safe");
            }
            if (!fileFromInput.exists()) {
                throw new IOException(fileFromInput.toString() + " not found");
            }
            if (Sentinel1ProductReaderPlugIn.isLevel1(fileFromInput)) {
                this.dataDir = new Sentinel1Level1Directory(fileFromInput);
            } else if (Sentinel1ProductReaderPlugIn.isLevel2(fileFromInput)) {
                this.dataDir = new Sentinel1Level2Directory(fileFromInput);
            } else if (Sentinel1ProductReaderPlugIn.isLevel0(fileFromInput)) {
                this.dataDir = new Sentinel1Level0Directory(fileFromInput);
            }
            if (this.dataDir == null) {
                Sentinel1ProductReaderPlugIn.validateInput(fileFromInput);
            }
            this.dataDir.readProductDirectory();
            Product product = this.dataDir.createProduct();
            product.setFileLocation(fileFromInput);
            product.setProductReader((ProductReader)this);
            if (this.dataDir instanceof Sentinel1Level2Directory) {
                ((Sentinel1Level2Directory)this.dataDir).addGeoCodingToBands(product);
            }
            Sentinel1ProductReader.setQuicklookBandName(product);
            this.addQuicklook(product, "Quicklook", this.getQuicklookFile());
            product.setModified(false);
            return product;
        }
        catch (Exception e) {
            this.handleReaderException(e);
            return null;
        }
    }

    private File getQuicklookFile() {
        if (this.dataDir instanceof Sentinel1Level1Directory) {
            Sentinel1Level1Directory level1Directory = (Sentinel1Level1Directory)this.dataDir;
            try {
                if (level1Directory.exists(level1Directory.getRootFolder() + "preview/quick-look.png")) {
                    return level1Directory.getFile(level1Directory.getRootFolder() + "preview/quick-look.png");
                }
            }
            catch (IOException e) {
                SystemUtils.LOG.severe("Unable to load quicklook " + level1Directory.getProductName());
            }
        }
        return null;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ImageIOFile.BandInfo bandInfo = this.dataDir.getBandInfo(destBand);
        if (bandInfo != null && bandInfo.img != null) {
            if (this.dataDir.isSLC()) {
                this.readSLCRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, bandInfo);
            } else {
                bandInfo.img.readImageIORasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, bandInfo.imageID, bandInfo.bandSampleOffset);
            }
        } else if (this.dataDir instanceof Sentinel1Level2Directory) {
            Sentinel1Level2Directory s1L1Dir = (Sentinel1Level2Directory)this.dataDir;
            if (s1L1Dir.getOCNReader() == null) {
                throw new IOException("Sentinel1OCNReader not found");
            }
            s1L1Dir.getOCNReader().readData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer);
        }
    }

    public void readSLCRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ImageIOFile.BandInfo bandInfo) throws IOException {
        int length;
        int[] srcArray;
        Rectangle destRect = new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight);
        DataCache.DataKey datakey = new DataCache.DataKey(bandInfo.img, destRect);
        DataCache.Data cachedData = this.cache.get(datakey);
        if (cachedData != null && cachedData.valid) {
            srcArray = cachedData.intArray;
            length = srcArray.length;
        } else {
            cachedData = this.readRect(datakey, bandInfo, sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destRect);
            srcArray = cachedData.intArray;
            length = srcArray.length;
        }
        short[] destArray = (short[])destBuffer.getElems();
        if (!bandInfo.isImaginary) {
            if (sourceStepX == 1) {
                int i = 0;
                for (int srcVal : srcArray) {
                    destArray[i++] = (short)srcVal;
                }
            } else {
                for (int i = 0; i < length; i += sourceStepX) {
                    destArray[i] = (short)srcArray[i];
                }
            }
        } else if (sourceStepX == 1) {
            int i = 0;
            for (int srcVal : srcArray) {
                destArray[i++] = (short)(srcVal >> 16);
            }
        } else {
            for (int i = 0; i < length; i += sourceStepX) {
                destArray[i] = (short)(srcArray[i] >> 16);
            }
        }
    }

    private synchronized DataCache.Data readRect(DataCache.DataKey datakey, ImageIOFile.BandInfo bandInfo, int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, Rectangle destRect) throws IOException {
        try {
            ImageReader imageReader = bandInfo.img.getReader();
            ImageReadParam readParam = imageReader.getDefaultReadParam();
            if (sourceStepX == 1 && sourceStepY == 1) {
                readParam.setSourceRegion(destRect);
            }
            readParam.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
            RenderedImage subsampledImage = imageReader.readAsRenderedImage(0, readParam);
            Raster data = subsampledImage.getData(destRect);
            SampleModel sampleModel = data.getSampleModel();
            int destWidth = Math.min((int)destRect.getWidth(), sampleModel.getWidth());
            int destHeight = Math.min((int)destRect.getHeight(), sampleModel.getHeight());
            int length = destWidth * destHeight;
            int[] srcArray = new int[length];
            sampleModel.getSamples(0, 0, destWidth, destHeight, bandInfo.bandSampleOffset, srcArray, data.getDataBuffer());
            DataCache.Data cachedData = new DataCache.Data(srcArray);
            this.cache.put(datakey, cachedData);
            return cachedData;
        }
        catch (Exception e) {
            int[] srcArray = new int[(int)destRect.getWidth() * (int)destRect.getHeight()];
            DataCache.Data cachedData = new DataCache.Data(srcArray);
            this.cache.put(datakey, cachedData);
            return cachedData;
        }
    }
}

