/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s1tbx.io.netcdf.NetCDFUtils;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level2Directory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class Sentinel1OCNReader {
    private final Map<String, NCFileData> bandNCFileMap = new HashMap<String, NCFileData>(1);
    private final Sentinel1Level2Directory dataDir;
    private String mode;
    private final Map<String, NetcdfFile> bandNameNCFileMap = new HashMap<String, NetcdfFile>(1);

    public Sentinel1OCNReader(Sentinel1Level2Directory dataDir) {
        this.dataDir = dataDir;
    }

    public void addImageFile(File file, String name) throws IOException {
        String imgNum = name.substring(name.lastIndexOf("-") + 1, name.length());
        NetcdfFile netcdfFile = NetcdfFile.open((String)file.getPath());
        this.bandNCFileMap.put(imgNum, new NCFileData(name, netcdfFile));
    }

    public void addNetCDFMetadata(MetadataElement annotationElement) {
        ArrayList<String> keys = new ArrayList<String>(this.bandNCFileMap.keySet());
        Collections.sort(keys);
        for (String imgNum : keys) {
            NCFileData data = this.bandNCFileMap.get(imgNum);
            NetcdfFile netcdfFile = data.netcdfFile;
            String file = data.name;
            MetadataElement bandElem = NetCDFUtils.addAttributes(annotationElement, file, netcdfFile.getGlobalAttributes());
            MetadataElement dimElem = new MetadataElement("Dimensions");
            bandElem.addElement(dimElem);
            List dimensionList = netcdfFile.getDimensions();
            for (Dimension d : dimensionList) {
                ProductData productData = ProductData.createInstance((int)22, (int)1);
                productData.setElemUInt((long)d.getLength());
                MetadataAttribute metadataAttribute = new MetadataAttribute(d.getFullName(), productData, true);
                dimElem.addAttribute(metadataAttribute);
            }
            List variableList = netcdfFile.getVariables();
            for (Variable variable : variableList) {
                bandElem.addElement(MetadataUtils.createMetadataElement((Variable)variable, (int)1000));
            }
            for (Variable variable : variableList) {
                if (!Sentinel1OCNReader.variableIsVector(variable) || variable.getRank() <= 1) continue;
                MetadataElement elem = bandElem.getElement(variable.getFullName());
                MetadataElement valuesElem = new MetadataElement("Values");
                elem.addElement(valuesElem);
                MetadataUtils.addAttribute((Variable)variable, (MetadataElement)valuesElem, (int)1000);
            }
        }
    }

    public void addNetCDFBands(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        this.mode = absRoot.getAttributeString("ACQUISITION_MODE");
        ArrayList<String> keys = new ArrayList<String>(this.bandNCFileMap.keySet());
        Collections.sort(keys);
        for (String imgNum : keys) {
            NCFileData data = this.bandNCFileMap.get(imgNum);
            NetcdfFile netcdfFile = data.netcdfFile;
            String file = data.name;
            int idx = file.indexOf("-ocn-");
            String pol = file.substring(idx + 5, idx + 7);
            idx = file.lastIndexOf(45);
            String imageNum = file.substring(idx + 1, idx + 4);
            List variableList = netcdfFile.getVariables();
            block7: for (Variable variable : variableList) {
                if (Sentinel1OCNReader.variableIsVector(variable) && variable.getRank() > 1) continue;
                String bandName = pol + "_" + imageNum + "_";
                int[] shape = variable.getShape();
                switch (variable.getRank()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        bandName = bandName + variable.getFullName();
                        this.addBand(product, bandName, variable, shape[1], shape[0]);
                        this.bandNameNCFileMap.put(bandName, netcdfFile);
                        if (!bandName.contains("owiNrcs")) continue block7;
                        product.setQuicklookBandName(bandName);
                        break;
                    }
                    case 3: {
                        for (int swath = 1; swath <= shape[2]; ++swath) {
                            String bandNameSwath = bandName + this.mode + swath + "_" + variable.getFullName();
                            this.addBand(product, bandNameSwath, variable, shape[1], shape[0]);
                            this.bandNameNCFileMap.put(bandNameSwath, netcdfFile);
                        }
                        continue block7;
                    }
                    case 4: {
                        bandName = bandName + variable.getFullName();
                        this.addBand(product, bandName, variable, shape[1] * shape[3], shape[0] * shape[2]);
                        this.bandNameNCFileMap.put(bandName, netcdfFile);
                        break;
                    }
                    default: {
                        SystemUtils.LOG.severe("SentinelOCNReader.addNetCDFMetadataAndBands: ERROR invalid variable rank " + variable.getRank() + " for " + variable.getFullName());
                    }
                }
            }
        }
    }

    public void addGeoCodingToBands(Product product) {
    }

    private void addBand(Product product, String bandName, Variable variable, int width, int height) {
        Band band = NetCDFUtils.createBand(variable, width, height);
        band.setName(bandName);
        product.addBand(band);
    }

    public void readData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer) {
        if (sourceWidth != destWidth || sourceHeight != destHeight) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readData: ERROR sourceWidth = " + sourceWidth + " sourceHeight = " + sourceHeight);
            return;
        }
        String bandName = destBand.getName();
        String varFullName = bandName.substring(bandName.lastIndexOf(95) + 1);
        NetcdfFile netcdfFile = this.bandNameNCFileMap.get(bandName);
        Variable var = netcdfFile.findVariable(varFullName);
        switch (var.getRank()) {
            case 2: {
                this.readDataForRank2Variable(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, var, destWidth, destHeight, destBuffer);
                break;
            }
            case 3: {
                this.readDataForRank3Variable(bandName, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, var, destWidth, destHeight, destBuffer);
                break;
            }
            case 4: {
                this.readDataForRank4Variable(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, var, destWidth, destHeight, destBuffer);
            }
        }
    }

    public synchronized void readDataForRank2Variable(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Variable var, int destWidth, int destHeight, ProductData destBuffer) {
        int[] origin = new int[]{sourceOffsetY, sourceOffsetX};
        int[] shape = new int[]{sourceHeight, sourceWidth};
        try {
            Array srcArray = var.read(origin, shape);
            for (int i = 0; i < destHeight; ++i) {
                int srcStride = i * sourceWidth;
                int dstStride = i * destWidth;
                for (int j = 0; j < destWidth; ++j) {
                    destBuffer.setElemFloatAt(dstStride + j, srcArray.getFloat(srcStride + j));
                }
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank2Variable: IOException when reading variable " + var.getFullName());
        }
        catch (InvalidRangeException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank2Variable: InvalidRangeException when reading variable " + var.getFullName());
        }
    }

    private synchronized void readDataForRank3Variable(String bandName, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Variable var, int destWidth, int destHeight, ProductData destBuffer) {
        int swath = this.getSwathNumber(bandName);
        int[] shape0 = var.getShape();
        shape0[2] = 1;
        int[] origin = new int[]{sourceOffsetY, sourceOffsetX, swath};
        int outerYEnd = sourceOffsetY + (sourceHeight - 1) * sourceStepY;
        int outerXEnd = sourceOffsetX + (sourceWidth - 1) * sourceStepX;
        int[] shape = new int[]{outerYEnd - origin[0] + 1, outerXEnd - origin[1] + 1, 1};
        try {
            Array srcArray = var.read(origin, shape);
            int length = destBuffer.getNumElems();
            for (int i = 0; i < length; ++i) {
                destBuffer.setElemFloatAt(i, srcArray.getFloat(i));
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank3Variable: IOException when reading variable " + var.getFullName());
        }
        catch (InvalidRangeException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank3Variable: InvalidRangeException when reading variable " + var.getFullName());
        }
    }

    private int getSwathNumber(String bandName) {
        if (this.mode.equals("IW")) {
            if (bandName.contains("IW2")) {
                return 1;
            }
            if (bandName.contains("IW3")) {
                return 2;
            }
        }
        return 0;
    }

    private synchronized void readDataForRank4Variable(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Variable var, int destWidth, int destHeight, ProductData destBuffer) {
        int[] shape0 = var.getShape();
        int[] origin = new int[]{sourceOffsetY / shape0[2], sourceOffsetX / shape0[3], 0, 0};
        int outerYEnd = (sourceOffsetY + (sourceHeight - 1) * sourceStepY) / shape0[2];
        int outerXEnd = (sourceOffsetX + (sourceWidth - 1) * sourceStepX) / shape0[3];
        int[] shape = new int[]{outerYEnd - origin[0] + 1, outerXEnd - origin[1] + 1, shape0[2], shape0[3]};
        try {
            Array srcArray = var.read(origin, shape);
            int[] idx = new int[4];
            for (int i = 0; i < destHeight; ++i) {
                int srcY = sourceOffsetY - shape0[2] * origin[0] + i * sourceStepY;
                idx[0] = srcY / shape[2];
                for (int j = 0; j < destWidth; ++j) {
                    int srcX = sourceOffsetX - shape0[3] * origin[1] + j * sourceStepX;
                    idx[1] = srcX / shape[3];
                    idx[2] = srcY - idx[0] * shape[2];
                    idx[3] = srcX - idx[1] * shape[3];
                    int srcIdx = idx[0] * shape[1] * shape[2] * shape[3] + idx[1] * shape[2] * shape[3] + idx[2] * shape[3] + idx[3];
                    int destIdx = i * destWidth + j;
                    destBuffer.setElemFloatAt(destIdx, srcArray.getFloat(srcIdx));
                }
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank4Variable: IOException when reading variable " + var.getFullName());
        }
        catch (InvalidRangeException e) {
            SystemUtils.LOG.severe("Sentinel1OCNReader.readDataForRank4Variable: InvalidRangeException when reading variable " + var.getFullName());
        }
    }

    private static boolean variableIsVector(Variable variable) {
        int[] shape = variable.getShape();
        int cnt = 0;
        for (int i : shape) {
            if (i != 1) continue;
            ++cnt;
        }
        return cnt + 1 >= shape.length;
    }

    private void dumpVariableValues(Variable variable, String bandName) {
        try {
            Array arr = variable.read();
            int i = 0;
            while ((long)i < arr.getSize()) {
                System.out.println("Sentinel1OCNReader: " + variable.getFullName() + "[" + i + "] = " + arr.getFloat(i));
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("Sentinel1OCNReader: failed to read variable " + variable.getFullName() + " for band " + bandName);
        }
    }

    private static class NCFileData {
        String name;
        NetcdfFile netcdfFile;

        NCFileData(String name, NetcdfFile netcdfFile) {
            this.name = name;
            this.netcdfFile = netcdfFile;
        }
    }
}

