/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Constants;
import org.esa.s1tbx.io.sentinel1.Sentinel1Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level1Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1OCNReader;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class Sentinel1Level2Directory
extends XMLProductDirectory
implements Sentinel1Directory {
    private Sentinel1OCNReader OCNReader = null;

    public Sentinel1Level2Directory(File inputFile) {
        super(inputFile);
    }

    @Override
    protected String getHeaderFileName() {
        return "manifest.safe";
    }

    @Override
    protected String getRelativePathToImageFolder() {
        return this.getRootFolder() + "measurement" + '/';
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
        String name = Sentinel1Level2Directory.getBandFileNameFromImage(imgPath);
        if (name.endsWith(".nc")) {
            if (this.OCNReader == null) {
                this.OCNReader = new Sentinel1OCNReader(this);
            }
            File file = new File(this.getBaseDir(), imgPath);
            if (this.isCompressed()) {
                file = this.getFile(imgPath);
            }
            this.OCNReader.addImageFile(file, name);
        }
    }

    @Override
    protected void addBands(Product product) {
        this.OCNReader.addNetCDFBands(product);
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        Sentinel1Level1Directory.addManifestMetadata(this.getProductName(), absRoot, origProdRoot, true);
        String acqMode = absRoot.getAttributeString("ACQUISITION_MODE");
        this.setSLC(absRoot.getAttributeString("SAMPLE_TYPE").equals("COMPLEX"));
        this.addBandAbstractedMetadata(origProdRoot);
    }

    private void addBandAbstractedMetadata(MetadataElement origProdRoot) throws IOException {
        MetadataElement annotationElement = origProdRoot.getElement("annotation");
        if (annotationElement == null) {
            annotationElement = new MetadataElement("annotation");
            origProdRoot.addElement(annotationElement);
        }
        if (this.OCNReader != null) {
            this.OCNReader.addNetCDFMetadata(annotationElement);
        }
    }

    @Override
    protected void addTiePointGrids(Product product) {
    }

    @Override
    protected String getProductName() {
        String name = this.getBaseName();
        if (name.toUpperCase().endsWith(".SAFE")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.toUpperCase().endsWith(".ZIP")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    @Override
    protected String getProductType() {
        return "Level-2 OCN";
    }

    public Sentinel1OCNReader getOCNReader() {
        return this.OCNReader;
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag) {
        String start = elem.getAttributeString(tag, "-");
        start = start.replace("T", "_");
        return AbstractMetadata.parseUTC((String)start, (DateFormat)Sentinel1Constants.sentinelDateFormat);
    }

    @Override
    public Product createProduct() throws IOException {
        this.findImages(null);
        MetadataElement newRoot = this.addMetaData();
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        int sceneWidth = absRoot.getAttributeInt("num_samples_per_line");
        int sceneHeight = absRoot.getAttributeInt("num_output_lines");
        Product product = new Product(this.getProductName(), this.getProductType(), sceneWidth, sceneHeight);
        Sentinel1Level2Directory.updateProduct(product, newRoot);
        this.addBands(product);
        this.addGeoCoding(product);
        product.setName(this.getProductName());
        product.setDescription(this.getProductDescription());
        ReaderUtils.addMetadataProductSize((Product)product);
        return product;
    }

    public void addGeoCodingToBands(Product product) {
        this.OCNReader.addGeoCodingToBands(product);
    }

    private MetadataElement getMetadataObject(MetadataElement origProdRoot, String metadataObjectName) {
        MetadataElement[] metadataObjects;
        MetadataElement metadataSection = origProdRoot.getElement("XFDU").getElement("metadataSection");
        for (MetadataElement elem : metadataObjects = metadataSection.getElements()) {
            if (!elem.getAttribute("ID").getData().getElemString().equals(metadataObjectName)) continue;
            return elem;
        }
        return null;
    }

    @Override
    protected void addGeoCoding(Product product) {
        float minLat = 999.0f;
        float maxLat = -999.0f;
        float minLon = 999.0f;
        float maxLon = -999.0f;
        MetadataElement elem = this.getMetadataObject(AbstractMetadata.getOriginalProductMetadata((Product)product), "measurementFrameSet");
        if (elem != null) {
            MetadataElement[] frames;
            MetadataElement frameSet = elem.getElement("metadataWrap").getElement("xmlData").getElement("frameSet");
            for (MetadataElement frame : frames = frameSet.getElements()) {
                String[] latLonPairsStr;
                MetadataAttribute coordinates = frame.getElement("footPrint").getAttribute("coordinates");
                String coordinatesStr = coordinates.getData().getElemString();
                for (String s : latLonPairsStr = coordinatesStr.split(" ")) {
                    String[] latStrLonStr = s.split(",");
                    float lat = Float.parseFloat(latStrLonStr[0]);
                    float lon = Float.parseFloat(latStrLonStr[1]);
                    if (lat < minLat) {
                        minLat = lat;
                    }
                    if (lat > maxLat) {
                        maxLat = lat;
                    }
                    if (lon < minLon) {
                        minLon = lon;
                    }
                    if (!(lon > maxLon)) continue;
                    maxLon = lon;
                }
            }
        }
        if (minLat > maxLat || minLon > maxLon) {
            SystemUtils.LOG.severe("Sentinel1Level2Directory.addGeoCodingForLevel2Products: ERROR failed to get valid footprint");
            return;
        }
        float[] latCorners = new float[4];
        float[] lonCorners = new float[latCorners.length];
        latCorners[0] = maxLat;
        lonCorners[0] = minLon;
        latCorners[1] = maxLat;
        lonCorners[1] = maxLon;
        latCorners[2] = minLat;
        lonCorners[2] = minLon;
        latCorners[3] = minLat;
        lonCorners[3] = maxLon;
        ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
    }
}

