/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.sentinel1.Sentinel1Constants;
import org.esa.s1tbx.io.sentinel1.Sentinel1Directory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class Sentinel1Level1Directory
extends XMLProductDirectory
implements Sentinel1Directory {
    private final Map<Band, TiePointGeoCoding> bandGeocodingMap = new HashMap<Band, TiePointGeoCoding>(5);
    private final transient Map<String, String> imgBandMetadataMap = new HashMap<String, String>(4);
    private String acqMode = "";
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");

    public Sentinel1Level1Directory(File inputFile) {
        super(inputFile);
    }

    @Override
    protected String getHeaderFileName() {
        return "manifest.safe";
    }

    @Override
    protected String getRelativePathToImageFolder() {
        return this.getRootFolder() + "measurement" + '/';
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
        String name = Sentinel1Level1Directory.getBandFileNameFromImage(imgPath);
        if (name.endsWith("tiff")) {
            try {
                Dimension bandDimensions = Sentinel1Level1Directory.getBandDimensions(newRoot, this.imgBandMetadataMap.get(name));
                InputStream inStream = this.getInputStream(imgPath);
                ImageInputStream imgStream = ImageIOFile.createImageInputStream(inStream, bandDimensions);
                ImageIOFile img = this.isSLC() ? new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), 1, 1, 12, this.productInputFile) : new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), 1, 1, 12, this.productInputFile);
                this.bandImageFileMap.put(img.getName(), img);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(imgPath + " not found");
            }
        }
    }

    @Override
    protected void addBands(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int cnt = 1;
        for (Map.Entry stringImageIOFileEntry : this.bandImageFileMap.entrySet()) {
            ImageIOFile img = (ImageIOFile)stringImageIOFileEntry.getValue();
            String imgName = img.getName().toLowerCase();
            MetadataElement bandMetadata = absRoot.getElement(this.imgBandMetadataMap.get(imgName));
            String swath = bandMetadata.getAttributeString("swath");
            String pol = bandMetadata.getAttributeString("polarization");
            int width = bandMetadata.getAttributeInt("num_samples_per_line");
            int height = bandMetadata.getAttributeInt("num_output_lines");
            int numImages = img.getNumImages();
            String tpgPrefix = "";
            String suffix = pol;
            if (this.isSLC()) {
                numImages *= 2;
                if (this.isTOPSAR()) {
                    suffix = swath + '_' + pol;
                    tpgPrefix = swath;
                } else if (this.acqMode.equals("WV")) {
                    suffix = suffix + '_' + cnt;
                    ++cnt;
                }
            }
            boolean real = true;
            Band lastRealBand = null;
            for (int i = 0; i < numImages; ++i) {
                String bandName;
                if (this.isSLC()) {
                    for (int b = 0; b < img.getNumBands(); ++b) {
                        String unit;
                        if (real) {
                            bandName = "i_" + suffix;
                            unit = "real";
                        } else {
                            bandName = "q_" + suffix;
                            unit = "imaginary";
                        }
                        Band band = new Band(bandName, 11, width, height);
                        band.setUnit(unit);
                        product.addBand(band);
                        this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                        AbstractMetadata.addBandToBandMap((MetadataElement)bandMetadata, (String)bandName);
                        if (real) {
                            lastRealBand = band;
                        } else {
                            ReaderUtils.createVirtualIntensityBand((Product)product, (Band)lastRealBand, (Band)band, (String)('_' + suffix));
                        }
                        real = !real;
                        this.addTiePointGrids(band, imgName, tpgPrefix);
                        product.setSceneGeoCoding(null);
                    }
                    continue;
                }
                for (int b = 0; b < img.getNumBands(); ++b) {
                    bandName = "Amplitude_" + suffix;
                    Band band = new Band(bandName, 12, width, height);
                    band.setUnit("amplitude");
                    band.setNoDataValueUsed(true);
                    band.setNoDataValue(0.0);
                    product.addBand(band);
                    this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                    AbstractMetadata.addBandToBandMap((MetadataElement)bandMetadata, (String)bandName);
                    SARReader.createVirtualIntensityBand(product, band, '_' + suffix);
                    this.addTiePointGrids(band, imgName, tpgPrefix);
                }
            }
        }
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        Sentinel1Level1Directory.addManifestMetadata(this.getProductName(), absRoot, origProdRoot, false);
        this.acqMode = absRoot.getAttributeString("ACQUISITION_MODE");
        this.setSLC(absRoot.getAttributeString("SAMPLE_TYPE").equals("COMPLEX"));
        this.addBandAbstractedMetadata(absRoot, origProdRoot);
        this.addCalibrationAbstractedMetadata(origProdRoot);
        this.addNoiseAbstractedMetadata(origProdRoot);
    }

    static void addManifestMetadata(String productName, MetadataElement absRoot, MetadataElement origProdRoot, boolean isOCN) {
        MetadataElement[] metadataObjectList;
        String defStr = "-";
        int defInt = 99999;
        MetadataElement XFDU = origProdRoot.getElement("XFDU");
        MetadataElement informationPackageMap = XFDU.getElement("informationPackageMap");
        MetadataElement contentUnit = informationPackageMap.getElement("contentUnit");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)productName);
        String descriptor = contentUnit.getAttributeString("textInfo", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)descriptor);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)"right");
        MetadataElement metadataSection = XFDU.getElement("metadataSection");
        for (MetadataElement metadataObject : metadataObjectList = metadataSection.getElements()) {
            String id = metadataObject.getAttributeString("ID", "-");
            if (id.endsWith("Annotation") || id.endsWith("Schema")) continue;
            if (id.equals("processing")) {
                MetadataElement processing = Sentinel1Level1Directory.findElement(metadataObject, "processing");
                MetadataElement facility = processing.getElement("facility");
                MetadataElement software = facility.getElement("software");
                String org = facility.getAttributeString("organisation");
                String name = software.getAttributeString("name");
                String version = software.getAttributeString("version");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)(org + ' ' + name + ' ' + version));
                ProductData.UTC start = Sentinel1Level1Directory.getTime(processing, "start");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)start);
                continue;
            }
            if (id.equals("acquisitionPeriod")) {
                MetadataElement acquisitionPeriod = Sentinel1Level1Directory.findElement(metadataObject, "acquisitionPeriod");
                ProductData.UTC startTime = Sentinel1Level1Directory.getTime(acquisitionPeriod, "startTime");
                ProductData.UTC stopTime = Sentinel1Level1Directory.getTime(acquisitionPeriod, "stopTime");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
                continue;
            }
            if (id.equals("platform")) {
                MetadataElement instrumentModeElem;
                MetadataElement extensionElem;
                MetadataElement platform = Sentinel1Level1Directory.findElement(metadataObject, "platform");
                String missionName = platform.getAttributeString("familyName", "Sentinel-1");
                String number = platform.getAttributeString("number", "-");
                if (!missionName.equals("ENVISAT")) {
                    missionName = missionName + number;
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)missionName);
                MetadataElement instrument = platform.getElement("instrument");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SWATH", (String)instrument.getAttributeString("swath", "-"));
                String acqMode = instrument.getAttributeString("mode", "-");
                if ((acqMode == null || acqMode.equals("-")) && (extensionElem = instrument.getElement("extension")) != null && (instrumentModeElem = extensionElem.getElement("instrumentMode")) != null) {
                    acqMode = instrumentModeElem.getAttributeString("mode", "-");
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)acqMode);
                continue;
            }
            if (id.equals("measurementOrbitReference")) {
                MetadataElement orbitReference = Sentinel1Level1Directory.findElement(metadataObject, "orbitReference");
                MetadataElement orbitNumber = Sentinel1Level1Directory.findElementContaining(orbitReference, "OrbitNumber", "type", "start");
                MetadataElement relativeOrbitNumber = Sentinel1Level1Directory.findElementContaining(orbitReference, "relativeOrbitNumber", "type", "start");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)orbitNumber.getAttributeInt("orbitNumber", 99999));
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"REL_ORBIT", (int)relativeOrbitNumber.getAttributeInt("relativeOrbitNumber", 99999));
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_cycle", (int)orbitReference.getAttributeInt("cycleNumber", 99999));
                String pass = orbitReference.getAttributeString("pass", "-");
                if (pass.equals("-")) {
                    MetadataElement extension = orbitReference.getElement("extension");
                    MetadataElement orbitProperties = extension.getElement("orbitProperties");
                    pass = orbitProperties.getAttributeString("pass", "-");
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)pass);
                continue;
            }
            if (id.equals("measurementFrameSet") || !id.equals("generalProductInformation")) continue;
            MetadataElement generalProductInformation = Sentinel1Level1Directory.findElement(metadataObject, "generalProductInformation");
            if (generalProductInformation == null) {
                generalProductInformation = Sentinel1Level1Directory.findElement(metadataObject, "standAloneProductInformation");
            }
            String productType = "unknown";
            if (isOCN) {
                productType = "OCN";
            } else if (generalProductInformation != null) {
                productType = generalProductInformation.getAttributeString("productType", "-");
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)productType);
            if (productType.contains("SLC")) {
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)"COMPLEX");
                continue;
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)"DETECTED");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)1);
        }
    }

    private void determineProductDimensions(MetadataElement absRoot) throws IOException {
        int totalWidth = 0;
        int maxHeight = 0;
        int k = 0;
        String pol = null;
        for (Map.Entry stringImageIOFileEntry : this.bandImageFileMap.entrySet()) {
            ImageIOFile img = (ImageIOFile)stringImageIOFileEntry.getValue();
            String imgName = img.getName().toLowerCase();
            String bandMetadataName = this.imgBandMetadataMap.get(imgName);
            if (bandMetadataName == null) {
                throw new IOException("Metadata for measurement dataset " + imgName + " not found");
            }
            if (k == 0) {
                pol = bandMetadataName.substring(bandMetadataName.lastIndexOf("_") + 1);
            } else if (!bandMetadataName.substring(bandMetadataName.lastIndexOf("_") + 1).equals(pol)) continue;
            ++k;
            MetadataElement bandMetadata = absRoot.getElement(bandMetadataName);
            int width = bandMetadata.getAttributeInt("num_samples_per_line");
            int height = bandMetadata.getAttributeInt("num_output_lines");
            totalWidth += width;
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        if (this.isSLC() && this.isTOPSAR()) {
            absRoot.setAttributeInt("num_samples_per_line", totalWidth);
            absRoot.setAttributeInt("num_output_lines", maxHeight);
        }
    }

    private void addBandAbstractedMetadata(MetadataElement absRoot, MetadataElement origProdRoot) throws IOException {
        MetadataElement annotationElement = origProdRoot.getElement("annotation");
        if (annotationElement == null) {
            annotationElement = new MetadataElement("annotation");
            origProdRoot.addElement(annotationElement);
        }
        double rangeSpacingTotal = 0.0;
        double azimuthSpacingTotal = 0.0;
        boolean commonMetadataRetrieved = false;
        double heightSum = 0.0;
        int numBands = 0;
        String annotFolder = this.getRootFolder() + "annotation";
        String[] filenames = this.listFiles(annotFolder);
        if (filenames != null) {
            for (String metadataFile : filenames) {
                Document xmlDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(annotFolder + '/' + metadataFile));
                Element rootElement = xmlDoc.getRootElement();
                MetadataElement nameElem = new MetadataElement(metadataFile);
                annotationElement.addElement(nameElem);
                AbstractMetadataIO.AddXMLMetadata((Element)rootElement, (MetadataElement)nameElem);
                MetadataElement prodElem = nameElem.getElement("product");
                MetadataElement adsHeader = prodElem.getElement("adsHeader");
                String swath = adsHeader.getAttributeString("swath");
                String pol = adsHeader.getAttributeString("polarisation");
                ProductData.UTC startTime = Sentinel1Level1Directory.getTime(adsHeader, "startTime");
                ProductData.UTC stopTime = Sentinel1Level1Directory.getTime(adsHeader, "stopTime");
                String bandRootName = "Band_" + swath + '_' + pol;
                MetadataElement bandAbsRoot = AbstractMetadata.addBandAbstractedMetadata((MetadataElement)absRoot, (String)bandRootName);
                String imgName = FileUtils.exchangeExtension((String)metadataFile, (String)".tiff");
                this.imgBandMetadataMap.put(imgName, bandRootName);
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"SWATH", (String)swath);
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"polarization", (String)pol);
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"annotation", (String)metadataFile);
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"first_line_time", (ProductData.UTC)startTime);
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
                if (AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"mds1_tx_rx_polar")) {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)pol);
                } else {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds2_tx_rx_polar", (String)pol);
                }
                MetadataElement imageAnnotation = prodElem.getElement("imageAnnotation");
                MetadataElement imageInformation = imageAnnotation.getElement("imageInformation");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"data_take_id", (int)Integer.parseInt(adsHeader.getAttributeString("missionDataTakeId")));
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slice_num", (int)Integer.parseInt(imageInformation.getAttributeString("sliceNumber")));
                rangeSpacingTotal += imageInformation.getAttributeDouble("rangePixelSpacing");
                azimuthSpacingTotal += imageInformation.getAttributeDouble("azimuthPixelSpacing");
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"line_time_interval", (double)imageInformation.getAttributeDouble("azimuthTimeInterval"));
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"num_samples_per_line", (int)imageInformation.getAttributeInt("numberOfSamples"));
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"num_output_lines", (int)imageInformation.getAttributeInt("numberOfLines"));
                AbstractMetadata.setAttribute((MetadataElement)bandAbsRoot, (String)"sample_type", (String)imageInformation.getAttributeString("pixelValue").toUpperCase());
                heightSum += this.getBandTerrainHeight(prodElem);
                if (!commonMetadataRetrieved) {
                    MetadataElement generalAnnotation = prodElem.getElement("generalAnnotation");
                    MetadataElement productInformation = generalAnnotation.getElement("productInformation");
                    MetadataElement processingInformation = imageAnnotation.getElement("processingInformation");
                    MetadataElement swathProcParamsList = processingInformation.getElement("swathProcParamsList");
                    MetadataElement swathProcParams = swathProcParamsList.getElement("swathProcParams");
                    MetadataElement rangeProcessing = swathProcParams.getElement("rangeProcessing");
                    MetadataElement azimuthProcessing = swathProcParams.getElement("azimuthProcessing");
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (double)(productInformation.getAttributeDouble("rangeSamplingRate") / 1000000.0));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)(productInformation.getAttributeDouble("radarFrequency") / 1000000.0));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)imageInformation.getAttributeDouble("azimuthTimeInterval"));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(imageInformation.getAttributeDouble("slantRangeTime") * 1.49896229E8));
                    MetadataElement downlinkInformationList = generalAnnotation.getElement("downlinkInformationList");
                    MetadataElement downlinkInformation = downlinkInformationList.getElement("downlinkInformation");
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)downlinkInformation.getAttributeDouble("prf"));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeProcessing.getAttributeDouble("processingBandwidth") / 1000000.0));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthProcessing.getAttributeDouble("processingBandwidth"));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (double)rangeProcessing.getAttributeDouble("numberOfLooks"));
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (double)azimuthProcessing.getAttributeDouble("numberOfLooks"));
                    if (!this.isTOPSAR() || !this.isSLC()) {
                        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)imageInformation.getAttributeInt("numberOfLines"));
                        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)imageInformation.getAttributeInt("numberOfSamples"));
                    }
                    Sentinel1Level1Directory.addOrbitStateVectors(absRoot, generalAnnotation.getElement("orbitList"));
                    Sentinel1Level1Directory.addSRGRCoefficients(absRoot, prodElem.getElement("coordinateConversion"));
                    Sentinel1Level1Directory.addDopplerCentroidCoefficients(absRoot, prodElem.getElement("dopplerCentroid"));
                    commonMetadataRetrieved = true;
                }
                ++numBands;
            }
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)(rangeSpacingTotal / (double)numBands));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)(azimuthSpacingTotal / (double)numBands));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"avg_scene_height", (double)(heightSum / (double)filenames.length));
    }

    private double getBandTerrainHeight(MetadataElement prodElem) {
        MetadataElement generalAnnotation = prodElem.getElement("generalAnnotation");
        MetadataElement terrainHeightList = generalAnnotation.getElement("terrainHeightList");
        double heightSum = 0.0;
        MetadataElement[] heightList = terrainHeightList.getElements();
        int cnt = 0;
        for (MetadataElement terrainHeight : heightList) {
            heightSum += terrainHeight.getAttributeDouble("value");
            ++cnt;
        }
        return heightSum / (double)cnt;
    }

    private void addCalibrationAbstractedMetadata(MetadataElement origProdRoot) throws IOException {
        String calibFolder;
        String[] filenames;
        MetadataElement calibrationElement = origProdRoot.getElement("calibration");
        if (calibrationElement == null) {
            calibrationElement = new MetadataElement("calibration");
            origProdRoot.addElement(calibrationElement);
        }
        if ((filenames = this.listFiles(calibFolder = this.getRootFolder() + "annotation" + '/' + "calibration")) != null) {
            for (String metadataFile : filenames) {
                if (!metadataFile.startsWith("calibration")) continue;
                Document xmlDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(calibFolder + '/' + metadataFile));
                Element rootElement = xmlDoc.getRootElement();
                String name = metadataFile.replace("calibration-", "");
                MetadataElement nameElem = new MetadataElement(name);
                calibrationElement.addElement(nameElem);
                AbstractMetadataIO.AddXMLMetadata((Element)rootElement, (MetadataElement)nameElem);
            }
        }
    }

    private void addNoiseAbstractedMetadata(MetadataElement origProdRoot) throws IOException {
        String calibFolder;
        String[] filenames;
        MetadataElement noiseElement = origProdRoot.getElement("noise");
        if (noiseElement == null) {
            noiseElement = new MetadataElement("noise");
            origProdRoot.addElement(noiseElement);
        }
        if ((filenames = this.listFiles(calibFolder = this.getRootFolder() + "annotation" + '/' + "calibration")) != null) {
            for (String metadataFile : filenames) {
                if (!metadataFile.startsWith("noise")) continue;
                Document xmlDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(calibFolder + '/' + metadataFile));
                Element rootElement = xmlDoc.getRootElement();
                String name = metadataFile.replace("noise-", "");
                MetadataElement nameElem = new MetadataElement(name);
                noiseElement.addElement(nameElem);
                AbstractMetadataIO.AddXMLMetadata((Element)rootElement, (MetadataElement)nameElem);
            }
        }
    }

    private static MetadataElement findElement(MetadataElement elem, String name) {
        MetadataElement metadataWrap = elem.getElement("metadataWrap");
        MetadataElement xmlData = metadataWrap.getElement("xmlData");
        return xmlData.getElement(name);
    }

    private static MetadataElement findElementContaining(MetadataElement parent, String elemName, String attribName, String attValue) {
        MetadataElement[] elems;
        for (MetadataElement elem : elems = parent.getElements()) {
            String value;
            if (!elem.getName().equalsIgnoreCase(elemName) || !elem.containsAttribute(attribName) || (value = elem.getAttributeString(attribName)) == null || !value.equalsIgnoreCase(attValue)) continue;
            return elem;
        }
        return null;
    }

    private static void addOrbitStateVectors(MetadataElement absRoot, MetadataElement orbitList) {
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        MetadataElement[] stateVectorElems = orbitList.getElements();
        for (int i = 1; i <= stateVectorElems.length; ++i) {
            Sentinel1Level1Directory.addVector("orbit_vector", orbitVectorListElem, stateVectorElems[i - 1], i);
        }
        if (absRoot.getAttributeUTC("STATE_VECTOR_TIME", AbstractMetadata.NO_METADATA_UTC).equalElems((ProductData)AbstractMetadata.NO_METADATA_UTC)) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)stateVectorElems[0], (String)"time", (DateFormat)standardDateFormat));
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, MetadataElement orbitElem, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        MetadataElement positionElem = orbitElem.getElement("position");
        MetadataElement velocityElem = orbitElem.getElement("velocity");
        orbitVectorElem.setAttributeUTC("time", ReaderUtils.getTime((MetadataElement)orbitElem, (String)"time", (DateFormat)standardDateFormat));
        orbitVectorElem.setAttributeDouble("x_pos", positionElem.getAttributeDouble("x", 0.0));
        orbitVectorElem.setAttributeDouble("y_pos", positionElem.getAttributeDouble("y", 0.0));
        orbitVectorElem.setAttributeDouble("z_pos", positionElem.getAttributeDouble("z", 0.0));
        orbitVectorElem.setAttributeDouble("x_vel", velocityElem.getAttributeDouble("x", 0.0));
        orbitVectorElem.setAttributeDouble("y_vel", velocityElem.getAttributeDouble("y", 0.0));
        orbitVectorElem.setAttributeDouble("z_vel", velocityElem.getAttributeDouble("z", 0.0));
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    private static void addSRGRCoefficients(MetadataElement absRoot, MetadataElement coordinateConversion) {
        if (coordinateConversion == null) {
            return;
        }
        MetadataElement coordinateConversionList = coordinateConversion.getElement("coordinateConversionList");
        if (coordinateConversionList == null) {
            return;
        }
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        int listCnt = 1;
        for (MetadataElement elem : coordinateConversionList.getElements()) {
            MetadataElement srgrListElem = new MetadataElement("srgr_coef_list." + listCnt);
            srgrCoefficientsElem.addElement(srgrListElem);
            ++listCnt;
            ProductData.UTC utcTime = ReaderUtils.getTime((MetadataElement)elem, (String)"azimuthTime", (DateFormat)standardDateFormat);
            srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
            double grOrigin = elem.getAttributeDouble("gr0", 0.0);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
            AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)grOrigin);
            String coeffStr = elem.getElement("grsrCoefficients").getAttributeString("grsrCoefficients", "");
            if (coeffStr.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(coeffStr);
            int cnt = 1;
            while (st.hasMoreTokens()) {
                double coefValue = Double.parseDouble(st.nextToken());
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                srgrListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
                AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)coefValue);
            }
        }
    }

    private static void addDopplerCentroidCoefficients(MetadataElement absRoot, MetadataElement dopplerCentroid) {
        if (dopplerCentroid == null) {
            return;
        }
        MetadataElement dcEstimateList = dopplerCentroid.getElement("dcEstimateList");
        if (dcEstimateList == null) {
            return;
        }
        MetadataElement dopplerCentroidCoefficientsElem = absRoot.getElement("Doppler_Centroid_Coefficients");
        int listCnt = 1;
        for (MetadataElement elem : dcEstimateList.getElements()) {
            MetadataElement dopplerListElem = new MetadataElement("dop_coef_list." + listCnt);
            dopplerCentroidCoefficientsElem.addElement(dopplerListElem);
            ++listCnt;
            ProductData.UTC utcTime = ReaderUtils.getTime((MetadataElement)elem, (String)"azimuthTime", (DateFormat)standardDateFormat);
            dopplerListElem.setAttributeUTC("zero_doppler_time", utcTime);
            double refTime = elem.getAttributeDouble("t0", 0.0) * 1.0E9;
            AbstractMetadata.addAbstractedAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (int)31, (String)"ns", (String)"Slant Range Time");
            AbstractMetadata.setAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (double)refTime);
            String coeffStr = elem.getElement("geometryDcPolynomial").getAttributeString("geometryDcPolynomial", "");
            if (coeffStr.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(coeffStr);
            int cnt = 1;
            while (st.hasMoreTokens()) {
                double coefValue = Double.parseDouble(st.nextToken());
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                dopplerListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"dop_coef", (int)31, (String)"", (String)"Doppler Centroid Coefficient");
                AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"dop_coef", (double)coefValue);
            }
        }
    }

    @Override
    protected void addGeoCoding(Product product) {
        Band[] bands;
        int numOfSubSwath;
        String acquisitionMode;
        TiePointGrid latGrid = product.getTiePointGrid("latitude");
        TiePointGrid lonGrid = product.getTiePointGrid("longitude");
        if (latGrid != null && lonGrid != null) {
            Sentinel1Level1Directory.setLatLongMetadata(product, latGrid, lonGrid);
            TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
            product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
            return;
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        switch (acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE")) {
            case "IW": {
                numOfSubSwath = 3;
                break;
            }
            case "EW": {
                numOfSubSwath = 5;
                break;
            }
            default: {
                return;
            }
        }
        String[] bandNames = product.getBandNames();
        Band firstSWBand = null;
        Band lastSWBand = null;
        boolean firstSWBandFound = false;
        boolean lastSWBandFound = false;
        for (String bandName : bandNames) {
            if (!firstSWBandFound && bandName.contains(acquisitionMode + 1)) {
                firstSWBand = product.getBand(bandName);
                firstSWBandFound = true;
            }
            if (lastSWBandFound || !bandName.contains(acquisitionMode + numOfSubSwath)) continue;
            lastSWBand = product.getBand(bandName);
            lastSWBandFound = true;
        }
        if (firstSWBand == null && lastSWBand == null) {
            return;
        }
        GeoCoding firstSWBandGeoCoding = (GeoCoding)this.bandGeocodingMap.get(firstSWBand);
        int firstSWBandHeight = firstSWBand.getRasterHeight();
        GeoCoding lastSWBandGeoCoding = (GeoCoding)this.bandGeocodingMap.get(lastSWBand);
        int lastSWBandWidth = lastSWBand.getRasterWidth();
        int lastSWBandHeight = lastSWBand.getRasterHeight();
        PixelPos ulPix = new PixelPos(0.0, 0.0);
        PixelPos llPix = new PixelPos(0.0, (double)(firstSWBandHeight - 1));
        GeoPos ulGeo = new GeoPos();
        GeoPos llGeo = new GeoPos();
        firstSWBandGeoCoding.getGeoPos(ulPix, ulGeo);
        firstSWBandGeoCoding.getGeoPos(llPix, llGeo);
        PixelPos urPix = new PixelPos((double)(lastSWBandWidth - 1), 0.0);
        PixelPos lrPix = new PixelPos((double)(lastSWBandWidth - 1), (double)(lastSWBandHeight - 1));
        GeoPos urGeo = new GeoPos();
        GeoPos lrGeo = new GeoPos();
        lastSWBandGeoCoding.getGeoPos(urPix, urGeo);
        lastSWBandGeoCoding.getGeoPos(lrPix, lrGeo);
        float[] latCorners = new float[]{(float)ulGeo.getLat(), (float)urGeo.getLat(), (float)llGeo.getLat(), (float)lrGeo.getLat()};
        float[] lonCorners = new float[]{(float)ulGeo.getLon(), (float)urGeo.getLon(), (float)llGeo.getLon(), (float)lrGeo.getLon()};
        ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)ulGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)ulGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)urGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)urGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)llGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)llGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)lrGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)lrGeo.getLon());
        for (Band band : bands = product.getBands()) {
            band.setGeoCoding((GeoCoding)this.bandGeocodingMap.get(band));
        }
    }

    @Override
    protected void addTiePointGrids(Product product) {
    }

    private void addTiePointGrids(Band band, String imgXMLName, String tpgPrefix) {
        TiePointGrid lonGrid;
        Product product = band.getProduct();
        String pre = "";
        if (!tpgPrefix.isEmpty()) {
            pre = tpgPrefix + '_';
        }
        TiePointGrid existingLatTPG = product.getTiePointGrid(pre + "latitude");
        TiePointGrid existingLonTPG = product.getTiePointGrid(pre + "longitude");
        if (existingLatTPG != null && existingLonTPG != null) {
            TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(existingLatTPG, existingLonTPG);
            band.setGeoCoding((GeoCoding)tpGeoCoding);
            return;
        }
        String annotation = FileUtils.exchangeExtension((String)imgXMLName, (String)".xml");
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement annotationElem = origProdRoot.getElement("annotation");
        MetadataElement imgElem = annotationElem.getElement(annotation);
        MetadataElement productElem = imgElem.getElement("product");
        MetadataElement geolocationGrid = productElem.getElement("geolocationGrid");
        MetadataElement geolocationGridPointList = geolocationGrid.getElement("geolocationGridPointList");
        MetadataElement[] geoGrid = geolocationGridPointList.getElements();
        double[] latList = new double[geoGrid.length];
        double[] lngList = new double[geoGrid.length];
        double[] incidenceAngleList = new double[geoGrid.length];
        double[] elevAngleList = new double[geoGrid.length];
        double[] rangeTimeList = new double[geoGrid.length];
        int[] x = new int[geoGrid.length];
        int[] y = new int[geoGrid.length];
        int gridWidth = 0;
        int gridHeight = 0;
        int i = 0;
        for (MetadataElement ggPoint : geoGrid) {
            latList[i] = ggPoint.getAttributeDouble("latitude", 0.0);
            lngList[i] = ggPoint.getAttributeDouble("longitude", 0.0);
            incidenceAngleList[i] = ggPoint.getAttributeDouble("incidenceAngle", 0.0);
            elevAngleList[i] = ggPoint.getAttributeDouble("elevationAngle", 0.0);
            rangeTimeList[i] = ggPoint.getAttributeDouble("slantRangeTime", 0.0) * 1.0E9;
            x[i] = (int)ggPoint.getAttributeDouble("pixel", 0.0);
            y[i] = (int)ggPoint.getAttributeDouble("line", 0.0);
            if (x[i] == 0) {
                if (gridWidth == 0) {
                    gridWidth = i;
                }
                ++gridHeight;
            }
            ++i;
        }
        int newGridWidth = gridWidth;
        int newGridHeight = gridHeight;
        float[] newLatList = new float[newGridWidth * newGridHeight];
        float[] newLonList = new float[newGridWidth * newGridHeight];
        float[] newIncList = new float[newGridWidth * newGridHeight];
        float[] newElevList = new float[newGridWidth * newGridHeight];
        float[] newslrtList = new float[newGridWidth * newGridHeight];
        int sceneRasterWidth = band.getRasterWidth();
        int sceneRasterHeight = band.getRasterHeight();
        double subSamplingX = (double)sceneRasterWidth / (double)(newGridWidth - 1);
        double subSamplingY = (double)sceneRasterHeight / (double)(newGridHeight - 1);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, latList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLatList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, lngList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLonList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, incidenceAngleList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newIncList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, elevAngleList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newElevList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, rangeTimeList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newslrtList);
        TiePointGrid latGrid = product.getTiePointGrid(pre + "latitude");
        if (latGrid == null) {
            latGrid = new TiePointGrid(pre + "latitude", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLatList);
            latGrid.setUnit("deg");
            product.addTiePointGrid(latGrid);
        }
        if ((lonGrid = product.getTiePointGrid(pre + "longitude")) == null) {
            lonGrid = new TiePointGrid(pre + "longitude", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLonList, 180);
            lonGrid.setUnit("deg");
            product.addTiePointGrid(lonGrid);
        }
        if (product.getTiePointGrid(pre + "incident_angle") == null) {
            TiePointGrid incidentAngleGrid = new TiePointGrid(pre + "incident_angle", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newIncList);
            incidentAngleGrid.setUnit("deg");
            product.addTiePointGrid(incidentAngleGrid);
        }
        if (product.getTiePointGrid(pre + "elevation_angle") == null) {
            TiePointGrid elevAngleGrid = new TiePointGrid(pre + "elevation_angle", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newElevList);
            elevAngleGrid.setUnit("deg");
            product.addTiePointGrid(elevAngleGrid);
        }
        if (product.getTiePointGrid(pre + "slant_range_time") == null) {
            TiePointGrid slantRangeGrid = new TiePointGrid(pre + "slant_range_time", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newslrtList);
            slantRangeGrid.setUnit("ns");
            product.addTiePointGrid(slantRangeGrid);
        }
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        this.bandGeocodingMap.put(band, tpGeoCoding);
    }

    private static void setLatLongMetadata(Product product, TiePointGrid latGrid, TiePointGrid lonGrid) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)latGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)lonGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)latGrid.getPixelDouble(w, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)lonGrid.getPixelDouble(w, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)latGrid.getPixelDouble(0, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)lonGrid.getPixelDouble(0, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)latGrid.getPixelDouble(w, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)lonGrid.getPixelDouble(w, h));
    }

    private boolean isTOPSAR() {
        return this.acqMode.equals("IW") || this.acqMode.equals("EW");
    }

    @Override
    protected String getProductName() {
        String name = this.getBaseName();
        if (name.toUpperCase().endsWith(".SAFE")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.toUpperCase().endsWith(".ZIP")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    @Override
    protected String getProductType() {
        return "Level-1";
    }

    public static void getListInEvenlySpacedGrid(int sceneRasterWidth, int sceneRasterHeight, int sourceGridWidth, int sourceGridHeight, int[] x, int[] y, double[] sourcePointList, int targetGridWidth, int targetGridHeight, double subSamplingX, double subSamplingY, float[] targetPointList) {
        if (sourcePointList.length != sourceGridWidth * sourceGridHeight) {
            throw new IllegalArgumentException("Original tie point array size does not match 'sourceGridWidth' x 'sourceGridHeight'");
        }
        if (targetPointList.length != targetGridWidth * targetGridHeight) {
            throw new IllegalArgumentException("Target tie point array size does not match 'targetGridWidth' x 'targetGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < targetGridHeight; ++r) {
            double newY = (double)r * subSamplingY;
            if (newY > (double)(sceneRasterHeight - 1)) {
                newY = sceneRasterHeight - 1;
            }
            double oldY0 = 0.0;
            double oldY1 = 0.0;
            int j0 = 0;
            int j1 = 0;
            int rr = 1;
            while (rr < sourceGridHeight) {
                j0 = rr - 1;
                j1 = rr++;
                oldY0 = y[j0 * sourceGridWidth];
                oldY1 = y[j1 * sourceGridWidth];
                if (oldY1 > newY) break;
            }
            double wj = (newY - oldY0) / (oldY1 - oldY0);
            for (int c = 0; c < targetGridWidth; ++c) {
                double newX = (double)c * subSamplingX;
                if (newX > (double)(sceneRasterWidth - 1)) {
                    newX = sceneRasterWidth - 1;
                }
                double oldX0 = 0.0;
                double oldX1 = 0.0;
                int i0 = 0;
                int i1 = 0;
                int cc = 1;
                while (cc < sourceGridWidth) {
                    i0 = cc - 1;
                    i1 = cc++;
                    oldX0 = x[i0];
                    oldX1 = x[i1];
                    if (oldX1 > newX) break;
                }
                double wi = (newX - oldX0) / (oldX1 - oldX0);
                targetPointList[k++] = (float)MathUtils.interpolate2D((double)wi, (double)wj, (double)sourcePointList[i0 + j0 * sourceGridWidth], (double)sourcePointList[i1 + j0 * sourceGridWidth], (double)sourcePointList[i0 + j1 * sourceGridWidth], (double)sourcePointList[i1 + j1 * sourceGridWidth]);
            }
        }
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag) {
        String start = elem.getAttributeString(tag, "-");
        start = start.replace("T", "_");
        return AbstractMetadata.parseUTC((String)start, (DateFormat)Sentinel1Constants.sentinelDateFormat);
    }

    @Override
    public Product createProduct() throws IOException {
        MetadataElement newRoot = this.addMetaData();
        this.findImages(newRoot);
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        this.determineProductDimensions(absRoot);
        int sceneWidth = absRoot.getAttributeInt("num_samples_per_line");
        int sceneHeight = absRoot.getAttributeInt("num_output_lines");
        Product product = new Product(this.getProductName(), this.getProductType(), sceneWidth, sceneHeight);
        Sentinel1Level1Directory.updateProduct(product, newRoot);
        this.addBands(product);
        this.addGeoCoding(product);
        product.setName(this.getProductName());
        product.setDescription(this.getProductDescription());
        ReaderUtils.addMetadataIncidenceAngles((Product)product);
        ReaderUtils.addMetadataProductSize((Product)product);
        return product;
    }
}

