/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.sentinel1.Sentinel1Constants;
import org.esa.s1tbx.io.sentinel1.Sentinel1Directory;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level0Reader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class Sentinel1Level0Directory
extends XMLProductDirectory
implements Sentinel1Directory {
    private final transient Map<String, String> imgBandMetadataMap = new HashMap<String, String>(4);
    private String acqMode = "";

    public Sentinel1Level0Directory(File headerFile) {
        super(headerFile);
    }

    @Override
    protected String getHeaderFileName() {
        return "manifest.safe";
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
    }

    @Override
    protected void addBands(Product product) {
        boolean real = true;
        Band lastRealBand = null;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        for (Map.Entry stringImageIOFileEntry : this.bandImageFileMap.entrySet()) {
            ImageIOFile img = (ImageIOFile)stringImageIOFileEntry.getValue();
            String imgName = img.getName().toLowerCase();
            MetadataElement bandMetadata = absRoot.getElement(this.imgBandMetadataMap.get(imgName));
            String swath = bandMetadata.getAttributeString("swath");
            String pol = bandMetadata.getAttributeString("polarization");
            int width = bandMetadata.getAttributeInt("num_samples_per_line");
            int height = bandMetadata.getAttributeInt("num_output_lines");
            String tpgPrefix = "";
            String suffix = pol;
            if (this.isSLC() && this.isTOPSAR()) {
                suffix = swath + '_' + pol;
                tpgPrefix = swath;
            }
            int numImages = img.getNumImages();
            if (this.isSLC()) {
                numImages *= 2;
            }
            for (int i = 0; i < numImages; ++i) {
                Band band;
                String bandName;
                int b;
                if (this.isSLC()) {
                    for (b = 0; b < img.getNumBands(); ++b) {
                        String unit;
                        if (real) {
                            bandName = "i_" + suffix;
                            unit = "real";
                        } else {
                            bandName = "q_" + suffix;
                            unit = "imaginary";
                        }
                        band = new Band(bandName, 11, width, height);
                        band.setUnit(unit);
                        product.addBand(band);
                        this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                        AbstractMetadata.addBandToBandMap((MetadataElement)bandMetadata, (String)bandName);
                        if (real) {
                            lastRealBand = band;
                        } else {
                            ReaderUtils.createVirtualIntensityBand((Product)product, (Band)lastRealBand, (Band)band, (String)('_' + suffix));
                        }
                        real = !real;
                        Sentinel1Level0Directory.addTiePointGrids(band, imgName, tpgPrefix);
                    }
                    continue;
                }
                for (b = 0; b < img.getNumBands(); ++b) {
                    bandName = "Amplitude_" + suffix;
                    band = new Band(bandName, 12, width, height);
                    band.setUnit("amplitude");
                    product.addBand(band);
                    this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                    AbstractMetadata.addBandToBandMap((MetadataElement)bandMetadata, (String)bandName);
                    Sentinel1Level0Directory.addTiePointGrids(band, imgName, tpgPrefix);
                }
            }
        }
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        MetadataElement[] metadataObjectList;
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        String defStr = "-";
        int defInt = 99999;
        MetadataElement XFDU = origProdRoot.getElement("XFDU");
        MetadataElement informationPackageMap = XFDU.getElement("informationPackageMap");
        MetadataElement contentUnit = informationPackageMap.getElement("contentUnit");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.getProductName());
        String descriptor = contentUnit.getAttributeString("textInfo", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)descriptor);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)"right");
        MetadataElement metadataSection = XFDU.getElement("metadataSection");
        for (MetadataElement metadataObject : metadataObjectList = metadataSection.getElements()) {
            String id = metadataObject.getAttributeString("ID", "-");
            if (id.endsWith("Annotation") || id.endsWith("Schema")) continue;
            if (id.equals("processing")) {
                MetadataElement software;
                MetadataElement processing = Sentinel1Level0Directory.findElement(metadataObject, "processing");
                MetadataElement facility = processing.getElement("facility");
                if (facility != null && (software = facility.getElement("software")) != null) {
                    String org = facility.getAttributeString("organisation");
                    String name = software.getAttributeString("name");
                    String version = software.getAttributeString("version");
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)(org + ' ' + name + ' ' + version));
                }
                ProductData.UTC start = Sentinel1Level0Directory.getTime(processing, "start");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)start);
                continue;
            }
            if (id.equals("acquisitionPeriod")) {
                MetadataElement acquisitionPeriod = Sentinel1Level0Directory.findElement(metadataObject, "acquisitionPeriod");
                ProductData.UTC startTime = Sentinel1Level0Directory.getTime(acquisitionPeriod, "startTime");
                ProductData.UTC stopTime = Sentinel1Level0Directory.getTime(acquisitionPeriod, "stopTime");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
                continue;
            }
            if (id.equals("platform")) {
                MetadataElement instrumentModeElem;
                MetadataElement extensionElem;
                MetadataElement platform = Sentinel1Level0Directory.findElement(metadataObject, "platform");
                String missionName = platform.getAttributeString("familyName", "Sentinel-1");
                String number = platform.getAttributeString("number", "-");
                if (!missionName.equals("ENVISAT")) {
                    missionName = missionName + number;
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)missionName);
                MetadataElement instrument = platform.getElement("instrument");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SWATH", (String)instrument.getAttributeString("swath", "-"));
                this.acqMode = instrument.getAttributeString("mode", "-");
                if ((this.acqMode == null || this.acqMode.equals("-")) && (extensionElem = instrument.getElement("extension")) != null && (instrumentModeElem = extensionElem.getElement("instrumentMode")) != null) {
                    this.acqMode = instrumentModeElem.getAttributeString("mode", "-");
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)this.acqMode);
                continue;
            }
            if (id.equals("measurementOrbitReference")) {
                MetadataElement orbitReference = Sentinel1Level0Directory.findElement(metadataObject, "orbitReference");
                MetadataElement orbitNumber = Sentinel1Level0Directory.findElementContaining(orbitReference, "OrbitNumber", "type", "start");
                MetadataElement relativeOrbitNumber = Sentinel1Level0Directory.findElementContaining(orbitReference, "relativeOrbitNumber", "type", "start");
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)orbitNumber.getAttributeInt("orbitNumber", 99999));
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"REL_ORBIT", (int)relativeOrbitNumber.getAttributeInt("relativeOrbitNumber", 99999));
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_cycle", (int)orbitReference.getAttributeInt("cycleNumber", 99999));
                String passStr = "";
                MetadataElement orbitRef = this.getMetadataObject(origProdRoot, "measurementOrbitReference");
                if (orbitRef != null) {
                    passStr = orbitRef.getElement("metadataWrap").getElement("xmlData").getElement("orbitReference").getElement("extension").getElement("orbitProperties").getAttributeString("pass");
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)orbitReference.getAttributeString("pass", passStr));
                continue;
            }
            if (id.equals("measurementFrameSet") || !id.equals("generalProductInformation")) continue;
            String productType = "Raw";
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)"Raw");
            if ("Raw".contains("SLC")) {
                this.setSLC(true);
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)"COMPLEX");
                continue;
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)"DETECTED");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)1);
        }
    }

    private static MetadataElement findElement(MetadataElement elem, String name) {
        MetadataElement metadataWrap = elem.getElement("metadataWrap");
        MetadataElement xmlData = metadataWrap.getElement("xmlData");
        return xmlData.getElement(name);
    }

    private static MetadataElement findElementContaining(MetadataElement parent, String elemName, String attribName, String attValue) {
        MetadataElement[] elems;
        for (MetadataElement elem : elems = parent.getElements()) {
            String value;
            if (!elem.getName().equalsIgnoreCase(elemName) || !elem.containsAttribute(attribName) || (value = elem.getAttributeString(attribName)) == null || !value.equalsIgnoreCase(attValue)) continue;
            return elem;
        }
        return null;
    }

    @Override
    protected void addGeoCoding(Product product) {
        this.addGeoCodingForLevel0Products(product);
    }

    @Override
    protected void addTiePointGrids(Product product) {
    }

    private static void addTiePointGrids(Band band, String imgXMLName, String tpgPrefix) {
        TiePointGrid lonGrid;
        TiePointGrid testTPG;
        Product product = band.getProduct();
        String pre = "";
        if (!tpgPrefix.isEmpty()) {
            pre = tpgPrefix + '_';
        }
        if ((testTPG = product.getTiePointGrid(pre + "latitude")) != null) {
            return;
        }
        String annotation = FileUtils.exchangeExtension((String)imgXMLName, (String)".xml");
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement annotationElem = origProdRoot.getElement("annotation");
        MetadataElement imgElem = annotationElem.getElement(annotation);
        MetadataElement productElem = imgElem.getElement("product");
        MetadataElement geolocationGrid = productElem.getElement("geolocationGrid");
        MetadataElement geolocationGridPointList = geolocationGrid.getElement("geolocationGridPointList");
        MetadataElement[] geoGrid = geolocationGridPointList.getElements();
        double[] latList = new double[geoGrid.length];
        double[] lngList = new double[geoGrid.length];
        double[] incidenceAngleList = new double[geoGrid.length];
        double[] elevAngleList = new double[geoGrid.length];
        double[] rangeTimeList = new double[geoGrid.length];
        int[] x = new int[geoGrid.length];
        int[] y = new int[geoGrid.length];
        int gridWidth = 0;
        int gridHeight = 0;
        int i = 0;
        for (MetadataElement ggPoint : geoGrid) {
            latList[i] = ggPoint.getAttributeDouble("latitude", 0.0);
            lngList[i] = ggPoint.getAttributeDouble("longitude", 0.0);
            incidenceAngleList[i] = ggPoint.getAttributeDouble("incidenceAngle", 0.0);
            elevAngleList[i] = ggPoint.getAttributeDouble("elevationAngle", 0.0);
            rangeTimeList[i] = ggPoint.getAttributeDouble("slantRangeTime", 0.0) * 1.0E9;
            x[i] = (int)ggPoint.getAttributeDouble("pixel", 0.0);
            y[i] = (int)ggPoint.getAttributeDouble("line", 0.0);
            if (x[i] == 0) {
                if (gridWidth == 0) {
                    gridWidth = i;
                }
                ++gridHeight;
            }
            ++i;
        }
        int newGridWidth = gridWidth;
        int newGridHeight = gridHeight;
        float[] newLatList = new float[newGridWidth * newGridHeight];
        float[] newLonList = new float[newGridWidth * newGridHeight];
        float[] newIncList = new float[newGridWidth * newGridHeight];
        float[] newElevList = new float[newGridWidth * newGridHeight];
        float[] newslrtList = new float[newGridWidth * newGridHeight];
        int sceneRasterWidth = product.getSceneRasterWidth();
        int sceneRasterHeight = product.getSceneRasterHeight();
        float subSamplingX = sceneRasterWidth / (newGridWidth - 1);
        float subSamplingY = sceneRasterHeight / (newGridHeight - 1);
        Sentinel1Level0Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, latList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLatList);
        Sentinel1Level0Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, lngList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLonList);
        Sentinel1Level0Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, incidenceAngleList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newIncList);
        Sentinel1Level0Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, elevAngleList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newElevList);
        Sentinel1Level0Directory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, x, y, rangeTimeList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newslrtList);
        TiePointGrid latGrid = product.getTiePointGrid(pre + "latitude");
        if (latGrid == null) {
            latGrid = new TiePointGrid(pre + "latitude", newGridWidth, newGridHeight, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, newLatList);
            latGrid.setUnit("deg");
            product.addTiePointGrid(latGrid);
        }
        if ((lonGrid = product.getTiePointGrid(pre + "longitude")) == null) {
            lonGrid = new TiePointGrid(pre + "longitude", newGridWidth, newGridHeight, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, newLonList, 180);
            lonGrid.setUnit("deg");
            product.addTiePointGrid(lonGrid);
        }
        if (product.getTiePointGrid(pre + "incident_angle") == null) {
            TiePointGrid incidentAngleGrid = new TiePointGrid(pre + "incident_angle", newGridWidth, newGridHeight, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, newIncList);
            incidentAngleGrid.setUnit("deg");
            product.addTiePointGrid(incidentAngleGrid);
        }
        if (product.getTiePointGrid(pre + "elevation_angle") == null) {
            TiePointGrid elevAngleGrid = new TiePointGrid(pre + "elevation_angle", newGridWidth, newGridHeight, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, newElevList);
            elevAngleGrid.setUnit("deg");
            product.addTiePointGrid(elevAngleGrid);
        }
        if (product.getTiePointGrid(pre + "slant_range_time") == null) {
            TiePointGrid slantRangeGrid = new TiePointGrid(pre + "slant_range_time", newGridWidth, newGridHeight, 0.5, 0.5, (double)subSamplingX, (double)subSamplingY, newslrtList);
            slantRangeGrid.setUnit("ns");
            product.addTiePointGrid(slantRangeGrid);
        }
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        band.setGeoCoding((GeoCoding)tpGeoCoding);
    }

    private static void setLatLongMetadata(Product product, TiePointGrid latGrid, TiePointGrid lonGrid) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)latGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)lonGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)latGrid.getPixelDouble(w, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)lonGrid.getPixelDouble(w, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)latGrid.getPixelDouble(0, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)lonGrid.getPixelDouble(0, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)latGrid.getPixelDouble(w, h));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)lonGrid.getPixelDouble(w, h));
    }

    private boolean isTOPSAR() {
        return this.acqMode.equals("IW") || this.acqMode.equals("EW");
    }

    @Override
    protected String getProductName() {
        String name = this.getBaseDir().getName();
        if (name.toUpperCase().endsWith(".SAFE")) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }

    @Override
    protected String getProductType() {
        return "RAW";
    }

    private static void getListInEvenlySpacedGrid(int sceneRasterWidth, int sceneRasterHeight, int sourceGridWidth, int sourceGridHeight, int[] x, int[] y, double[] sourcePointList, int targetGridWidth, int targetGridHeight, double subSamplingX, double subSamplingY, float[] targetPointList) {
        if (sourcePointList.length != sourceGridWidth * sourceGridHeight) {
            throw new IllegalArgumentException("Original tie point array size does not match 'sourceGridWidth' x 'sourceGridHeight'");
        }
        if (targetPointList.length != targetGridWidth * targetGridHeight) {
            throw new IllegalArgumentException("Target tie point array size does not match 'targetGridWidth' x 'targetGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < targetGridHeight; ++r) {
            double newY;
            if (r == targetGridHeight - 1) {
                System.out.println();
            }
            if ((newY = (double)r * subSamplingY) > (double)(sceneRasterHeight - 1)) {
                newY = sceneRasterHeight - 1;
            }
            double oldY0 = 0.0;
            double oldY1 = 0.0;
            int j0 = 0;
            int j1 = 0;
            int rr = 1;
            while (rr < sourceGridHeight) {
                j0 = rr - 1;
                j1 = rr++;
                oldY0 = y[j0 * sourceGridWidth];
                oldY1 = y[j1 * sourceGridWidth];
                if (oldY1 > newY) break;
            }
            double wj = (newY - oldY0) / (oldY1 - oldY0);
            for (int c = 0; c < targetGridWidth; ++c) {
                double newX = (double)c * subSamplingX;
                if (newX > (double)(sceneRasterWidth - 1)) {
                    newX = sceneRasterWidth - 1;
                }
                double oldX0 = 0.0;
                double oldX1 = 0.0;
                int i0 = 0;
                int i1 = 0;
                int cc = 1;
                while (cc < sourceGridWidth) {
                    i0 = cc - 1;
                    i1 = cc++;
                    oldX0 = x[i0];
                    oldX1 = x[i1];
                    if (oldX1 > newX) break;
                }
                double wi = (newX - oldX0) / (oldX1 - oldX0);
                targetPointList[k++] = (float)MathUtils.interpolate2D((double)wi, (double)wj, (double)sourcePointList[i0 + j0 * sourceGridWidth], (double)sourcePointList[i1 + j0 * sourceGridWidth], (double)sourcePointList[i0 + j1 * sourceGridWidth], (double)sourcePointList[i1 + j1 * sourceGridWidth]);
            }
        }
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag) {
        String start = elem.getAttributeString(tag, "-");
        start = start.replace("T", "_");
        return AbstractMetadata.parseUTC((String)start, (DateFormat)Sentinel1Constants.sentinelDateFormat);
    }

    private void addBinaryDataToProduct(MetadataElement root) {
        Sentinel1Level0Reader reader = new Sentinel1Level0Reader(this.getBaseDir(), AbstractMetadata.addOriginalProductMetadata((MetadataElement)root));
        reader.readData();
    }

    private MetadataElement getMetadataObject(MetadataElement origProdRoot, String metadataObjectName) {
        MetadataElement[] metadataObjects;
        MetadataElement metadataSection = origProdRoot.getElement("XFDU").getElement("metadataSection");
        for (MetadataElement elem : metadataObjects = metadataSection.getElements()) {
            if (!elem.getAttribute("ID").getData().getElemString().equals(metadataObjectName)) continue;
            return elem;
        }
        return null;
    }

    private void addGeoCodingForLevel0Products(Product product) {
        float[] latCorners = new float[4];
        float[] lonCorners = new float[latCorners.length];
        MetadataElement elem = this.getMetadataObject(AbstractMetadata.getOriginalProductMetadata((Product)product), "measurementFrameSet");
        if (elem != null) {
            float[] latLonLast;
            MetadataElement footprint = elem.getElement("metadataWrap").getElement("xmlData").getElement("frameSet").getElement("frame").getElement("footprint");
            MetadataAttribute coordinates = footprint.getAttribute("coordinates");
            String coordinatesStr = coordinates.getData().getElemString();
            String[] latLonPairsStr = coordinatesStr.split(" ");
            int numLatLonPairs = latLonPairsStr.length;
            ArrayList<float[]> latLonList = new ArrayList<float[]>();
            for (String s : latLonPairsStr) {
                String[] latStrLonStr = s.split(",");
                if (latStrLonStr.length != 2) {
                    System.out.println("Sentinel1Level0Directory.addGeoCodingForLevel0Products: ERROR in footprint coordinates");
                    continue;
                }
                float[] latLon = new float[]{Float.parseFloat(latStrLonStr[0]), Float.parseFloat(latStrLonStr[1])};
                latLonList.add(latLon);
            }
            float[] latLonFirst = (float[])latLonList.get(0);
            if (latLonFirst[0] == (latLonLast = (float[])latLonList.get(numLatLonPairs - 1))[0] && latLonFirst[1] == latLonLast[1]) {
                latLonList.remove(numLatLonPairs - 1);
            }
            if (latLonList.size() != latCorners.length) {
                return;
            }
            for (int i = 0; i < latCorners.length; ++i) {
                latCorners[i] = ((float[])latLonList.get(i))[0];
                lonCorners[i] = ((float[])latLonList.get(i))[1];
            }
            float tmp = latCorners[0];
            latCorners[0] = latCorners[1];
            latCorners[1] = tmp;
            tmp = lonCorners[0];
            lonCorners[0] = lonCorners[1];
            lonCorners[1] = tmp;
        }
        ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
    }

    @Override
    public Product createProduct() throws IOException {
        MetadataElement newRoot = this.addMetaData();
        this.addBinaryDataToProduct(newRoot);
        this.findImages(newRoot);
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        int sceneWidth = absRoot.getAttributeInt("num_samples_per_line");
        int sceneHeight = absRoot.getAttributeInt("num_output_lines");
        Product product = new Product(this.getProductName(), this.getProductType(), sceneWidth, sceneHeight);
        Sentinel1Level0Directory.updateProduct(product, newRoot);
        this.addTiePointGrids(product);
        this.addBands(product);
        this.addGeoCoding(product);
        product.setName(this.getProductName());
        product.setProductType(this.getProductType());
        product.setDescription(this.getProductDescription());
        product.setFileLocation(this.getBaseDir());
        ReaderUtils.addMetadataProductSize((Product)product);
        return product;
    }
}

