/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.seasat;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.seasat.SeaSatConstants;
import org.esa.s1tbx.io.seasat.SeaSatProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class SeaSatProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        String filename;
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null && (filename = file.getName().toUpperCase()).startsWith("SS_")) {
            if (filename.endsWith(SeaSatConstants.getIndicationKey()) && !filename.endsWith(".ISO.XML")) {
                return DecodeQualification.INTENDED;
            }
            if (filename.endsWith(".ZIP") && ZipUtils.findInZip((File)file, (String)"SS_", (String)SeaSatConstants.getIndicationKey())) {
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return SeaSatConstants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new SeaSatProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return SeaSatConstants.getFormatNames();
    }

    public String[] getDefaultFileExtensions() {
        return SeaSatConstants.getForamtFileExtensions();
    }

    public String getDescription(Locale locale) {
        return SeaSatConstants.getPluginDescription();
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(SeaSatConstants.getFormatNames()[0]);
            this.setExtensions(SeaSatConstants.getForamtFileExtensions());
            this.setDescription(SeaSatConstants.getPluginDescription());
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String name = file.getName().toUpperCase();
                if (file.isDirectory() || name.startsWith("SS_") && (name.endsWith(SeaSatConstants.getIndicationKey()) && !name.endsWith(".ISO.XML") || name.endsWith(".ZIP"))) {
                    return true;
                }
            }
            return false;
        }
    }
}

