/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.seasat;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.seasat.SeaSatProductDirectory;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class SeaSatProductReader
extends SARReader {
    protected SeaSatProductDirectory dataDir = null;

    public SeaSatProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this.dataDir != null) {
            this.dataDir.close();
            this.dataDir = null;
        }
        super.close();
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        try {
            File fileFromInput = ReaderUtils.getFileFromInput((Object)this.getInput());
            this.dataDir = this.createDirectory(fileFromInput);
            this.dataDir.readProductDirectory();
            Product product = this.dataDir.createProduct();
            MetadataElement absMeta = AbstractMetadata.getAbstractedMetadata((Product)product);
            product.getGcpGroup();
            product.setFileLocation(fileFromInput);
            product.setProductReader((ProductReader)this);
            SeaSatProductReader.setQuicklookBandName(product);
            this.addQuicklook(product, "Quicklook", this.getQuicklookFile());
            return product;
        }
        catch (Exception e) {
            this.handleReaderException(e);
            return null;
        }
    }

    protected SeaSatProductDirectory createDirectory(File fileFromInput) {
        return new SeaSatProductDirectory(fileFromInput);
    }

    private File getQuicklookFile() {
        try {
            String[] files;
            for (String file : files = this.dataDir.listFiles(this.dataDir.getRootFolder())) {
                if (!file.endsWith(".jpg")) continue;
                return this.dataDir.getFile(this.dataDir.getRootFolder() + file);
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to load quicklook " + this.dataDir.getProductName());
        }
        return null;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ImageIOFile.BandInfo bandInfo = this.dataDir.getBandInfo(destBand);
        if (bandInfo != null && bandInfo.img != null) {
            this.readRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, 0, bandInfo.img, bandInfo.bandSampleOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, ImageIOFile img, int bandSampleOffset) throws IOException {
        Raster data;
        SeaSatProductDirectory seaSatProductDirectory = this.dataDir;
        synchronized (seaSatProductDirectory) {
            ImageReader reader = img.getReader();
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
            RenderedImage image = reader.readAsRenderedImage(0, param);
            data = image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
        }
        int w = data.getWidth();
        int h = data.getHeight();
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int sampleOffset = imageID + bandSampleOffset;
        sampleModel.getSamples(0, 0, w, h, sampleOffset, (float[])destBuffer.getElems(), dataBuffer);
    }
}

