/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.seasat;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class SeaSatProductDirectory
extends XMLProductDirectory {
    private String productType = "SeaSat";
    private String productDescription = "SeaSat Product";
    private File imageFile;
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");

    public SeaSatProductDirectory(File headerFile) {
        super(headerFile);
    }

    @Override
    protected String getHeaderFileName() {
        if (ZipUtils.isZip((File)this.productInputFile)) {
            try {
                String[] files;
                for (String file : files = this.listFiles("")) {
                    if (!file.startsWith("SS_") || !file.endsWith(".xml") || file.endsWith(".iso.xml")) continue;
                    return file;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.productInputFile.getName();
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
        String name = SeaSatProductDirectory.getBandFileNameFromImage(imgPath);
        if (name.endsWith("tif")) {
            Dimension bandDimensions = SeaSatProductDirectory.getBandDimensions(newRoot, name);
            InputStream inStream = this.getInputStream(imgPath);
            ImageInputStream imgStream = ImageIOFile.createImageInputStream(inStream, bandDimensions);
            if (imgStream == null) {
                throw new IOException("Unable to open " + imgPath);
            }
            ImageIOFile img = this.isSLC() ? new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), 1, 2, 30, this.productInputFile) : new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), this.productInputFile);
            this.bandImageFileMap.put(img.getName(), img);
            this.imageFile = this.getFile(imgPath);
        }
    }

    @Override
    protected void addBands(Product product) {
        boolean real = true;
        Band lastRealBand = null;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int width = absRoot.getAttributeInt("num_samples_per_line");
        int height = absRoot.getAttributeInt("num_output_lines");
        Set keys = this.bandImageFileMap.keySet();
        for (String key : keys) {
            ImageIOFile img = (ImageIOFile)this.bandImageFileMap.get(key);
            for (int i = 0; i < img.getNumImages(); ++i) {
                Band band;
                String bandName;
                String imgName;
                int b;
                if (this.isSLC()) {
                    for (b = 0; b < img.getNumBands(); ++b) {
                        String unit;
                        imgName = img.getName().toLowerCase();
                        if (real) {
                            bandName = "i_" + SeaSatProductDirectory.getPol();
                            unit = "real";
                        } else {
                            bandName = "q_" + SeaSatProductDirectory.getPol();
                            unit = "imaginary";
                        }
                        band = new Band(bandName, img.getDataType(), width, height);
                        band.setUnit(unit);
                        product.addBand(band);
                        this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                        if (real) {
                            lastRealBand = band;
                        } else {
                            ReaderUtils.createVirtualIntensityBand((Product)product, (Band)lastRealBand, (Band)band, (String)('_' + SeaSatProductDirectory.getPol()));
                        }
                        real = !real;
                    }
                    continue;
                }
                for (b = 0; b < img.getNumBands(); ++b) {
                    imgName = img.getName().toLowerCase();
                    bandName = "Amplitude_" + SeaSatProductDirectory.getPol();
                    band = new Band(bandName, 30, width, height);
                    band.setUnit("amplitude");
                    product.addBand(band);
                    this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                    SARReader.createVirtualIntensityBand(product, band, '_' + SeaSatProductDirectory.getPol());
                }
            }
        }
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        String defStr = "-";
        int defInt = 99999;
        MetadataElement level1Product = origProdRoot.getElement("level1Product");
        MetadataElement generalHeader = level1Product.getElement("generalHeader");
        this.productDescription = generalHeader.getAttributeString("itemName");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)"SeaSat");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)SeaSatProductDirectory.getBandFileNameFromImage(this.getHeaderFileName()));
        MetadataElement productInfo = level1Product.getElement("productInfo");
        MetadataElement generationInfo = productInfo.getElement("generationInfo");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)generationInfo.getAttributeString("level1ProcessingFacility"));
        MetadataElement missionInfo = productInfo.getElement("missionInfo");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)missionInfo.getAttributeInt("absOrbit"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"REL_ORBIT", (int)missionInfo.getAttributeInt("relOrbit"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_cycle", (int)missionInfo.getAttributeInt("orbitCycle"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)missionInfo.getAttributeString("orbitDirection"));
        MetadataElement acquisitionInfo = productInfo.getElement("acquisitionInfo");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)this.productDescription);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)acquisitionInfo.getAttributeString("imagingMode"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)acquisitionInfo.getAttributeString("lookDirection"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)SeaSatProductDirectory.getPol());
        MetadataElement productVariantInfo = productInfo.getElement("productVariantInfo");
        this.productType = productVariantInfo.getAttributeString("productVariant");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.productType);
        MetadataElement imageDataInfo = productInfo.getElement("imageDataInfo");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)imageDataInfo.getAttributeString("imageDataType"));
        MetadataElement imageRaster = imageDataInfo.getElement("imageRaster");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)imageRaster.getAttributeInt("numberOfRows"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)imageRaster.getAttributeInt("numberOfColumns"));
        MetadataElement rowSpacing = imageRaster.getElement("rowSpacing");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)rowSpacing.getAttributeDouble("rowSpacing"));
        MetadataElement groundRangeResolution = imageRaster.getElement("groundRangeResolution");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)groundRangeResolution.getAttributeDouble("groundRangeResolution"));
        MetadataElement azimuthResolution = imageRaster.getElement("azimuthResolution");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)azimuthResolution.getAttributeDouble("azimuthResolution"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (double)imageRaster.getAttributeDouble("azimuthLooks"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (double)imageRaster.getAttributeDouble("rangeLooks"));
        MetadataElement setup = level1Product.getElement("setup");
        MetadataElement orderInfo = setup.getElement("orderInfo");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_state_vector_file", (String)orderInfo.getAttributeString("orbitAccuracy"));
        MetadataElement instrument = level1Product.getElement("instrument");
        MetadataElement radarParameters = instrument.getElement("radarParameters");
        MetadataElement centerFrequency = radarParameters.getElement("centerFrequency");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)centerFrequency.getAttributeDouble("centerFrequency"));
        MetadataElement platform = level1Product.getElement("platform");
        MetadataElement orbit = platform.getElement("orbit");
        SeaSatProductDirectory.addOrbitStateVectors(absRoot, orbit);
    }

    private static void addOrbitStateVectors(MetadataElement absRoot, MetadataElement orbit) {
        MetadataElement[] elems;
        MetadataElement orbitHeader = orbit.getElement("orbitHeader");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)orbitHeader, (String)"firstStateTimeUTC", (DateFormat)standardDateFormat));
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        int i = 0;
        for (MetadataElement stateVec : elems = orbit.getElements()) {
            if (!stateVec.getName().equals("stateVec")) continue;
            SeaSatProductDirectory.addVector("orbit_vector", orbitVectorListElem, stateVec, i++);
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, MetadataElement srcElem, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        orbitVectorElem.setAttributeUTC("time", ReaderUtils.getTime((MetadataElement)srcElem, (String)"timeUTC", (DateFormat)standardDateFormat));
        MetadataElement xpos = srcElem.getElement("posX");
        orbitVectorElem.setAttributeDouble("x_pos", xpos.getAttributeDouble("posX", 0.0));
        MetadataElement ypos = srcElem.getElement("posY");
        orbitVectorElem.setAttributeDouble("y_pos", ypos.getAttributeDouble("posY", 0.0));
        MetadataElement zpos = srcElem.getElement("posZ");
        orbitVectorElem.setAttributeDouble("z_pos", zpos.getAttributeDouble("posZ", 0.0));
        MetadataElement xvel = srcElem.getElement("velX");
        orbitVectorElem.setAttributeDouble("x_vel", xvel.getAttributeDouble("velX", 0.0));
        MetadataElement yvel = srcElem.getElement("velY");
        orbitVectorElem.setAttributeDouble("y_vel", yvel.getAttributeDouble("velY", 0.0));
        MetadataElement zvel = srcElem.getElement("velZ");
        orbitVectorElem.setAttributeDouble("z_vel", zvel.getAttributeDouble("velZ", 0.0));
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    @Override
    protected void addGeoCoding(Product product) {
        try {
            Product imageProduct = ProductIO.readProduct((File)this.imageFile);
            if (imageProduct != null) {
                product.setSceneGeoCoding(imageProduct.getSceneGeoCoding());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void addTiePointGrids(Product product) {
    }

    private static String getMission() {
        return "SeaSat";
    }

    @Override
    protected String getProductName() {
        return this.getHeaderFileName();
    }

    @Override
    protected String getProductDescription() {
        return this.productDescription;
    }

    @Override
    protected String getProductType() {
        return this.productType;
    }

    private static String getPol() {
        return "HH";
    }
}

