/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.radarsat2;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.radarsat2.Radarsat2Constants;
import org.esa.s1tbx.io.radarsat2.Radarsat2ProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class Radarsat2ProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null) {
            String filename = file.getName().toLowerCase();
            if (filename.equals("product.xml") || filename.equalsIgnoreCase("NEST_product.xml")) {
                File[] files = file.getParentFile().listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (!f.getName().toLowerCase().endsWith("ntf")) continue;
                        return DecodeQualification.SUITABLE;
                    }
                }
                return DecodeQualification.INTENDED;
            }
            if (filename.endsWith(".zip") && filename.startsWith("rs2") && ZipUtils.findInZip((File)file, (String)"", (String)"product.xml")) {
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return Radarsat2Constants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new Radarsat2ProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return Radarsat2Constants.getFormatNames();
    }

    public String[] getDefaultFileExtensions() {
        return Radarsat2Constants.getForamtFileExtensions();
    }

    public String getDescription(Locale locale) {
        return Radarsat2Constants.getPluginDescription();
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(Radarsat2Constants.getFormatNames()[0]);
            this.setExtensions(Radarsat2Constants.getForamtFileExtensions());
            this.setDescription(Radarsat2Constants.getPluginDescription());
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String name = file.getName().toUpperCase();
                if (file.isDirectory() || name.startsWith("PRODUCT") && name.endsWith(Radarsat2Constants.getIndicationKey()) || name.startsWith("RS2") && name.endsWith(".ZIP")) {
                    return true;
                }
            }
            return false;
        }
    }
}

