/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.polsarpro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s1tbx.io.FileImageOutputStreamExtImpl;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.dataio.dimap.EnviHeader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envi.EnviProductWriter;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;

public class PolsarProProductWriter
extends EnviProductWriter {
    private static final String BIN_EXTENSION = ".bin";

    public PolsarProProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    protected void writeProductNodesImpl() throws IOException {
        super.writeProductNodesImpl();
        PolsarProProductWriter.writeConfigFile(this.getSourceProduct(), this.getOutputDir());
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.getSourceProduct());
        AbstractMetadataIO.saveExternalMetadata((Product)this.getSourceProduct(), (MetadataElement)absRoot, (File)new File(this.getOutputDir(), "metadata.xml"));
    }

    protected void writeEnviHeader(Band band) throws IOException {
        EnviHeader.createPhysicalFile((File)this.getEnviHeaderFile(band), (RasterDataNode)band, (int)band.getRasterWidth(), (int)band.getRasterHeight(), (int)0);
    }

    protected ImageOutputStream createImageOutputStream(Band band) throws IOException {
        FileImageOutputStreamExtImpl out = new FileImageOutputStreamExtImpl(this.getValidImageFile(band));
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        return out;
    }

    protected void initDirs(File outputFile) {
        super.initDirs(outputFile);
        PolBandUtils.MATRIX matrixType = PolBandUtils.getSourceProductType(this.getSourceProduct());
        String folder = "";
        if (matrixType.equals((Object)PolBandUtils.MATRIX.C3)) {
            folder = "C3";
        } else if (matrixType.equals((Object)PolBandUtils.MATRIX.T3)) {
            folder = "T3";
        } else if (matrixType.equals((Object)PolBandUtils.MATRIX.C4)) {
            folder = "C4";
        } else if (matrixType.equals((Object)PolBandUtils.MATRIX.T4)) {
            folder = "T4";
        }
        if (!folder.isEmpty()) {
            this._outputDir = new File(this._outputDir, folder);
            if (!this._outputDir.exists() && !this._outputDir.mkdirs()) {
                SystemUtils.LOG.severe("Unable to create folders in " + this._outputDir);
            }
            this._outputFile = new File(this._outputDir, outputFile.getName());
        }
    }

    protected void ensureNamingConvention() {
    }

    protected String createImageFilename(Band band) {
        return band.getName() + BIN_EXTENSION;
    }

    protected String createEnviHeaderFilename(Band band) {
        return band.getName() + BIN_EXTENSION + ".hdr";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigFile(Product srcProduct, File folder) {
        try (PrintStream p = null;){
            File file = new File(folder, "config.txt");
            FileOutputStream out = new FileOutputStream(file);
            p = new PrintStream(out);
            p.println("Nrow");
            p.println(srcProduct.getSceneRasterHeight());
            p.println("---------");
            p.println("Ncol");
            p.println(srcProduct.getSceneRasterWidth());
            p.println("---------");
            p.println("PolarCase");
            p.println(PolsarProProductWriter.getPolarCase(srcProduct));
            p.println("---------");
            p.println("PolarType");
            p.println(PolBandUtils.getPolarType(srcProduct));
            p.println("---------");
        }
    }

    private static String getPolarCase(Product srcProduct) {
        PolBandUtils.MATRIX matrixType = PolBandUtils.getSourceProductType(srcProduct);
        if (matrixType.equals((Object)PolBandUtils.MATRIX.C4) || matrixType.equals((Object)PolBandUtils.MATRIX.T4)) {
            return "bistatic";
        }
        return "monostatic";
    }
}

