/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.polsarpro;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.polsarpro.PolsarProProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.dataio.envi.EnviProductReaderPlugIn;

public class PolsarProProductReaderPlugIn
extends EnviProductReaderPlugIn {
    public static final String FORMAT_NAME = "PolSARPro";

    public ProductReader createReaderInstance() {
        return new PolsarProProductReader((ProductReaderPlugIn)this);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String getDescription(Locale locale) {
        return FORMAT_NAME;
    }

    public DecodeQualification getDecodeQualification(Object input) {
        File folder;
        File[] files;
        File selectedFile;
        String fname;
        if (input instanceof File && ((fname = (selectedFile = (File)input).getName().toLowerCase()).equals("config.txt") || fname.endsWith("bin.hdr")) && (files = (folder = selectedFile.getParentFile()).listFiles()) != null) {
            boolean hasConfigFile = false;
            boolean hasHeaderFile = false;
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (name.equals("config.txt")) {
                    hasConfigFile = true;
                    continue;
                }
                if (!name.endsWith("bin.hdr")) continue;
                hasHeaderFile = true;
            }
            if (hasConfigFile && hasHeaderFile) {
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("T3", new String[]{"T11", "T22", "T33"}));
        manager.addProfile(new RGBImageProfile("C3", new String[]{"C11", "C22", "C33"}));
        manager.addProfile(new RGBImageProfile("T2", new String[]{"T11", "T22", "T11/T22"}));
        manager.addProfile(new RGBImageProfile("C2", new String[]{"C11", "C22", "C11/C22"}));
    }

    static {
        PolsarProProductReaderPlugIn.registerRGBProfiles();
    }
}

