/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.polsarpro;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.esa.snap.dataio.envi.Header;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;

public class PolsarProProductReader
extends EnviProductReader {
    private final HashMap<Band, BandInfo> bandInfoMap = new HashMap(10);

    PolsarProProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Product readProductNodesImpl() throws IOException {
        String productName;
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        File folder = inputFile.getParentFile();
        File[] fileList = folder.listFiles();
        if (fileList == null) {
            throw new IOException("no files found in " + folder.toString());
        }
        ArrayList<Header> headerList = new ArrayList<Header>(fileList.length);
        HashMap<Header, File> headerFileMap = new HashMap<Header, File>(fileList.length);
        Header mainHeader = null;
        File mainHeaderFile = null;
        ResourceUtils.sortFileList((File[])fileList);
        for (File file : fileList) {
            File imgFile;
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith("hdr") || !(imgFile = PolsarProProductReader.getEnviImageFile((File)file)).exists()) continue;
            try (BufferedReader headerReader = this.getHeaderReader(file);){
                BufferedReader bufferedReader = headerReader;
                synchronized (bufferedReader) {
                    Header header = new Header(headerReader);
                    headerList.add(header);
                    headerFileMap.put(header, file);
                    if (header.getNumBands() > 0 && header.getBandNames() != null) {
                        mainHeader = header;
                        mainHeaderFile = file;
                    }
                }
            }
        }
        if (mainHeader == null) {
            throw new IOException("Unable to read files");
        }
        if (inputFile.isDirectory()) {
            productName = inputFile.getName();
            if (productName.equalsIgnoreCase("T3") || productName.equalsIgnoreCase("C3") || productName.equalsIgnoreCase("T4") || productName.equalsIgnoreCase("C4")) {
                productName = inputFile.getParentFile().getName() + '_' + productName;
            }
        } else {
            String headerFileName = mainHeaderFile.getName();
            productName = headerFileName.substring(0, headerFileName.indexOf(46));
        }
        Product product = new Product(productName, mainHeader.getSensorType(), mainHeader.getNumSamples(), mainHeader.getNumLines());
        product.setProductReader((ProductReader)this);
        product.setFileLocation(mainHeaderFile);
        product.getMetadataRoot().addElement(mainHeader.getAsMetadata());
        product.setDescription(mainHeader.getDescription());
        try {
            this.initGeoCoding(product, mainHeader);
            for (Header header : headerList) {
                int dataType = header.getDataType();
                if (dataType == 6) {
                    this.initComplexBands(product, inputFile, header, 30);
                    continue;
                }
                if (dataType == 9) {
                    this.initComplexBands(product, inputFile, header, 31);
                    continue;
                }
                this.initBands((File)headerFileMap.get(header), product, header);
            }
            PolsarProProductReader.applyBeamProperties((Product)product, (Header.BeamProperties)mainHeader.getBeamProperties());
            PolsarProProductReader.addMetadata(product, inputFile);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return product;
    }

    private void initComplexBands(Product product, File inputFile, Header header, int bandType) throws IOException {
        String[] bandNames;
        Double dataIgnoreValue = header.getDataIgnoreValue();
        int width = header.getNumSamples();
        int height = header.getNumLines();
        for (String bandName : bandNames = header.getBandNames()) {
            if (!ProductNode.isValidNodeName((String)bandName)) {
                bandName = StringUtils.createValidName((String)bandName, null, (char)'_');
            }
            Band iBand = new Band("i_" + bandName, bandType, width, height);
            iBand.setUnit("real");
            if (dataIgnoreValue != null) {
                iBand.setNoDataValueUsed(true);
                iBand.setNoDataValue(dataIgnoreValue.doubleValue());
            }
            product.addBand(iBand);
            Band qBand = new Band("q_" + bandName, bandType, width, height);
            qBand.setUnit("imaginary");
            if (dataIgnoreValue != null) {
                qBand.setNoDataValueUsed(true);
                qBand.setNoDataValue(dataIgnoreValue.doubleValue());
            }
            product.addBand(qBand);
            ReaderUtils.createVirtualIntensityBand((Product)product, (Band)iBand, (Band)qBand, (String)bandName);
            BandInfo bandInfo = new BandInfo();
            bandInfo.isComplex = true;
            bandInfo.header = header;
            File bandFile = new File(inputFile.getParentFile(), bandName);
            bandInfo.inStream = new FileImageInputStream(bandFile);
            bandInfo.inStream.setByteOrder(header.getJavaByteOrder());
            this.bandInfoMap.put(iBand, bandInfo);
            this.bandInfoMap.put(qBand, bandInfo);
        }
    }

    private static void addMetadata(Product product, File inputFile) throws IOException {
        if (!AbstractMetadata.hasAbstractedMetadata((Product)product)) {
            MetadataElement root = product.getMetadataRoot();
            MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)product.getName());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)product.getProductType());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
            AbstractMetadataIO.loadExternalMetadata((Product)product, (MetadataElement)absRoot, (File)inputFile);
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        absRoot.setAttributeInt("polsar_data", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        BandInfo bandInfo = this.bandInfoMap.get(destBand);
        if (bandInfo != null && bandInfo.isComplex) {
            int sourceMaxY = sourceOffsetY + sourceHeight - 1;
            Product product = destBand.getProduct();
            int elemSize = destBuffer.getElemSize();
            int headerOffset = bandInfo.header.getHeaderOffset();
            boolean bandIndex = false;
            int numBands = 2;
            long lineSizeInBytes = bandInfo.header.getNumSamples() * numBands * elemSize;
            ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)(sourceWidth * numBands));
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    ImageInputStream imageInputStream = bandInfo.inStream;
                    synchronized (imageInputStream) {
                        long lineStartPos = (long)headerOffset + (long)sourceY * lineSizeInBytes;
                        bandInfo.inStream.seek(lineStartPos + (long)(elemSize * sourceOffsetX * numBands));
                        lineData.readFrom(0, sourceWidth * numBands, bandInfo.inStream);
                    }
                    for (int x = 0; x < sourceWidth; ++x) {
                        destBuffer.setElemDoubleAt(destPos++, lineData.getElemDoubleAt(x * numBands + 0));
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        } else {
            super.readBandRasterDataImpl(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
        }
    }

    private static class BandInfo {
        boolean isComplex = false;
        ImageInputStream inStream;
        Header header;

        private BandInfo() {
        }
    }
}

