/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.sentinel1;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class StepAuxdataScraper {
    private static final String stepS1OrbitsUrl = "http://step.esa.int/auxdata/orbits/Sentinel-1/";
    private static final String POEORB = "POEORB";
    private static final String RESORB = "RESORB";
    private final String orbitType;
    private String remotePath;

    StepAuxdataScraper(String orbitType) {
        this.orbitType = orbitType.contains("Restituted") ? RESORB : POEORB;
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    String getRemoteURL() {
        return this.remotePath;
    }

    String[] getFileURLs(String mission, int year, int month) {
        String monthStr = StringUtils.padNum((int)month, (int)2, (char)'0');
        this.remotePath = stepS1OrbitsUrl + this.orbitType + '/' + mission + '/' + year + '/' + monthStr + '/';
        List<String> newLinks = this.getFileURLs(this.remotePath);
        return newLinks.toArray(new String[newLinks.size()]);
    }

    private List<String> getFileURLs(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            Document doc = Jsoup.connect((String)path).timeout(10000).validateTLSCertificates(false).get();
            Element table = doc.select("table").first();
            Elements tbRows = table.select("tr");
            for (Element row : tbRows) {
                Elements tbCols = row.select("td");
                for (Element col : tbCols) {
                    Elements elems = col.getElementsByTag("a");
                    for (Element elem : elems) {
                        String link = elem.text();
                        if (!link.endsWith(".zip")) continue;
                        fileList.add(elem.text());
                    }
                }
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("Unable to connect to " + path + ": " + e.getMessage());
        }
        return fileList;
    }
}

