/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.sentinel1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class QCScraper {
    private static final String POEORB = "aux_poeorb";
    private static final String RESORB = "aux_resorb";
    private static final String qcUrl = "https://qc.sentinel1.eo.esa.int/";
    private static final String pageVar = "/?page=";
    private static final String missionVar = "&mission=";
    private static final String validityStartYearVar = "&validity_start_time=";
    private static final String validityStartMonthVar = "&validity_start_time=";
    private final String orbitType;

    QCScraper(String orbitType) {
        this.orbitType = orbitType.contains("Restituted") ? RESORB : POEORB;
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    String getRemoteURL() {
        return qcUrl + this.orbitType + '/';
    }

    String[] getFileURLs(String mission, int year, int month) {
        HashSet<String> fileList = new HashSet<String>();
        String monthStr = StringUtils.padNum((int)month, (int)2, (char)'0');
        int maxPage = this.orbitType.equals(RESORB) ? 70 : 6;
        for (int day = 1; day <= maxPage; ++day) {
            String path = qcUrl + this.orbitType + pageVar + day + missionVar + mission;
            String validity = "&validity_start_time=" + year + "&validity_start_time=" + year + '-' + monthStr;
            List<String> newLinks = QCScraper.getFileURLs(path + validity, fileList);
            if (newLinks.isEmpty()) break;
            fileList.addAll(newLinks);
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    private static List<String> getFileURLs(String path, Set<String> currentList) {
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            Document doc = Jsoup.connect((String)path).timeout(10000).validateTLSCertificates(false).get();
            Element table = doc.select("table").first();
            Elements tbRows = table.select("tr");
            for (Element row : tbRows) {
                Elements tbCols = row.select("td");
                for (Element col : tbCols) {
                    Elements elems = col.getElementsByTag("a");
                    for (Element elem : elems) {
                        String link = elem.text();
                        if (currentList.contains(link)) continue;
                        fileList.add(elem.text());
                    }
                }
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("Unable to connect to " + path + ": " + e.getMessage());
        }
        return fileList;
    }
}

