/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.doris;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.envisat.EnvisatOrbitReader;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchive;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Settings;

public class DorisOrbitFile
extends BaseOrbitFile {
    private EnvisatOrbitReader dorisReader = null;
    private final Product sourceProduct;
    public static final String DORIS_POR = "DORIS Preliminary POR";
    public static final String DORIS_VOR = "DORIS Precise VOR";

    public DorisOrbitFile(MetadataElement absRoot, Product sourceProduct) throws Exception {
        super(absRoot);
        this.sourceProduct = sourceProduct;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{DORIS_VOR, DORIS_POR};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        this.dorisReader = EnvisatOrbitReader.getInstance();
        int absOrbit = this.absRoot.getAttributeInt("ABS_ORBIT", 0);
        String orbitPath = "";
        if (orbitType.contains(DORIS_VOR)) {
            orbitPath = Settings.getPath((String)"OrbitFiles.dorisVOROrbitPath");
        } else if (orbitType.contains(DORIS_POR)) {
            orbitPath = Settings.getPath((String)"OrbitFiles.dorisPOROrbitPath");
        }
        Calendar startCal = this.sourceProduct.getStartTime().getAsCalendar();
        int year = startCal.get(1);
        int month = startCal.get(2) + 1;
        String folder = String.valueOf(year);
        if (month < 10) {
            folder = folder + '0';
        }
        folder = folder + month;
        orbitPath = orbitPath + folder;
        File localPath = new File(orbitPath);
        Date startDate = this.sourceProduct.getStartTime().getAsDate();
        this.orbitFile = DorisOrbitFile.FindDorisOrbitFile(this.dorisReader, localPath, startDate, absOrbit);
        if (this.orbitFile == null) {
            this.getRemoteFiles(orbitType, year);
            this.orbitFile = DorisOrbitFile.FindDorisOrbitFile(this.dorisReader, localPath, startDate, absOrbit);
        }
        if (this.orbitFile == null) {
            throw new IOException("Unable to find suitable DORIS orbit file in\n" + orbitPath);
        }
        this.dorisReader.readOrbitData();
        return this.orbitFile;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) throws Exception {
        EnvisatOrbitReader.OrbitVector orb = this.dorisReader.getOrbitVector(utc);
        return new Orbits.OrbitVector(utc, orb.xPos, orb.yPos, orb.zPos, orb.xVel, orb.yVel, orb.zVel);
    }

    private void getRemoteFiles(String orbitType, int year) throws Exception {
        if (!orbitType.contains(DORIS_VOR)) {
            return;
        }
        File localFolder = new File(Settings.getPath((String)"OrbitFiles.dorisVOROrbitPath"));
        URL remotePath = new URL(Settings.getPath((String)"OrbitFiles.dorisHTTP_vor_remotePath"));
        File localFile = new File(localFolder, year + ".zip");
        DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
        archive.getContentFiles();
    }

    private static File FindDorisOrbitFile(EnvisatOrbitReader dorisReader, File path, Date productDate, int absOrbit) throws IOException {
        File[] list = path.listFiles();
        if (list == null) {
            return null;
        }
        for (File f : list) {
            File foundFile;
            if (f.isDirectory() && (foundFile = DorisOrbitFile.FindDorisOrbitFile(dorisReader, f, productDate, absOrbit)) != null) {
                return foundFile;
            }
            try {
                dorisReader.readProduct((Object)f);
                Date startDate = dorisReader.getSensingStart();
                Date stopDate = dorisReader.getSensingStop();
                if (!productDate.after(startDate) || !productDate.before(stopDate)) continue;
                return f;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return null;
    }
}

