/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.esa.s1tbx.io.netcdf.NetcdfConstants;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;

public class NetCDFWriter
extends AbstractProductWriter {
    private File outputFile = null;
    private NetcdfFileWriteable netCDFWriteable = null;

    public NetCDFWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    private static float[] getLonData(Product product, String lonGridName) {
        int size = product.getSceneRasterWidth();
        TiePointGrid lonGrid = product.getTiePointGrid(lonGridName);
        if (lonGrid != null) {
            return lonGrid.getPixels(0, 0, size, 1, (float[])null);
        }
        return null;
    }

    private static float[] getLatData(Product product, String latGridName) {
        int size = product.getSceneRasterHeight();
        TiePointGrid latGrid = product.getTiePointGrid(latGridName);
        if (latGrid != null) {
            return latGrid.getPixels(0, 0, 1, size, (float[])null);
        }
        return null;
    }

    private static float[][] getTiePointGridData(TiePointGrid tpg) {
        int gridWidth = tpg.getGridWidth();
        int gridHeight = tpg.getGridHeight();
        float[][] data = new float[gridHeight][gridWidth];
        ProductData gridData = tpg.getGridData();
        for (int y = 0; y < gridHeight; ++y) {
            int stride = y * gridWidth;
            for (int x = 0; x < gridWidth; ++x) {
                data[y][x] = gridData.getElemFloatAt(stride + x);
            }
        }
        return data;
    }

    protected void writeProductNodesImpl() throws IOException {
        String name;
        this.outputFile = null;
        File file = this.getOutput() instanceof String ? new File((String)this.getOutput()) : (File)this.getOutput();
        this.outputFile = FileUtils.ensureExtension((File)file, (String)NetcdfConstants.NETCDF_FORMAT_FILE_EXTENSIONS[0]);
        this.deleteOutput();
        Product product = this.getSourceProduct();
        this.netCDFWriteable = NetcdfFileWriteable.createNew((String)this.outputFile.getAbsolutePath(), (boolean)true);
        this.netCDFWriteable.addDimension(NetcdfConstants.LON_VAR_NAMES[0], product.getSceneRasterWidth());
        this.netCDFWriteable.addDimension(NetcdfConstants.LAT_VAR_NAMES[0], product.getSceneRasterHeight());
        Group rootGroup = this.netCDFWriteable.getRootGroup();
        this.netCDFWriteable.addVariable(NetcdfConstants.LAT_VAR_NAMES[0], DataType.FLOAT, new Dimension[]{rootGroup.findDimension(NetcdfConstants.LAT_VAR_NAMES[0])});
        this.netCDFWriteable.addVariableAttribute(NetcdfConstants.LAT_VAR_NAMES[0], "units", "degrees_north (+N/-S)");
        this.netCDFWriteable.addVariable(NetcdfConstants.LON_VAR_NAMES[0], DataType.FLOAT, new Dimension[]{rootGroup.findDimension(NetcdfConstants.LON_VAR_NAMES[0])});
        this.netCDFWriteable.addVariableAttribute(NetcdfConstants.LON_VAR_NAMES[0], "units", "degrees_east (+E/-W)");
        for (Band band : product.getBands()) {
            name = StringUtils.createValidName((String)band.getName(), (char[])new char[]{'_'}, (char)'_');
            this.netCDFWriteable.addVariable(name, DataType.DOUBLE, new Dimension[]{rootGroup.findDimension(NetcdfConstants.LAT_VAR_NAMES[0]), rootGroup.findDimension(NetcdfConstants.LON_VAR_NAMES[0])});
            if (band.getDescription() != null) {
                this.netCDFWriteable.addVariableAttribute(name, "description", band.getDescription());
            }
            if (band.getUnit() == null) continue;
            this.netCDFWriteable.addVariableAttribute(name, "unit", band.getUnit());
        }
        for (Band band : product.getTiePointGrids()) {
            name = band.getName();
            this.netCDFWriteable.addDimension(name + 'x', band.getGridWidth());
            this.netCDFWriteable.addDimension(name + 'y', band.getGridHeight());
            this.netCDFWriteable.addVariable(name, DataType.FLOAT, new Dimension[]{rootGroup.findDimension(name + 'y'), rootGroup.findDimension(name + 'x')});
            if (band.getDescription() != null) {
                this.netCDFWriteable.addVariableAttribute(name, "description", band.getDescription());
            }
            if (band.getUnit() == null) continue;
            this.netCDFWriteable.addVariableAttribute(name, "unit", band.getUnit());
        }
        this.addMetadata(product);
        this.netCDFWriteable.create();
        GeoCoding sourceGeoCoding = product.getSceneGeoCoding();
        String latGridName = "latitude";
        String lonGridName = "longitude";
        if (sourceGeoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tiePointGeoCoding = (TiePointGeoCoding)sourceGeoCoding;
            latGridName = tiePointGeoCoding.getLatGrid().getName();
            lonGridName = tiePointGeoCoding.getLonGrid().getName();
        }
        float[] fArray = NetCDFWriter.getLatData(product, latGridName);
        float[] lonData = NetCDFWriter.getLonData(product, lonGridName);
        if (fArray != null && lonData != null) {
            Array latNcArray = Array.factory((Object)fArray);
            Array lonNcArray = Array.factory((Object)lonData);
            try {
                this.netCDFWriteable.write(NetcdfConstants.LAT_VAR_NAMES[0], latNcArray);
                this.netCDFWriteable.write(NetcdfConstants.LON_VAR_NAMES[0], lonNcArray);
                for (TiePointGrid tpg : product.getTiePointGrids()) {
                    Array tpgArray = Array.factory((Object)NetCDFWriter.getTiePointGridData(tpg));
                    this.netCDFWriteable.write(tpg.getName(), tpgArray);
                }
            }
            catch (InvalidRangeException rangeE) {
                rangeE.printStackTrace();
                throw new RuntimeException(rangeE);
            }
        }
    }

    public void writeBandRasterData(Band sourceBand, int regionX, int regionY, int regionWidth, int regionHeight, ProductData regionData, ProgressMonitor pm) throws IOException {
        int[] origin = new int[2];
        origin[1] = regionX;
        origin[0] = regionY;
        try {
            ArrayDouble.D2 dataTemp = new ArrayDouble.D2(regionHeight, regionWidth);
            Index index = dataTemp.getIndex();
            int i = 0;
            for (int y = 0; y < regionHeight; ++y) {
                for (int x = 0; x < regionWidth; ++x) {
                    index.set(y, x);
                    dataTemp.set(index, regionData.getElemDoubleAt(i));
                    ++i;
                }
            }
            this.netCDFWriteable.write(sourceBand.getName(), origin, (Array)dataTemp);
            pm.worked(1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void deleteOutput() {
        if (this.outputFile != null && this.outputFile.isFile()) {
            this.outputFile.delete();
        }
    }

    public void close() throws IOException {
        this.netCDFWriteable.close();
    }

    public void flush() throws IOException {
        if (this.netCDFWriteable == null) {
            return;
        }
        this.netCDFWriteable.flush();
    }

    public boolean shouldWrite(ProductNode node) {
        return !(node instanceof VirtualBand) && super.shouldWrite(node);
    }

    private void addMetadata(Product product) {
        MetadataElement rootElem = product.getMetadataRoot();
        Group rootGroup = this.netCDFWriteable.getRootGroup();
        this.addElements(rootElem, rootGroup);
        this.addAttributes(rootElem, rootGroup);
    }

    private void addElements(MetadataElement parentElem, Group parentGroup) {
        HashMap<String, Integer> dupeCntElem = new HashMap<String, Integer>();
        for (int i = 0; i < parentElem.getNumElements(); ++i) {
            MetadataElement subElement = parentElem.getElementAt(i);
            String name = subElement.getName();
            boolean lastDupe = true;
            for (int j = i + 1; j < parentElem.getNumElements(); ++j) {
                MetadataElement dupeElement = parentElem.getElementAt(j);
                if (!dupeElement.getName().equals(name)) continue;
                Integer cnt = (Integer)dupeCntElem.get(name);
                if (cnt == null) {
                    dupeCntElem.put(name, 1);
                } else {
                    cnt = cnt + 1;
                    dupeCntElem.put(name, cnt);
                }
                lastDupe = false;
                break;
            }
            if (dupeCntElem.get(name) != null) {
                int cnt = (Integer)dupeCntElem.get(name);
                if (lastDupe) {
                    ++cnt;
                }
                subElement.setName(subElement.getName() + "." + cnt);
            }
            Group newGroup = new Group((NetcdfFile)this.netCDFWriteable, parentGroup, subElement.getName());
            this.addAttributes(subElement, newGroup);
            this.addElements(subElement, newGroup);
            this.netCDFWriteable.addGroup(parentGroup, newGroup);
        }
    }

    private void addAttributes(MetadataElement elem, Group newGroup) {
        HashMap<String, Integer> dupeCntAtrib = new HashMap<String, Integer>();
        for (int i = 0; i < elem.getNumAttributes(); ++i) {
            int dataType;
            MetadataAttribute attrib = elem.getAttributeAt(i);
            String name = attrib.getName();
            boolean lastDupe = true;
            for (int j = i + 1; j < elem.getNumAttributes(); ++j) {
                MetadataAttribute dupeAtrib = elem.getAttributeAt(j);
                if (!dupeAtrib.getName().equals(name)) continue;
                Integer cnt = (Integer)dupeCntAtrib.get(name);
                if (cnt == null) {
                    dupeCntAtrib.put(name, 1);
                } else {
                    cnt = cnt + 1;
                    dupeCntAtrib.put(name, cnt);
                }
                lastDupe = false;
                break;
            }
            if (dupeCntAtrib.get(name) != null) {
                int cnt = (Integer)dupeCntAtrib.get(name);
                if (lastDupe) {
                    ++cnt;
                }
                attrib.setName(attrib.getName() + "." + cnt);
            }
            if ((dataType = attrib.getDataType()) == 30 || dataType == 31) {
                newGroup.addAttribute(new Attribute(attrib.getName(), (Number)elem.getAttributeDouble(attrib.getName(), 0.0)));
                continue;
            }
            if (dataType == 51 || attrib.getData() instanceof ProductData.UTC) {
                newGroup.addAttribute(new Attribute(attrib.getName(), "utc:" + elem.getAttributeString(attrib.getName(), " ")));
                continue;
            }
            if (dataType > 10 && dataType < 30) {
                newGroup.addAttribute(new Attribute(attrib.getName(), (Number)elem.getAttributeInt(attrib.getName(), 0)));
                continue;
            }
            newGroup.addAttribute(new Attribute(attrib.getName(), elem.getAttributeString(attrib.getName(), " ")));
        }
    }
}

