/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.io.netcdf.NcAttributeMap;
import org.esa.s1tbx.io.netcdf.NcRasterDim;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;

public class NetCDFUtils {
    public static Band createBand(Variable variable, int rasterWidth, int rasterHeight) {
        return NetCDFUtils.createBand(variable, rasterWidth, rasterHeight, 0);
    }

    public static Band createBand(Variable variable, int rasterWidth, int rasterHeight, int dataType) {
        NcAttributeMap attMap = NcAttributeMap.create(variable);
        Band band = new Band(variable.getShortName(), dataType == 0 ? NetCDFUtils.getRasterDataType(variable) : dataType, rasterWidth, rasterHeight);
        band.setDescription(NetCDFUtils.getDescription(variable, attMap));
        band.setUnit(NetCDFUtils.getUnit(variable, attMap));
        band.setScalingFactor(NetCDFUtils.getScalingFactor(attMap));
        band.setScalingOffset(NetCDFUtils.getAddOffset(attMap));
        Number noDataValue = NetCDFUtils.getNoDataValue(attMap);
        if (noDataValue != null) {
            band.setNoDataValue(noDataValue.doubleValue());
            band.setNoDataValueUsed(true);
        }
        return band;
    }

    public static TiePointGrid createTiePointGrid(Variable variable, int gridWidth, int gridHeight, int sceneWidth, int sceneHeight) throws IOException {
        NcAttributeMap attMap = NcAttributeMap.create(variable);
        double subSamplingX = (double)sceneWidth / (double)(gridWidth - 1);
        double subSamplingY = (double)sceneHeight / (double)(gridHeight - 1);
        Array data = variable.read();
        float[] dataArray = new float[(int)data.getSize()];
        int i = 0;
        while ((long)i < data.getSize()) {
            dataArray[i] = data.getFloat(i);
            ++i;
        }
        TiePointGrid tpg = new TiePointGrid(variable.getShortName(), gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, dataArray);
        tpg.setDescription(NetCDFUtils.getDescription(variable, attMap));
        tpg.setUnit(NetCDFUtils.getUnit(variable, attMap));
        tpg.setScalingFactor(NetCDFUtils.getScalingFactor(attMap));
        tpg.setScalingOffset(NetCDFUtils.getAddOffset(attMap));
        Number noDataValue = NetCDFUtils.getNoDataValue(attMap);
        if (noDataValue != null) {
            tpg.setNoDataValue(noDataValue.doubleValue());
            tpg.setNoDataValueUsed(true);
        }
        return tpg;
    }

    private static String getDescription(Variable variable, NcAttributeMap attMap) {
        String desc = variable.getDescription();
        if (desc == null || desc.isEmpty()) {
            desc = attMap.getStringValue("description");
        }
        return desc;
    }

    private static String getUnit(Variable variable, NcAttributeMap attMap) {
        String unit = variable.getUnitsString();
        if (unit == null || unit.isEmpty()) {
            unit = attMap.getStringValue("unit");
        }
        return unit;
    }

    private static double getScalingFactor(NcAttributeMap attMap) {
        Number numValue = attMap.getNumericValue("scale_factor");
        if (numValue == null) {
            numValue = attMap.getNumericValue("slope");
        }
        return numValue != null ? numValue.doubleValue() : 1.0;
    }

    private static double getAddOffset(NcAttributeMap attMap) {
        Number numValue = attMap.getNumericValue("add_offset");
        if (numValue == null) {
            numValue = attMap.getNumericValue("intercept");
        }
        return numValue != null ? numValue.doubleValue() : 0.0;
    }

    private static Number getNoDataValue(NcAttributeMap attMap) {
        Number noDataValue = attMap.getNumericValue("_FillValue");
        if (noDataValue == null) {
            noDataValue = attMap.getNumericValue("missing_value");
        }
        return noDataValue;
    }

    public static MapInfoX createMapInfoX(Variable lonVar, Variable latVar, int sceneRasterWidth, int sceneRasterHeight) throws IOException {
        boolean yFlipped;
        float pixelSizeY;
        float pixelSizeX;
        float northing;
        float easting;
        float pixelY;
        float pixelX;
        NcAttributeMap lonAttrMap = NcAttributeMap.create(lonVar);
        Number lonValidMin = lonAttrMap.getNumericValue("valid_min");
        Number lonStep = lonAttrMap.getNumericValue("step");
        NcAttributeMap latAttrMap = NcAttributeMap.create(latVar);
        Number latValidMin = latAttrMap.getNumericValue("valid_min");
        Number latStep = latAttrMap.getNumericValue("step");
        if (lonValidMin != null && lonStep != null && latValidMin != null && latStep != null) {
            pixelX = 0.5f;
            pixelY = (float)sceneRasterHeight - 1.0f + 0.5f;
            easting = lonValidMin.floatValue();
            northing = latValidMin.floatValue();
            pixelSizeX = lonStep.floatValue();
            pixelSizeY = latStep.floatValue();
            yFlipped = true;
        } else {
            Array lonData = lonVar.read();
            Array latData = latVar.read();
            Index i0 = lonData.getIndex().set(0);
            Index i1 = lonData.getIndex().set(1);
            pixelSizeX = lonData.getFloat(i1) - lonData.getFloat(i0);
            easting = lonData.getFloat(i0);
            int latSize = (int)latVar.getSize();
            Index j0 = latData.getIndex().set(0);
            Index j1 = latData.getIndex().set(1);
            pixelSizeY = latData.getFloat(j1) - latData.getFloat(j0);
            pixelX = 0.5f;
            pixelY = 0.5f;
            if (pixelSizeY < 0.0f) {
                pixelSizeY *= -1.0f;
                yFlipped = false;
                northing = latData.getFloat(latData.getIndex().set(0));
            } else {
                yFlipped = true;
                northing = latData.getFloat(latData.getIndex().set(latSize - 1));
            }
        }
        if (pixelSizeX <= 0.0f || pixelSizeY <= 0.0f) {
            return null;
        }
        MapProjection projection = MapProjectionRegistry.getProjection((String)"Geographic Lat/Lon");
        MapInfo mapInfo = new MapInfo(projection, pixelX, pixelY, easting, northing, pixelSizeX, pixelSizeY, Datum.WGS_84);
        mapInfo.setSceneWidth(sceneRasterWidth);
        mapInfo.setSceneHeight(sceneRasterHeight);
        return new MapInfoX(mapInfo, yFlipped);
    }

    private static int getRasterDataType(Variable variable) {
        return NetCDFUtils.getProductDataType(variable.getDataType(), variable.isUnsigned(), true);
    }

    private static boolean isValidRasterDataType(DataType dataType) {
        return NetCDFUtils.getProductDataType(dataType, false, true) != -1;
    }

    private static int getProductDataType(DataType dataType, boolean unsigned, boolean rasterDataOnly) {
        if (dataType == DataType.BYTE) {
            return unsigned ? 20 : 10;
        }
        if (dataType == DataType.SHORT) {
            return unsigned ? 21 : 11;
        }
        if (dataType == DataType.INT) {
            return unsigned ? 22 : 12;
        }
        if (dataType == DataType.FLOAT) {
            return 30;
        }
        if (dataType == DataType.DOUBLE) {
            return 31;
        }
        if (!rasterDataOnly) {
            if (dataType == DataType.CHAR) {
                return 41;
            }
            if (dataType == DataType.STRING) {
                return 41;
            }
        } else if (dataType == DataType.CHAR) {
            return unsigned ? 20 : 10;
        }
        return -1;
    }

    public static void addGroups(MetadataElement parentElem, Group parentGroup) {
        List groupList = parentGroup.getGroups();
        for (Group grp : groupList) {
            MetadataElement newElem = new MetadataElement(grp.getShortName());
            parentElem.addElement(newElem);
            NetCDFUtils.addGroups(newElem, grp);
        }
        NetCDFUtils.addAttributes(parentElem, parentGroup);
    }

    public static MetadataElement addAttributes(MetadataElement parentElem, String elemName, List<Attribute> attribList) {
        MetadataElement globalElem = new MetadataElement(elemName);
        parentElem.addElement(globalElem);
        for (Attribute at : attribList) {
            NetCDFUtils.createMetadataAttributes(globalElem, at, at.getName());
        }
        return globalElem;
    }

    private static void addAttributes(MetadataElement parentElem, Group parentGroup) {
        List attribList = parentGroup.getAttributes();
        for (Attribute at : attribList) {
            NetCDFUtils.createMetadataAttributes(parentElem, at, at.getName());
        }
    }

    private static void createMetadataAttributes(MetadataElement parentElem, Attribute attribute, String name) {
        int i = name.indexOf(47);
        if (i > 0) {
            String elemName = name.substring(0, i);
            String attName = name.substring(i + 1, name.length());
            MetadataElement newElem = parentElem.getElement(elemName);
            if (newElem == null) {
                newElem = new MetadataElement(elemName);
                parentElem.addElement(newElem);
            }
            NetCDFUtils.createMetadataAttributes(newElem, attribute, attName);
        } else {
            int productDataType = NetCDFUtils.getProductDataType(attribute.getDataType(), false, false);
            if (productDataType != -1) {
                ProductData productData;
                if (attribute.isString()) {
                    String strValue = attribute.getStringValue();
                    if (strValue.startsWith("utc:")) {
                        strValue = strValue.substring("utc:".length(), strValue.length());
                        productData = AbstractMetadata.parseUTC((String)strValue);
                    } else {
                        productData = ProductData.createInstance((String)strValue);
                    }
                } else if (attribute.isArray()) {
                    productData = ProductData.createInstance((int)productDataType, (int)attribute.getLength());
                    long size = attribute.getValues().getSize();
                    if (size > 0L) {
                        productData.setElems(attribute.getValues().getStorage());
                    }
                } else {
                    productData = ProductData.createInstance((int)productDataType, (int)1);
                    long size = attribute.getValues().getSize();
                    if (size > 0L) {
                        productData.setElems(attribute.getValues().getStorage());
                    }
                }
                MetadataAttribute metadataAttribute = new MetadataAttribute(name, productData, true);
                parentElem.addAttribute(metadataAttribute);
            }
        }
    }

    public static String getProductType(NcAttributeMap attMap, String defaultType) {
        String productType = attMap.getStringValue("Product Type");
        if (productType == null && (productType = attMap.getStringValue("Product_Type")) == null && (productType = attMap.getStringValue("Conventions")) == null) {
            productType = defaultType;
        }
        return productType;
    }

    public static String getProductDescription(NcAttributeMap attMap) {
        String description = attMap.getStringValue("description");
        if (description == null && (description = attMap.getStringValue("title")) == null) {
            description = attMap.getStringValue("comment");
        }
        return description;
    }

    public static ProductData.UTC getSceneRasterStartTime(NcAttributeMap globalAttributes) {
        return NetCDFUtils.getSceneRasterTime(globalAttributes, "start_date", "start_time");
    }

    public static ProductData.UTC getSceneRasterStopTime(NcAttributeMap globalAttributes) {
        return NetCDFUtils.getSceneRasterTime(globalAttributes, "stop_date", "stop_time");
    }

    private static ProductData.UTC getSceneRasterTime(NcAttributeMap globalAttributes, String dateAttName, String timeAttName) {
        String timeStr;
        String dateStr = globalAttributes.getStringValue(dateAttName);
        String dateTimeStr = NetCDFUtils.getDateTimeString(dateStr, timeStr = globalAttributes.getStringValue(timeAttName));
        if (dateTimeStr != null) {
            try {
                return NetCDFUtils.parseDateTime(dateTimeStr);
            }
            catch (ParseException e) {
                SystemUtils.LOG.warning("Failed to parse time string '" + dateTimeStr + '\'');
            }
        }
        return null;
    }

    private static String getDateTimeString(String dateStr, String timeStr) {
        if (dateStr != null && dateStr.endsWith("UTC")) {
            dateStr = dateStr.substring(0, dateStr.length() - 3).trim();
        }
        if (timeStr != null && timeStr.endsWith("UTC")) {
            timeStr = timeStr.substring(0, timeStr.length() - 3).trim();
        }
        if (dateStr != null && timeStr != null) {
            return dateStr + ' ' + timeStr;
        }
        if (dateStr != null) {
            return dateStr + (dateStr.indexOf(58) == -1 ? " 00:00:00" : "");
        }
        if (timeStr != null) {
            return timeStr + (timeStr.indexOf(58) == -1 ? " 00:00:00" : "");
        }
        return null;
    }

    private static ProductData.UTC parseDateTime(String dateTimeStr) throws ParseException {
        return ProductData.UTC.parse((String)dateTimeStr, (DateFormat)AbstractMetadata.dateFormat);
    }

    private NetCDFUtils() {
    }

    public static Variable[] getRasterVariables(Map<NcRasterDim, List<Variable>> variableLists, NcRasterDim rasterDim) {
        List<Variable> list = variableLists.get(rasterDim);
        return list.toArray(new Variable[list.size()]);
    }

    public static Variable[] getTiePointGridVariables(Map<NcRasterDim, List<Variable>> variableLists, Variable[] rasterVariables) {
        ArrayList<Variable> tpgList = new ArrayList<Variable>();
        Set<NcRasterDim> keySet = variableLists.keySet();
        for (NcRasterDim o : keySet) {
            List<Variable> varList = variableLists.get(o);
            for (Variable var : varList) {
                boolean found = false;
                for (Variable raster : rasterVariables) {
                    if (var != raster) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                tpgList.add(var);
            }
        }
        return tpgList.toArray(new Variable[tpgList.size()]);
    }

    public static NcRasterDim getBestRasterDim(Map<NcRasterDim, List<Variable>> variableListMap) {
        NcRasterDim[] keys = variableListMap.keySet().toArray(new NcRasterDim[variableListMap.keySet().size()]);
        if (keys.length == 0) {
            return null;
        }
        String[] bandNames = new String[]{"amplitude", "intensity", "phase", "band", "proc_data"};
        NcRasterDim bestRasterDim = null;
        for (NcRasterDim rasterDim : keys) {
            if (rasterDim.isTypicalRasterDim()) {
                return rasterDim;
            }
            List<Variable> varList = variableListMap.get(rasterDim);
            if (NetCDFUtils.contains(varList, bandNames)) {
                return rasterDim;
            }
            for (Variable v : varList) {
                String vUnit = v.getUnitsString();
                if (vUnit == null) continue;
                for (String unit : bandNames) {
                    if (!vUnit.equalsIgnoreCase(unit)) continue;
                    return rasterDim;
                }
            }
            if (bestRasterDim != null && bestRasterDim.getDimX().getLength() * bestRasterDim.getDimY().getLength() >= rasterDim.getDimX().getLength() * rasterDim.getDimY().getLength()) continue;
            bestRasterDim = rasterDim;
        }
        return bestRasterDim;
    }

    private static boolean contains(List<Variable> varList, String[] nameList) {
        for (Variable v : varList) {
            String vName = v.getName().toLowerCase();
            for (String str : nameList) {
                if (!vName.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<NcRasterDim, List<Variable>> getVariableListMap(Group group) {
        HashMap<NcRasterDim, List<Variable>> variableLists = new HashMap<NcRasterDim, List<Variable>>(31);
        NetCDFUtils.collectVariableLists(group, variableLists);
        return variableLists;
    }

    private static void collectVariableLists(Group group, Map<NcRasterDim, List<Variable>> variableLists) {
        List variables = group.getVariables();
        for (Variable variable : variables) {
            int rank = variable.getRank();
            if (rank < 2 || !NetCDFUtils.isValidRasterDataType(variable.getDataType())) continue;
            Dimension dimY = variable.getDimension(0);
            Dimension dimX = variable.getDimension(1);
            if (rank >= 3 && dimY.getLength() <= 32) {
                Dimension dim3 = variable.getDimension(2);
                dimY = dimX;
                dimX = dim3;
            }
            if (dimX.getLength() <= 1 || dimY.getLength() <= 1) continue;
            NcRasterDim rasterDim = new NcRasterDim(dimX, dimY);
            List<Variable> list = variableLists.get(rasterDim);
            if (list == null) {
                list = new ArrayList<Variable>();
                variableLists.put(rasterDim, list);
            }
            list.add(variable);
        }
        List subGroups = group.getGroups();
        for (Group subGroup : subGroups) {
            NetCDFUtils.collectVariableLists(subGroup, variableLists);
        }
    }

    public static class MapInfoX {
        final MapInfo _mapInfo;
        final boolean _yFlipped;

        public MapInfoX(MapInfo mapInfo, boolean yFlipped) {
            this._mapInfo = mapInfo;
            this._yFlipped = yFlipped;
        }

        public MapInfo getMapInfo() {
            return this._mapInfo;
        }

        public boolean isYFlipped() {
            return this._yFlipped;
        }
    }
}

