/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.netcdf.NetCDFReader;
import org.esa.s1tbx.io.netcdf.NetcdfConstants;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class NetCDFReaderPlugIn
implements ProductReaderPlugIn {
    protected String[] FORMAT_NAMES = NetcdfConstants.NETCDF_FORMAT_NAMES;
    protected String[] FORMAT_FILE_EXTENSIONS = NetcdfConstants.NETCDF_FORMAT_FILE_EXTENSIONS;
    protected String PLUGIN_DESCRIPTION = "NetCDF Products";
    private final Class[] VALID_INPUT_TYPES = new Class[]{File.class, String.class};

    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        return this.checkProductQualification(file);
    }

    protected DecodeQualification checkProductQualification(File file) {
        String fileName = file.getName().toLowerCase();
        for (String ext : this.FORMAT_FILE_EXTENSIONS) {
            if (ext.isEmpty() || !fileName.endsWith(ext.toLowerCase())) continue;
            return this.isIntended(ext);
        }
        return DecodeQualification.UNABLE;
    }

    protected DecodeQualification isIntended(String extension) {
        return DecodeQualification.INTENDED;
    }

    public Class[] getInputTypes() {
        return this.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new NetCDFReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter(this.FORMAT_NAMES[0], this.FORMAT_FILE_EXTENSIONS, this.PLUGIN_DESCRIPTION);
    }

    public String[] getFormatNames() {
        return this.FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return this.FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return this.PLUGIN_DESCRIPTION;
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter(String formatName, String[] fileExts, String description) {
            super(formatName, fileExts, description);
        }

        public boolean accept(File file) {
            return super.accept(file) && (file.isDirectory() || this.checkExtension(file));
        }
    }
}

