/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NcAttributeMap {
    private final Map<String, Attribute> _map;

    private NcAttributeMap(int initialCapacity) {
        this._map = new HashMap<String, Attribute>(initialCapacity);
    }

    private NcAttributeMap(Attribute[] attributes) {
        this(3 * attributes.length / 2 + 1);
        for (Attribute attribute : attributes) {
            this.put(attribute);
        }
    }

    private NcAttributeMap(List<Attribute> attributes) {
        this(attributes.toArray(new Attribute[attributes.size()]));
    }

    public static NcAttributeMap create(NetcdfFile file) {
        return new NcAttributeMap(file.getGlobalAttributes());
    }

    public static NcAttributeMap create(Group group) {
        return new NcAttributeMap(group.getAttributes());
    }

    public static NcAttributeMap create(Variable variable) {
        return new NcAttributeMap(variable.getAttributes());
    }

    Attribute get(String name) {
        return this._map.get(name);
    }

    void put(Attribute attribute) {
        this._map.put(attribute.getName(), attribute);
    }

    public void clear() {
        this._map.clear();
    }

    public Number getNumericValue(String name) {
        Attribute attribute = this.get(name);
        return attribute != null ? (Number)attribute.getNumericValue() : (Number)null;
    }

    public String getStringValue(String name) {
        Attribute attribute = this.get(name);
        return attribute != null ? attribute.getStringValue() : null;
    }

    public int getValue(String name, int defaultValue) {
        Number numericValue = this.getNumericValue(name);
        return numericValue != null ? numericValue.intValue() : defaultValue;
    }

    public double getValue(String name, double defaultValue) {
        Number numericValue = this.getNumericValue(name);
        return numericValue != null ? numericValue.doubleValue() : defaultValue;
    }

    public String getValue(String name, String defaultValue) {
        String stringValue = this.getStringValue(name);
        return stringValue != null ? stringValue : defaultValue;
    }
}

