/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.kompsat5;

import java.io.File;
import org.esa.s1tbx.io.kompsat5.Kompsat5Reader;
import org.esa.s1tbx.io.netcdf.NetCDFReaderPlugIn;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;

public class Kompsat5ReaderPlugIn
extends NetCDFReaderPlugIn {
    private static final String[] KOMPSAT5_FORMAT_NAMES = new String[]{"Kompsat5"};
    private static final String[] KOMPSAT5_FORMAT_FILE_EXTENSIONS = new String[]{"h5", "tif", "aux.xml"};
    private static final String KOMPSAT5_PLUGIN_DESCRIPTION = "Kompsat-5 Products";
    private static final String KOMPSAT5_FILE_PREFIX = "k5_";

    public Kompsat5ReaderPlugIn() {
        this.FORMAT_NAMES = KOMPSAT5_FORMAT_NAMES;
        this.FORMAT_FILE_EXTENSIONS = KOMPSAT5_FORMAT_FILE_EXTENSIONS;
        this.PLUGIN_DESCRIPTION = KOMPSAT5_PLUGIN_DESCRIPTION;
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String fileName = file.getName().toLowerCase();
        if (fileName.startsWith(KOMPSAT5_FILE_PREFIX)) {
            for (String ext : KOMPSAT5_FORMAT_FILE_EXTENSIONS) {
                if (!fileName.endsWith(ext)) continue;
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    public ProductReader createReaderInstance() {
        return new Kompsat5Reader(this);
    }
}

