/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.kompsat5;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.kompsat5.K5Format;
import org.esa.s1tbx.io.kompsat5.K5GeoTiff;
import org.esa.s1tbx.io.kompsat5.K5HDF;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class Kompsat5Reader
extends SARReader {
    private final ProductReaderPlugIn readerPlugIn;
    private Formats format;
    private K5Format k5Reader;

    public Kompsat5Reader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
        this.readerPlugIn = readerPlugIn;
    }

    private static Formats determineFormat(File inputFile) {
        String name = inputFile.getName().toLowerCase();
        if (name.endsWith(".h5")) {
            return Formats.HDF;
        }
        if (name.endsWith(".tif")) {
            return Formats.GEOTIFF;
        }
        File[] files = inputFile.getParentFile().listFiles();
        if (files != null) {
            for (File file : files) {
                String filename = file.getName().toLowerCase();
                if (filename.endsWith(".h5")) {
                    return Formats.HDF;
                }
                if (!filename.endsWith(".tif")) continue;
                return Formats.GEOTIFF;
            }
        }
        return Formats.GEOTIFF;
    }

    private static File findProductFile(Formats format, File inputFile) {
        String name = inputFile.getName().toLowerCase();
        if (format.equals((Object)Formats.HDF) && name.endsWith(".h5")) {
            return inputFile;
        }
        if (format.equals((Object)Formats.GEOTIFF) && name.endsWith(".tif")) {
            return inputFile;
        }
        File[] files = inputFile.getParentFile().listFiles();
        if (files != null) {
            for (File file : files) {
                String filename = file.getName().toLowerCase();
                if (format.equals((Object)Formats.HDF) && filename.endsWith(".h5")) {
                    return file;
                }
                if (!format.equals((Object)Formats.GEOTIFF) || !filename.endsWith(".tif")) continue;
                return file;
            }
        }
        return inputFile;
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        try {
            File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
            this.format = Kompsat5Reader.determineFormat(inputFile);
            inputFile = Kompsat5Reader.findProductFile(this.format, inputFile);
            if (!this.format.equals((Object)Formats.HDF)) {
                this.k5Reader = new K5GeoTiff(this.readerPlugIn, this);
                throw new IOException("Kompsat-5 in GeoTiff format is not supported.");
            }
            this.k5Reader = new K5HDF(this.readerPlugIn, this);
            Product product = this.k5Reader.open(inputFile);
            Kompsat5Reader.setQuicklookBandName(product);
            this.addQuicklook(product, "Quicklook", Kompsat5Reader.getQuicklookFile(product));
            product.getGcpGroup();
            product.setModified(false);
            return product;
        }
        catch (Exception e) {
            this.handleReaderException(e);
            return null;
        }
    }

    public void close() throws IOException {
        this.k5Reader.close();
        super.close();
    }

    private static File getQuicklookFile(Product product) {
        File[] files;
        File folder = product.getFileLocation().getParentFile();
        for (File file : files = folder.listFiles()) {
            String name = file.getName().toLowerCase();
            if (!name.startsWith("k5_") || !name.endsWith("ql.png")) continue;
            return file;
        }
        return null;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.k5Reader.readBandRasterDataImpl(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
    }

    private static enum Formats {
        HDF,
        GEOTIFF;

    }
}

