/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.kompsat5;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.io.binary.ArrayCopy;
import org.esa.s1tbx.io.kompsat5.K5Format;
import org.esa.s1tbx.io.kompsat5.Kompsat5Reader;
import org.esa.s1tbx.io.netcdf.NcAttributeMap;
import org.esa.s1tbx.io.netcdf.NcRasterDim;
import org.esa.s1tbx.io.netcdf.NcVariableMap;
import org.esa.s1tbx.io.netcdf.NetCDFReader;
import org.esa.s1tbx.io.netcdf.NetCDFUtils;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class K5HDF
implements K5Format {
    private final ProductReaderPlugIn readerPlugIn;
    private final Kompsat5Reader reader;
    private Product product = null;
    private NetcdfFile netcdfFile = null;
    private NcVariableMap variableMap = null;
    private boolean yFlipped = false;
    private boolean useFloatBands = false;
    private boolean isComplex = false;
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private final Map<Band, Variable> bandMap = new HashMap<Band, Variable>(10);

    public K5HDF(ProductReaderPlugIn readerPlugIn, Kompsat5Reader reader) {
        this.readerPlugIn = readerPlugIn;
        this.reader = reader;
    }

    @Override
    public Product open(File inputFile) throws IOException {
        NetcdfFile netcdfFile = NetcdfFile.open((String)inputFile.getPath());
        if (netcdfFile == null) {
            this.close();
            throw new IllegalFileFormatException(inputFile.getName() + " Could not be interpreted by the reader.");
        }
        Map<NcRasterDim, List<Variable>> variableListMap = NetCDFUtils.getVariableListMap(netcdfFile.getRootGroup());
        if (variableListMap.isEmpty()) {
            this.close();
            throw new IllegalFileFormatException("No netCDF variables found which could\nbe interpreted as remote sensing bands.");
        }
        K5HDF.removeQuickLooks(variableListMap);
        NcRasterDim rasterDim = NetCDFUtils.getBestRasterDim(variableListMap);
        Variable[] rasterVariables = K5HDF.getRasterVariables(variableListMap, rasterDim);
        Variable[] tiePointGridVariables = NetCDFUtils.getTiePointGridVariables(variableListMap, rasterVariables);
        this.netcdfFile = netcdfFile;
        this.variableMap = new NcVariableMap(rasterVariables);
        this.yFlipped = false;
        NcAttributeMap globalAttributes = NcAttributeMap.create(this.netcdfFile);
        String productType = NetCDFUtils.getProductType(globalAttributes, this.readerPlugIn.getFormatNames()[0]);
        int rasterWidth = rasterDim.getDimX().getLength();
        int rasterHeight = rasterDim.getDimY().getLength();
        this.product = new Product(inputFile.getName(), productType, rasterWidth, rasterHeight, (ProductReader)this.reader);
        this.product.setFileLocation(inputFile);
        this.product.setDescription(NetCDFUtils.getProductDescription(globalAttributes));
        this.product.setStartTime(NetCDFUtils.getSceneRasterStartTime(globalAttributes));
        this.product.setEndTime(NetCDFUtils.getSceneRasterStopTime(globalAttributes));
        this.addMetadataToProduct();
        this.addBandsToProduct(rasterVariables);
        this.addTiePointGridsToProduct(tiePointGridVariables);
        this.addGeoCodingToProduct(this.product, rasterDim);
        this.addSlantRangeToFirstPixel();
        this.addFirstLastLineTimes(this.product, rasterHeight);
        this.addSRGRCoefficients(this.product);
        K5HDF.addDopplerCentroidCoefficients(this.product);
        return this.product;
    }

    @Override
    public void close() throws IOException {
        if (this.product != null) {
            this.product = null;
            this.variableMap.clear();
            this.variableMap = null;
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
    }

    private static Variable[] getRasterVariables(Map<NcRasterDim, List<Variable>> variableLists, NcRasterDim rasterDim) {
        List<Variable> varList = variableLists.get(rasterDim);
        ArrayList<Variable> list = new ArrayList<Variable>(5);
        for (Variable var : varList) {
            if (var.getShortName().equals("GIM")) continue;
            list.add(var);
        }
        return list.toArray(new Variable[list.size()]);
    }

    private static void removeQuickLooks(Map<NcRasterDim, List<Variable>> variableListMap) {
        String[] excludeList = new String[]{"qlk"};
        NcRasterDim[] keys = variableListMap.keySet().toArray(new NcRasterDim[variableListMap.keySet().size()]);
        ArrayList<NcRasterDim> removeList = new ArrayList<NcRasterDim>();
        block0: for (NcRasterDim rasterDim : keys) {
            List<Variable> varList = variableListMap.get(rasterDim);
            boolean found = false;
            block1: for (Variable v : varList) {
                if (found) continue block0;
                String vName = v.getShortName().toLowerCase();
                for (String str : excludeList) {
                    if (!vName.contains(str)) continue;
                    removeList.add(rasterDim);
                    found = true;
                    continue block1;
                }
            }
        }
        for (NcRasterDim key : removeList) {
            variableListMap.remove(key);
        }
    }

    private void addGeoCodingToProduct(Product product, NcRasterDim rasterDim) throws IOException {
        if (product.getSceneGeoCoding() == null) {
            NetCDFReader.setTiePointGeoCoding(product);
        }
        if (product.getSceneGeoCoding() == null) {
            NetCDFReader.setPixelGeoCoding(product);
        }
        if (product.getSceneGeoCoding() == null) {
            this.yFlipped = NetCDFReader.setMapGeoCoding(rasterDim, product, this.netcdfFile, this.yFlipped);
        }
    }

    private void addMetadataToProduct() throws IOException {
        try {
            MetadataElement origMetadataRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)this.product.getMetadataRoot());
            NetCDFUtils.addAttributes(origMetadataRoot, "Global_Attributes", this.netcdfFile.getGlobalAttributes());
            this.addAuxXML(this.product);
            for (Variable variable : this.variableMap.getAll()) {
                NetCDFUtils.addAttributes(origMetadataRoot, variable.getShortName(), variable.getAttributes());
            }
            this.addAbstractedMetadataHeader(this.product, this.product.getMetadataRoot());
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Error reading metadata for " + this.product.getName() + ": " + e.getMessage());
        }
    }

    private void addAbstractedMetadataHeader(Product product, MetadataElement root) throws IOException {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        String defStr = "-";
        int defInt = 99999;
        MetadataElement origRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)product.getMetadataRoot());
        MetadataElement globalElem = origRoot.getElement("Global_Attributes");
        MetadataElement auxElem = origRoot.getElement("Auxiliary").getElement("Root");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)globalElem.getAttributeString("Product_Filename", "-"));
        String productType = globalElem.getAttributeString("Product_Type", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)productType);
        String mode = globalElem.getAttributeString("Acquisition_Mode", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)mode);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)mode);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)"Kompsat5");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)globalElem, (String)"Product_Generation_UTC", (DateFormat)standardDateFormat));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)globalElem.getAttributeString("Processing_Centre", "-"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)globalElem.getAttributeString("Look_Side", "-").toLowerCase());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)globalElem.getAttributeInt("Orbit_Number", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)globalElem.getAttributeString("Orbit_Direction", "-"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)this.getSampleType(globalElem));
        this.useFloatBands = globalElem.getAttributeString("Sample_Format", "-").equals("FLOAT");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)product));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)(globalElem.getAttributeDouble("Radar_Frequency", 99999.0) / 1000000.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"algorithm", (String)globalElem.getAttributeString("Focusing_Algorithm_ID", "-"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"geo_ref_system", (String)globalElem.getAttributeString("Ellipsoid_Designator", "-"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (double)globalElem.getAttributeDouble("Range_Processing_Number_of_Looks", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (double)globalElem.getAttributeDouble("Azimuth_Processing_Number_of_Looks", 99999.0));
        if (productType.contains("GEC")) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"map_projection", (String)globalElem.getAttributeString("Projection_ID", "-"));
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
        String rngSpreadComp = globalElem.getAttributeString("Range_Spreading_Loss_Compensation_Geometry", "-");
        if (rngSpreadComp.equals("NONE")) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)0);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)1);
        }
        String incAngComp = globalElem.getAttributeString("Incidence_Angle_Compensation_Geometry", "-");
        if (incAngComp.equals("NONE")) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"inc_angle_comp_flag", (int)0);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"inc_angle_comp_flag", (int)1);
        }
        String antElevComp = globalElem.getAttributeString("Range_Antenna_Pattern_Compensation_Geometry", "-");
        if (antElevComp.equals("NONE")) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)0);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)1);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ref_inc_angle", (double)globalElem.getAttributeDouble("Reference_Incidence_Angle", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ref_slant_range", (double)globalElem.getAttributeDouble("Reference_Slant_Range", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ref_slant_range_exp", (double)globalElem.getAttributeDouble("Reference_Slant_Range_Exponent", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"rescaling_factor", (double)globalElem.getAttributeDouble("Rescaling_Factor", 99999.0));
        MetadataElement s01Elem = globalElem.getElement("S01");
        if (s01Elem != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)s01Elem.getAttributeDouble("PRF", 99999.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (double)(s01Elem.getAttributeDouble("Sampling_Rate", 99999.0) / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)s01Elem.getAttributeString("Polarisation", "-"));
            double rangeBW = s01Elem.getAttributeDouble("Range_Focusing_Bandwidth");
            double azimuthBW = s01Elem.getAttributeDouble("Azimuth_Focusing_Bandwidth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeBW / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        } else {
            String prefix = "S01_";
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)globalElem.getAttributeDouble("S01_PRF", 99999.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (double)(globalElem.getAttributeDouble("S01_Sampling_Rate", 99999.0) / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)globalElem.getAttributeString("S01_Polarisation", "-"));
            double rangeBW = globalElem.getAttributeDouble("S01_Range_Focusing_Bandwidth");
            double azimuthBW = globalElem.getAttributeDouble("S01_Azimuth_Focusing_Bandwidth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeBW / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        }
        MetadataElement s02Elem = globalElem.getElement("S02");
        if (s02Elem != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds2_tx_rx_polar", (String)s02Elem.getAttributeString("Polarisation", "-"));
        } else {
            String prefix = "S02_";
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds2_tx_rx_polar", (String)globalElem.getAttributeString("S02_Polarisation", "-"));
        }
        if (this.isComplex) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)0);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)1);
        }
        K5HDF.addOrbitStateVectors(absRoot, globalElem);
    }

    private void addSlantRangeToFirstPixel() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
        MetadataElement bandElem = this.getBandElement(this.product.getBandAt(0));
        if (bandElem != null) {
            double slantRangeTime = bandElem.getAttributeDouble("Zero_Doppler_Range_First_Time", 0.0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(slantRangeTime * 1.49896229E8));
        }
    }

    private static void addOrbitStateVectors(MetadataElement absRoot, MetadataElement globalElem) {
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        ProductData.UTC referenceUTC = ReaderUtils.getTime((MetadataElement)globalElem, (String)"Reference_UTC", (DateFormat)standardDateFormat);
        int numPoints = globalElem.getAttributeInt("Number_of_State_Vectors");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)referenceUTC);
        for (int i = 0; i < numPoints; ++i) {
            double stateVectorTime = globalElem.getAttribute("State_Vectors_Times").getData().getElemDoubleAt(i);
            ProductData.UTC orbitTime = new ProductData.UTC(referenceUTC.getMJD() + stateVectorTime / 86400.0);
            ProductData pos = globalElem.getAttribute("ECEF_Satellite_Position").getData();
            ProductData vel = globalElem.getAttribute("ECEF_Satellite_Velocity").getData();
            double satellitePositionX = pos.getElemDoubleAt(3 * i);
            double satellitePositionY = pos.getElemDoubleAt(3 * i + 1);
            double satellitePositionZ = pos.getElemDoubleAt(3 * i + 2);
            double satelliteVelocityX = vel.getElemDoubleAt(3 * i);
            double satelliteVelocityY = vel.getElemDoubleAt(3 * i + 1);
            double satelliteVelocityZ = vel.getElemDoubleAt(3 * i + 2);
            MetadataElement orbitVectorElem = new MetadataElement("orbit_vector" + (i + 1));
            orbitVectorElem.setAttributeUTC("time", orbitTime);
            orbitVectorElem.setAttributeDouble("x_pos", satellitePositionX);
            orbitVectorElem.setAttributeDouble("y_pos", satellitePositionY);
            orbitVectorElem.setAttributeDouble("z_pos", satellitePositionZ);
            orbitVectorElem.setAttributeDouble("x_vel", satelliteVelocityX);
            orbitVectorElem.setAttributeDouble("y_vel", satelliteVelocityY);
            orbitVectorElem.setAttributeDouble("z_vel", satelliteVelocityZ);
            orbitVectorListElem.addElement(orbitVectorElem);
        }
    }

    private static void addDopplerCentroidCoefficients(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement globalElem = root.getElement("Global_Attributes");
        MetadataElement dopplerCentroidCoefficientsElem = absRoot.getElement("Doppler_Centroid_Coefficients");
        MetadataElement dopplerListElem = new MetadataElement("dop_coef_list.1");
        dopplerCentroidCoefficientsElem.addElement(dopplerListElem);
        ProductData.UTC utcTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        dopplerListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (int)31, (String)"ns", (String)"Slant Range Time");
        AbstractMetadata.setAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (double)0.0);
        for (int i = 0; i < 6; ++i) {
            double coefValue = globalElem.getAttribute("Centroid_vs_Range_Time_Polynomial").getData().getElemDoubleAt(i);
            MetadataElement coefElem = new MetadataElement("coefficient." + (i + 1));
            dopplerListElem.addElement(coefElem);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"dop_coef", (int)31, (String)"", (String)"Doppler Centroid Coefficient");
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"dop_coef", (double)coefValue);
        }
    }

    private void addFirstLastLineTimes(Product product, int rasterHeight) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement globalElem = root.getElement("Global_Attributes");
        MetadataElement bandElem = this.getBandElement(product.getBandAt(0));
        if (bandElem != null) {
            double lastLineTime;
            double referenceUTC = ReaderUtils.getTime((MetadataElement)globalElem, (String)"Reference_UTC", (DateFormat)standardDateFormat).getMJD();
            double firstLineTime = bandElem.getAttributeDouble("Zero_Doppler_Azimuth_First_Time", 0.0) / 86400.0;
            if (firstLineTime == 0.0) {
                MetadataElement s01Elem = globalElem.getElement("S01");
                firstLineTime = s01Elem != null ? s01Elem.getElement("B001").getAttributeDouble("Azimuth_First_Time") / 86400.0 : globalElem.getAttributeDouble("S01_B001_Azimuth_First_Time") / 86400.0;
            }
            if ((lastLineTime = bandElem.getAttributeDouble("Zero_Doppler_Azimuth_Last_Time", 0.0) / 86400.0) == 0.0) {
                MetadataElement s01Elem = globalElem.getElement("S01");
                lastLineTime = s01Elem != null ? s01Elem.getElement("B001").getAttributeDouble("Azimuth_Last_Time") / 86400.0 : globalElem.getAttributeDouble("S01_B001_Azimuth_Last_Time") / 86400.0;
            }
            double lineTimeInterval = bandElem.getAttributeDouble("Line_Time_Interval", 0.0);
            ProductData.UTC startTime = new ProductData.UTC(referenceUTC + firstLineTime);
            ProductData.UTC stopTime = new ProductData.UTC(referenceUTC + lastLineTime);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
            product.setStartTime(startTime);
            product.setEndTime(stopTime);
            if (lineTimeInterval == 0.0 || lastLineTime == 99999.0) {
                lineTimeInterval = ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)stopTime, (int)rasterHeight);
            }
            double lineTimeInterval2 = ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)stopTime, (int)rasterHeight);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)lineTimeInterval);
        }
    }

    private void addSRGRCoefficients(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement globalElem = root.getElement("Global_Attributes");
        MetadataAttribute attribute = globalElem.getAttribute("Ground_Projection_Polynomial_Reference_Range");
        if (attribute == null) {
            return;
        }
        double referenceRange = attribute.getData().getElemDouble();
        MetadataElement bandElem = this.getBandElement(product.getBandAt(0));
        double rangeSpacing = bandElem.getAttributeDouble("Column_Spacing", 99999.0);
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        MetadataElement srgrListElem = new MetadataElement("srgr_coef_list");
        srgrCoefficientsElem.addElement(srgrListElem);
        ProductData.UTC utcTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
        AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)0.0);
        int numCoeffs = 6;
        for (int i = 0; i < 6; ++i) {
            double srgrCoeff = globalElem.getAttribute("Ground_to_Slant_Polynomial").getData().getElemDoubleAt(i);
            srgrCoeff = i == 0 ? (srgrCoeff += referenceRange) : (srgrCoeff /= FastMath.pow((double)rangeSpacing, (int)i));
            MetadataElement coefElem = new MetadataElement("coefficient." + (i + 1));
            srgrListElem.addElement(coefElem);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)srgrCoeff);
        }
    }

    private String getSampleType(MetadataElement globalElem) {
        if (globalElem.getAttributeInt("Samples_per_Pixel", 0) > 1) {
            this.isComplex = true;
            return "COMPLEX";
        }
        this.isComplex = false;
        return "DETECTED";
    }

    private void addBandsToProduct(Variable[] variables) {
        int cnt = 1;
        for (Variable variable : variables) {
            int height = variable.getDimension(0).getLength();
            int width = variable.getDimension(1).getLength();
            String cntStr = "";
            String polStr = K5HDF.getPolarization(this.product, cnt);
            cntStr = polStr != null ? '_' + polStr : "_" + cnt;
            ++cnt;
            if (this.isComplex) {
                Band bandI = this.useFloatBands ? NetCDFUtils.createBand(variable, width, height, 30) : NetCDFUtils.createBand(variable, width, height);
                K5HDF.createUniqueBandName(this.product, bandI, 'i' + cntStr);
                bandI.setUnit("real");
                bandI.setNoDataValue(0.0);
                bandI.setNoDataValueUsed(true);
                this.product.addBand(bandI);
                this.bandMap.put(bandI, variable);
                Band bandQ = this.useFloatBands ? NetCDFUtils.createBand(variable, width, height, 30) : NetCDFUtils.createBand(variable, width, height);
                K5HDF.createUniqueBandName(this.product, bandQ, 'q' + cntStr);
                bandQ.setUnit("imaginary");
                bandQ.setNoDataValue(0.0);
                bandQ.setNoDataValueUsed(true);
                this.product.addBand(bandQ);
                this.bandMap.put(bandQ, variable);
                ReaderUtils.createVirtualIntensityBand((Product)this.product, (Band)bandI, (Band)bandQ, (String)cntStr);
                continue;
            }
            Band band = this.useFloatBands ? NetCDFUtils.createBand(variable, width, height, 30) : NetCDFUtils.createBand(variable, width, height);
            K5HDF.createUniqueBandName(this.product, band, "Amplitude" + cntStr);
            band.setUnit("amplitude");
            band.setNoDataValue(0.0);
            band.setNoDataValueUsed(true);
            this.product.addBand(band);
            this.bandMap.put(band, variable);
            Kompsat5Reader.createVirtualIntensityBand(this.product, band, cntStr);
        }
    }

    private static String getPolarization(Product product, int cnt) {
        MetadataElement globalElem = AbstractMetadata.getOriginalProductMetadata((Product)product).getElement("Global_Attributes");
        if (globalElem != null) {
            MetadataElement s01Elem = globalElem.getElement("S0" + cnt);
            if (s01Elem != null) {
                String polStr = s01Elem.getAttributeString("Polarisation", "");
                if (!polStr.isEmpty()) {
                    return polStr;
                }
            } else {
                String prefix = "S0" + cnt + '_';
                String polStr = globalElem.getAttributeString(prefix + "Polarisation", "");
                if (!polStr.isEmpty()) {
                    return polStr;
                }
            }
        }
        return null;
    }

    private static void createUniqueBandName(Product product, Band band, String origName) {
        int cnt = 1;
        band.setName(origName);
        while (product.getBand(band.getName()) != null) {
            band.setName(origName + cnt);
            ++cnt;
        }
    }

    private void addTiePointGridsToProduct(Variable[] variables) throws IOException {
        MetadataElement bandElem = this.getBandElement(this.product.getBandAt(0));
        K5HDF.addIncidenceAnglesSlantRangeTime(this.product, bandElem);
        K5HDF.addGeocodingFromMetadata(this.product, bandElem);
    }

    private static void addIncidenceAnglesSlantRangeTime(Product product, MetadataElement bandElem) {
        if (bandElem == null) {
            return;
        }
        int gridWidth = 11;
        int gridHeight = 11;
        float subSamplingX = (float)product.getSceneRasterWidth() / 10.0f;
        float subSamplingY = (float)product.getSceneRasterHeight() / 10.0f;
        double nearRangeAngle = bandElem.getAttributeDouble("Near_Incidence_Angle", 0.0);
        double farRangeAngle = bandElem.getAttributeDouble("Far_Incidence_Angle", 0.0);
        double firstRangeTime = bandElem.getAttributeDouble("Zero_Doppler_Range_First_Time", 0.0) * 1.0E9;
        double lastRangeTime = bandElem.getAttributeDouble("Zero_Doppler_Range_Last_Time", 0.0) * 1.0E9;
        float[] incidenceCorners = new float[]{(float)nearRangeAngle, (float)farRangeAngle, (float)nearRangeAngle, (float)farRangeAngle};
        float[] slantRange = new float[]{(float)firstRangeTime, (float)lastRangeTime, (float)firstRangeTime, (float)lastRangeTime};
        float[] fineAngles = new float[121];
        float[] fineTimes = new float[121];
        ReaderUtils.createFineTiePointGrid((int)2, (int)2, (int)11, (int)11, (float[])incidenceCorners, (float[])fineAngles);
        ReaderUtils.createFineTiePointGrid((int)2, (int)2, (int)11, (int)11, (float[])slantRange, (float[])fineTimes);
        TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, fineAngles);
        incidentAngleGrid.setUnit("deg");
        product.addTiePointGrid(incidentAngleGrid);
        TiePointGrid slantRangeGrid = new TiePointGrid("slant_range_time", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, fineTimes);
        slantRangeGrid.setUnit("ns");
        product.addTiePointGrid(slantRangeGrid);
    }

    private MetadataElement getBandElement(Band band) {
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)this.product);
        Variable variable = this.bandMap.get(band);
        String varName = variable.getShortName();
        MetadataElement bandElem = null;
        for (MetadataElement elem : root.getElements()) {
            if (!elem.getName().equalsIgnoreCase(varName)) continue;
            bandElem = elem;
            break;
        }
        return bandElem;
    }

    private static void addGeocodingFromMetadata(Product product, MetadataElement bandElem) {
        if (bandElem == null) {
            return;
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        try {
            String str = bandElem.getAttributeString("Top_Left_Geodetic_Coordinates");
            float latUL = Float.parseFloat(str.substring(0, str.indexOf(44)));
            float lonUL = Float.parseFloat(str.substring(str.indexOf(44) + 1, str.lastIndexOf(44)));
            str = bandElem.getAttributeString("Top_Right_Geodetic_Coordinates");
            float latUR = Float.parseFloat(str.substring(0, str.indexOf(44)));
            float lonUR = Float.parseFloat(str.substring(str.indexOf(44) + 1, str.lastIndexOf(44)));
            str = bandElem.getAttributeString("Bottom_Left_Geodetic_Coordinates");
            float latLL = Float.parseFloat(str.substring(0, str.indexOf(44)));
            float lonLL = Float.parseFloat(str.substring(str.indexOf(44) + 1, str.lastIndexOf(44)));
            str = bandElem.getAttributeString("Bottom_Right_Geodetic_Coordinates");
            float latLR = Float.parseFloat(str.substring(0, str.indexOf(44)));
            float lonLR = Float.parseFloat(str.substring(str.indexOf(44) + 1, str.lastIndexOf(44)));
            absRoot.setAttributeDouble("first_near_lat", (double)latUL);
            absRoot.setAttributeDouble("first_near_long", (double)lonUL);
            absRoot.setAttributeDouble("first_far_lat", (double)latUR);
            absRoot.setAttributeDouble("first_far_long", (double)lonUR);
            absRoot.setAttributeDouble("last_near_lat", (double)latLL);
            absRoot.setAttributeDouble("last_near_long", (double)lonLL);
            absRoot.setAttributeDouble("last_far_lat", (double)latLR);
            absRoot.setAttributeDouble("last_far_long", (double)lonLR);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)bandElem.getAttributeDouble("Column_Spacing", 99999.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)bandElem.getAttributeDouble("Line_Spacing", 99999.0));
            float[] latCorners = new float[]{latUL, latUR, latLL, latLR};
            float[] lonCorners = new float[]{lonUL, lonUR, lonLL, lonLR};
            ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertTrue((String)"sourceStepX == 1 && sourceStepY == 1", (sourceStepX == 1 && sourceStepY == 1 ? 1 : 0) != 0);
        Guardian.assertTrue((String)"sourceWidth == destWidth", (sourceWidth == destWidth ? 1 : 0) != 0);
        Guardian.assertTrue((String)"sourceHeight == destHeight", (sourceHeight == destHeight ? 1 : 0) != 0);
        int sceneHeight = this.product.getSceneRasterHeight();
        int y0 = this.yFlipped ? sceneHeight - 1 - sourceOffsetY : sourceOffsetY;
        Variable variable = this.bandMap.get(destBand);
        int rank = variable.getRank();
        int[] origin = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shape[i] = 1;
            origin[i] = 0;
        }
        shape[0] = 1;
        shape[1] = destWidth;
        origin[1] = sourceOffsetX;
        if (this.isComplex && destBand.getUnit().equals("imaginary")) {
            origin[2] = 1;
        }
        pm.beginTask("Reading data from band " + destBand.getName(), destHeight);
        try {
            for (int y = 0; y < destHeight; ++y) {
                Array array;
                origin[0] = this.yFlipped ? y0 - y : y0 + y;
                NetcdfFile netcdfFile = this.netcdfFile;
                synchronized (netcdfFile) {
                    array = variable.read(origin, shape);
                }
                if (destBand.getDataType() == 30) {
                    for (int x = 0; x < destWidth; ++x) {
                        destBuffer.setElemFloatAt(y * destWidth + x, ArrayCopy.toFloat(array.getShort(x)));
                    }
                } else {
                    System.arraycopy(array.getStorage(), 0, destBuffer.getElems(), y * destWidth, destWidth);
                }
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new IOException("Process terminated by user.");
            }
        }
        catch (InvalidRangeException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            pm.done();
        }
    }
}

