/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.kompsat5;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.io.kompsat5.K5Format;
import org.esa.s1tbx.io.kompsat5.Kompsat5Reader;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

public class K5GeoTiff
implements K5Format {
    private final ProductReaderPlugIn readerPlugIn;
    private final Kompsat5Reader reader;
    private Product product;
    private final ProductReader geoTiffReader;

    public K5GeoTiff(ProductReaderPlugIn readerPlugIn, Kompsat5Reader reader) {
        this.readerPlugIn = readerPlugIn;
        this.reader = reader;
        this.geoTiffReader = ProductIO.getProductReader((String)"GeoTiff");
    }

    @Override
    public Product open(File inputFile) throws IOException {
        this.product = this.geoTiffReader.readProductNodes((Object)inputFile, null);
        this.product.setFileLocation(inputFile);
        this.addAuxXML(this.product);
        this.addExtraBands(inputFile, this.product);
        return this.product;
    }

    private void addExtraBands(File inputFile, Product product) throws IOException {
        File[] files;
        String name = inputFile.getName().toLowerCase();
        if ((name.contains("I_SCS") || name.contains("I_SCS")) && (files = inputFile.getParentFile().listFiles()) != null) {
            for (File file : files) {
                String fname = inputFile.getName().toLowerCase();
                if (!fname.endsWith(".tif") || fname.equals(name)) continue;
                Product product2 = this.geoTiffReader.readProductNodes((Object)file, null);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.product != null) {
            this.product = null;
        }
    }

    @Override
    public void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.geoTiffReader.readBandRasterData(destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
    }
}

