/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.imageio;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class ImageIOWriter
extends AbstractProductWriter {
    private File file;
    private ImageOutputStream _outputStream;
    private ImageWriter writer;
    private String format = "";
    private int[] dataArray = null;
    private int pos = 0;

    public ImageIOWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    public void setFormatName(String formatName) {
        this.format = formatName;
    }

    protected void writeProductNodesImpl() throws IOException {
        this._outputStream = null;
        this.file = ReaderUtils.getFileFromInput((Object)this.getOutput());
        if (!this.file.getName().toLowerCase().endsWith(this.format.toLowerCase())) {
            this.file = new File(this.file.getAbsolutePath() + '.' + this.format.toLowerCase());
        }
        Iterator<ImageWriter> writerList = ImageIO.getImageWritersBySuffix(this.format);
        this.writer = writerList.next();
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        this._outputStream = ImageIO.createImageOutputStream(this.file);
        this.writer.setOutput(this._outputStream);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.getSourceProduct());
        AbstractMetadataIO.saveExternalMetadata((Product)this.getSourceProduct(), (MetadataElement)absRoot, (File)this.file);
        this.setIncrementalMode(false);
    }

    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        try {
            ImageWriteParam param = this.writer.getDefaultWriteParam();
            boolean canWriteTiles = param.canWriteTiles();
            if (sourceHeight == sourceBand.getRasterHeight() || sourceOffsetY == sourceBand.getRasterHeight() - 1) {
                this.writer.write(null, new IIOImage((RenderedImage)sourceBand.getSourceImage(), null, null), param);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage() + "\nTry using convertDataType to convert to UInt8 or a data type supported by the image format");
        }
    }

    private static RenderedImage createRenderedImage(int[] array, int w, int h) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)3, (int)w, (int)h, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferInt dataBuffer = new DataBufferInt(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, new Hashtable());
    }

    public void deleteOutput() {
    }

    public void flush() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.flush();
        }
    }

    public void close() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.flush();
            this._outputStream.close();
            this._outputStream = null;
        }
        if (this.writer != null) {
            this.writer.dispose();
        }
    }

    public boolean shouldWrite(ProductNode node) {
        return !(node instanceof VirtualBand) && super.shouldWrite(node);
    }
}

