/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.imageio;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;
import org.esa.snap.runtime.Config;

public class ImageIOFile {
    private final String name;
    private int sceneWidth = 0;
    private int sceneHeight = 0;
    private int dataType;
    private int numImages = 1;
    private int numBands = 1;
    private ImageInfo imageInfo = null;
    private IndexCoding indexCoding = null;
    private boolean isIndexed = false;
    private final File productInputFile;
    private ImageInputStream stream = null;
    private ImageReader reader;
    private static final boolean useFileCache = Config.instance().preferences().getBoolean("s1tbx.readers.useFileCache", false);

    public ImageIOFile(File inputFile, ImageReader iioReader, File productInputFile) throws IOException {
        this(inputFile.getName(), ImageIO.createImageInputStream(inputFile), iioReader, productInputFile);
    }

    public ImageIOFile(String name, ImageInputStream inputStream, ImageReader iioReader, File productInputFile) throws IOException {
        this.name = name;
        this.stream = inputStream;
        if (this.stream == null) {
            throw new IOException("Unable to open ");
        }
        this.productInputFile = productInputFile;
        this.createReader(iioReader);
    }

    public ImageIOFile(String name, ImageInputStream inputStream, ImageReader iioReader, int numImages, int numBands, int dataType, File productInputFile) throws IOException {
        this.name = name;
        this.stream = inputStream;
        if (this.stream == null) {
            throw new IOException("Unable to open ");
        }
        this.reader = iioReader;
        this.initReader();
        this.numImages = numImages;
        this.numBands = numBands;
        this.dataType = dataType;
        this.productInputFile = productInputFile;
    }

    public void initReader() {
        if (this.reader != null) {
            this.reader.setInput(this.stream, false, true);
        }
    }

    private synchronized void createReader(ImageReader iioReader) throws IOException {
        this.reader = iioReader;
        this.initReader();
        this.numImages = this.reader.getNumImages(!this.reader.isSeekForwardOnly());
        if (this.numImages < 0) {
            this.numImages = 1;
        }
        this.numBands = 3;
        this.dataType = 12;
        ImageTypeSpecifier its = this.reader.getRawImageType(0);
        if (its != null) {
            this.numBands = this.reader.getRawImageType(0).getNumBands();
            this.dataType = ImageIOFile.bufferImageTypeToProductType(its.getBufferedImageType());
            if (its.getBufferedImageType() == 13) {
                this.isIndexed = true;
                this.createIndexedImageInfo(its.getColorModel());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public static ImageReader getIIOReader(File inputFile) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(inputFile);
        if (stream == null) {
            throw new IOException("Unable to open " + inputFile.toString());
        }
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        if (!imageReaders.hasNext()) {
            throw new IOException("No ImageIO reader found for " + inputFile.toString());
        }
        return imageReaders.next();
    }

    public static ImageReader getTiffIIOReader(ImageInputStream stream) throws IOException {
        ImageReader reader = null;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        while (imageReaders.hasNext()) {
            ImageReader iioReader = imageReaders.next();
            if (!(iioReader instanceof TIFFImageReader)) continue;
            reader = iioReader;
            break;
        }
        if (reader == null) {
            throw new IOException("Unable to open " + stream.toString());
        }
        reader.setInput(stream, true, true);
        return reader;
    }

    public ImageReader getReader() throws IOException {
        if (this.reader == null) {
            throw new IOException("no reader created");
        }
        return this.reader;
    }

    private static int bufferImageTypeToProductType(int biType) {
        switch (biType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 12;
            }
            case 5: 
            case 6: 
            case 7: {
                return 11;
            }
            case 8: 
            case 9: 
            case 11: {
                return 21;
            }
            case 10: 
            case 12: 
            case 13: {
                return 10;
            }
        }
        return 0;
    }

    final void createIndexedImageInfo(ColorModel colorModel) {
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        this.indexCoding = new IndexCoding("color_map");
        int colorCount = indexColorModel.getMapSize();
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[colorCount];
        for (int j = 0; j < colorCount; ++j) {
            String name = "I%3d";
            this.indexCoding.addIndex(String.format("I%3d", j), j, "");
            points[j] = new ColorPaletteDef.Point((double)j, new Color(indexColorModel.getRGB(j)), "I%3d");
        }
        this.imageInfo = new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public IndexCoding getIndexCoding() {
        return this.indexCoding;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.reader != null) {
            this.reader.dispose();
        }
    }

    public int getSceneWidth() throws IOException {
        if (this.sceneWidth == 0) {
            this.sceneWidth = this.reader.getWidth(0);
        }
        return this.sceneWidth;
    }

    public int getSceneHeight() throws IOException {
        if (this.sceneHeight == 0) {
            this.sceneHeight = this.reader.getHeight(0);
        }
        return this.sceneHeight;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getNumImages() {
        return this.numImages;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public void readImageIORasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, int bandSampleOffset) throws IOException {
        ImageReadParam param = this.reader.getDefaultReadParam();
        param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
        Raster data = this.getData(param, destOffsetX, destOffsetY, destWidth, destHeight);
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int dataBufferType = dataBuffer.getDataType();
        int sampleOffset = imageID + bandSampleOffset;
        Object dest = destBuffer.getElems();
        try {
            if (dest instanceof int[] && (dataBufferType == 1 || dataBufferType == 2 || dataBufferType == 3)) {
                sampleModel.getSamples(0, 0, destWidth, destHeight, sampleOffset, (int[])dest, dataBuffer);
            } else if (dataBufferType == 4 && dest instanceof float[]) {
                sampleModel.getSamples(0, 0, destWidth, destHeight, sampleOffset, (float[])dest, dataBuffer);
            } else if (dataBufferType == 5 && dest instanceof double[]) {
                sampleModel.getSamples(0, 0, destWidth, destHeight, sampleOffset, (double[])dest, dataBuffer);
            } else {
                double[] dArray = new double[destWidth * destHeight];
                sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), sampleOffset, dArray, dataBuffer);
                int i = 0;
                for (double value : dArray) {
                    destBuffer.setElemDoubleAt(i++, value);
                }
            }
        }
        catch (Exception e) {
            try {
                double[] dArray = new double[destWidth * destHeight];
                sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), sampleOffset, dArray, dataBuffer);
                int i = 0;
                for (double value : dArray) {
                    destBuffer.setElemDoubleAt(i++, value);
                }
            }
            catch (Exception e2) {
                int size = destWidth * destHeight;
                for (int i = 0; i < size; ++i) {
                    destBuffer.setElemDoubleAt(i++, 0.0);
                }
            }
        }
    }

    private synchronized Raster getData(ImageReadParam param, int destOffsetX, int destOffsetY, int destWidth, int destHeight) throws IOException {
        try {
            RenderedImage image = this.reader.readAsRenderedImage(0, param);
            return image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
        }
        catch (Exception e) {
            if (ZipUtils.isZip((File)this.productInputFile) && !ZipUtils.isValid((File)this.productInputFile)) {
                throw new IOException("Zip file is corrupt " + this.productInputFile.getName());
            }
            throw e;
        }
    }

    private static File createCacheDir() throws IOException {
        File cacheDir = new File(SystemUtils.getCacheDir(), "temp");
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IOException("Failed to create directory '" + cacheDir + "'.");
        }
        return cacheDir;
    }

    public static ImageInputStream createImageInputStream(InputStream inStream, Dimension bandDimensions) throws IOException {
        long size = bandDimensions.width * bandDimensions.height;
        return useFileCache || size > 500000000L ? new FileCacheImageInputStream(inStream, ImageIOFile.createCacheDir()) : new MemoryCacheImageInputStream(inStream);
    }

    public static class BandInfo {
        public final int imageID;
        public final int bandSampleOffset;
        public final ImageIOFile img;
        public boolean isImaginary = false;

        public BandInfo(Band band, ImageIOFile imgFile, int id, int offset) {
            this.img = imgFile;
            this.imageID = id;
            this.bandSampleOffset = offset;
            this.isImaginary = band.getUnit() != null && band.getUnit().equals("imaginary");
        }
    }
}

