/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.generic;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;

public class GenericBSQWriter
extends AbstractProductWriter {
    private ImageOutputStream _outputStream = null;
    private String bandName = null;
    private int bandCounter = 0;
    private int numOfWriteBands = 0;

    public GenericBSQWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    protected void writeProductNodesImpl() throws IOException {
        File file = this.getOutput() instanceof String ? new File((String)this.getOutput()) : (File)this.getOutput();
        this._outputStream = new FileImageOutputStream(file);
        this._outputStream.setByteOrder(ByteOrder.nativeOrder());
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.getSourceProduct());
        AbstractMetadataIO.saveExternalMetadata((Product)this.getSourceProduct(), (MetadataElement)absRoot, (File)file);
        int numOfBands = this.getSourceProduct().getNumBands();
        for (int i = 0; i < numOfBands; ++i) {
            if (this.getSourceProduct().getBandAt(i) instanceof VirtualBand) continue;
            ++this.numOfWriteBands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull((String)"sourceBand", (Object)sourceBand);
        Guardian.assertNotNull((String)"sourceBuffer", (Object)sourceBuffer);
        GenericBSQWriter.checkBufferSize(sourceWidth, sourceHeight, sourceBuffer);
        int sourceBandWidth = sourceBand.getRasterWidth();
        int sourceBandHeight = sourceBand.getRasterHeight();
        GenericBSQWriter.checkSourceRegionInsideBandRegion(sourceWidth, sourceBandWidth, sourceHeight, sourceBandHeight, sourceOffsetX, sourceOffsetY);
        if (this.bandName == null) {
            this.bandName = sourceBand.getName();
        } else if (!this.bandName.equals(sourceBand.getName())) {
            this.bandName = sourceBand.getName();
            ++this.bandCounter;
        }
        long outputPos = sourceOffsetY * (this.numOfWriteBands * sourceBandWidth) + sourceOffsetX + this.bandCounter * sourceBandWidth;
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", sourceHeight);
        try {
            long max = sourceHeight * sourceWidth;
            int sourcePos = 0;
            while ((long)sourcePos < max) {
                sourceBuffer.writeTo(sourcePos, sourceWidth, this._outputStream, outputPos);
                outputPos += (long)(this.numOfWriteBands * sourceBandWidth);
                sourcePos += sourceWidth;
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private static void checkSourceRegionInsideBandRegion(int sourceWidth, int sourceBandWidth, int sourceHeight, int sourceBandHeight, int sourceOffsetX, int sourceOffsetY) {
        Guardian.assertWithinRange((String)"sourceWidth", (long)sourceWidth, (long)1L, (long)sourceBandWidth);
        Guardian.assertWithinRange((String)"sourceHeight", (long)sourceHeight, (long)1L, (long)sourceBandHeight);
        Guardian.assertWithinRange((String)"sourceOffsetX", (long)sourceOffsetX, (long)0L, (long)(sourceBandWidth - sourceWidth));
        Guardian.assertWithinRange((String)"sourceOffsetY", (long)sourceOffsetY, (long)0L, (long)(sourceBandHeight - sourceHeight));
    }

    private static void checkBufferSize(int sourceWidth, int sourceHeight, ProductData sourceBuffer) {
        int expectedBufferSize = sourceWidth * sourceHeight;
        int actualBufferSize = sourceBuffer.getNumElems();
        Guardian.assertEquals((String)"sourceWidth * sourceHeight", (long)actualBufferSize, (long)expectedBufferSize);
    }

    public void deleteOutput() {
    }

    public void flush() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.flush();
        }
    }

    public void close() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.flush();
            this._outputStream.close();
            this._outputStream = null;
        }
    }

    public boolean shouldWrite(ProductNode node) {
        return !(node instanceof VirtualBand) && super.shouldWrite(node);
    }
}

