/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.util.Map;
import org.esa.s1tbx.io.gamma.HeaderParser;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class Header {
    static final String UNKNOWN_SENSOR_TYPE = "Unknown Sensor Type";
    private final HeaderParser headerParser;
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd-SSSSSSSS");

    public Header(BufferedReader reader) throws IOException {
        this.headerParser = HeaderParser.parse(reader);
    }

    public ByteOrder getJavaByteOrder() {
        if (this.getByteOrder() == 0) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public String getName() {
        return this.headerParser.getString("title", "");
    }

    public int getNumSamples() {
        int val = this.headerParser.getInt("range_samples", 0);
        if (val == 0) {
            val = this.headerParser.getInt("range_samp_1", 0);
        }
        if (val == 0) {
            val = this.headerParser.getInt("width", 0);
        }
        if (val == 0) {
            val = this.headerParser.getInt("ncolumns");
        }
        return val;
    }

    public int getNumLines() {
        int val = this.headerParser.getInt("azimuth_lines", 0);
        if (val == 0) {
            val = this.headerParser.getInt("az_samp_1", 0);
        }
        if (val == 0) {
            val = this.headerParser.getInt("height", 0);
        }
        if (val == 0) {
            val = this.headerParser.getInt("nlines");
        }
        return val;
    }

    public int getNumBands() {
        return this.headerParser.getInt("bands", 0);
    }

    public int getHeaderOffset() {
        return this.headerParser.getInt("line_header_size", 0);
    }

    public String getDataType() {
        return this.headerParser.getString("image_format", "Unknown");
    }

    public String getSensorType() {
        return this.headerParser.getString("sensor", UNKNOWN_SENSOR_TYPE);
    }

    public int getByteOrder() {
        return this.headerParser.getInt("byte order", 0);
    }

    public String[] getBandNames() {
        return this.headerParser.getStrings("band names");
    }

    public String getDescription() {
        return this.headerParser.getString("sensor", null);
    }

    public double getRadarFrequency() {
        return this.headerParser.getDouble("radar_frequency", 0);
    }

    public double getPRF() {
        return this.headerParser.getDouble("prf", 0);
    }

    public int getRangeLooks() {
        return this.headerParser.getInt("range_looks", 1);
    }

    public int getAzimuthLooks() {
        return this.headerParser.getInt("azimuth_looks", 1);
    }

    public double getLineTimeInterval() {
        return this.headerParser.getDouble("azimuth_line_time", 0);
    }

    public ProductData.UTC getStartTime() {
        String[] dateValues;
        String timeStr = null;
        String dateStr = this.headerParser.getString("date", null);
        if (dateStr != null && (dateValues = StringUtils.split((String)dateStr, (char[])new char[]{' '}, (boolean)true)).length > 2) {
            String year = dateValues[0];
            String month = dateValues[1];
            String day = dateValues[2];
            double startTime = this.headerParser.getDouble("start_time");
            timeStr = year + '-' + month + '-' + day + '-' + startTime;
        }
        return AbstractMetadata.parseUTC(timeStr, (DateFormat)dateFormat);
    }

    public ProductData.UTC getEndTime() {
        String[] dateValues;
        String timeStr = null;
        String dateStr = this.headerParser.getString("date", null);
        if (dateStr != null && (dateValues = StringUtils.split((String)dateStr, (char[])new char[]{' '}, (boolean)true)).length > 2) {
            String year = dateValues[0];
            String month = dateValues[1];
            String day = dateValues[2];
            double endTime = this.headerParser.getDouble("end_time");
            timeStr = year + '-' + month + '-' + day + '-' + endTime;
        }
        return AbstractMetadata.parseUTC(timeStr, (DateFormat)dateFormat);
    }

    public MetadataElement getAsMetadata() {
        MetadataElement headerElem = new MetadataElement("Header");
        for (Map.Entry<String, String> entry : this.headerParser.getHeaderEntries()) {
            String value = entry.getValue().isEmpty() ? " " : entry.getValue();
            headerElem.setAttributeString(entry.getKey(), value);
        }
        return headerElem;
    }
}

