/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.gamma.Header;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class GammaReader
extends AbstractProductReader {
    private Header header;
    private boolean isComplex = false;
    private boolean isCoregistered = false;
    private Map<Band, ImageInputStream> bandImageInputStreamMap = new HashMap<Band, ImageInputStream>();

    public GammaReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Product readProductNodesImpl() throws IOException {
        File inputParFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        try (BufferedReader headerReader = new BufferedReader(new FileReader(inputParFile));){
            Product imageFiles;
            this.header = new Header(headerReader);
            this.isComplex = this.isComplex(inputParFile);
            this.isCoregistered = this.isCoregistered(inputParFile);
            String productType = this.isComplex ? "SLC" : this.header.getDataType();
            Product product = new Product(this.header.getName(), productType, this.header.getNumSamples(), this.header.getNumLines());
            product.setProductReader((ProductReader)this);
            product.setFileLocation(inputParFile);
            product.setDescription(this.header.getDescription());
            product.getMetadataRoot().addElement(this.header.getAsMetadata());
            int dataType = this.getDataType();
            for (File imgFile : imageFiles = this.findImageFiles(inputParFile)) {
                FileImageInputStream inStream = new FileImageInputStream(imgFile);
                inStream.setByteOrder(this.header.getJavaByteOrder());
                if (this.isComplex) {
                    Band tgtBandI = new Band("i_" + imgFile.getName(), dataType, this.header.getNumSamples(), this.header.getNumLines());
                    tgtBandI.setUnit("real");
                    product.addBand(tgtBandI);
                    Band tgtBandQ = new Band("q_" + imgFile.getName(), dataType, this.header.getNumSamples(), this.header.getNumLines());
                    tgtBandQ.setUnit("imaginary");
                    product.addBand(tgtBandQ);
                    this.bandImageInputStreamMap.put(tgtBandI, inStream);
                    this.bandImageInputStreamMap.put(tgtBandQ, inStream);
                    ReaderUtils.createVirtualIntensityBand((Product)product, (Band)tgtBandI, (Band)tgtBandQ, (String)imgFile.getName());
                    ReaderUtils.createVirtualPhaseBand((Product)product, (Band)tgtBandI, (Band)tgtBandQ, (String)("_" + imgFile.getName()));
                    continue;
                }
                Band tgtBand = new Band(imgFile.getName(), dataType, this.header.getNumSamples(), this.header.getNumLines());
                product.addBand(tgtBand);
                this.bandImageInputStreamMap.put(tgtBand, inStream);
            }
            this.addGeoCoding(product);
            this.addMetaData(product);
            Product product2 = product;
            return product2;
        }
    }

    private boolean isComplex(File file) {
        String name = file.getName().toLowerCase();
        String ext = FileUtils.getExtension((String)(name = FileUtils.getFilenameWithoutExtension((String)name)));
        return ext != null && (ext.endsWith("slc") || ext.endsWith("diff"));
    }

    private boolean isCoregistered(File file) {
        String name = file.getName().toLowerCase();
        String ext = FileUtils.getExtension((String)(name = FileUtils.getFilenameWithoutExtension((String)name)));
        return ext != null && ext.endsWith("rslc");
    }

    private int getDataType() throws IOException {
        String imageFormat = this.header.getDataType();
        if ("SCOMPLEX".equals(imageFormat)) {
            return 11;
        }
        if ("FCOMPLEX".endsWith(imageFormat)) {
            return 30;
        }
        return 30;
    }

    private File[] findImageFiles(File parFile) {
        File[] files = parFile.getParentFile().listFiles();
        String baseName = FileUtils.getFilenameWithoutExtension((File)parFile);
        ArrayList<File> fileList = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith(baseName) || file.getName().equals(parFile.getName())) continue;
                fileList.add(file);
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private File getImageFile(File parFile) {
        return new File(parFile.getParentFile(), FileUtils.getFilenameWithoutExtension((File)parFile));
    }

    private void addGeoCoding(Product product) {
    }

    private void addMetaData(Product product) {
        MetadataElement root = product.getMetadataRoot();
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.header.getName());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)this.header.getSensorType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)this.header.getDescription());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)(this.isComplex ? "SLC" : this.header.getDataType()));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"sample_type", (String)(this.isComplex ? "COMPLEX" : "DETECTED"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)this.header.getNumSamples());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)this.header.getNumLines());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)this.header.getStartTime());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)this.header.getEndTime());
        product.setStartTime(this.header.getStartTime());
        product.setEndTime(this.header.getEndTime());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)this.header.getLineTimeInterval());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)this.header.getRadarFrequency());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)this.header.getPRF());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (int)this.header.getRangeLooks());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (int)this.header.getAzimuthLooks());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)(this.isCoregistered ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ImageInputStream inStream = this.bandImageInputStreamMap.get(destBand);
        if (this.isComplex) {
            int sourceMaxY = sourceOffsetY + sourceHeight;
            int elemSize = destBuffer.getElemSize();
            int bandIndex = 0;
            if (destBand.getUnit() != null && destBand.getUnit().equals("imaginary")) {
                bandIndex = 1;
            }
            int numInterleaved = 2;
            long lineSizeInBytes = this.header.getNumSamples() * numInterleaved * elemSize;
            ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)(sourceWidth * numInterleaved));
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                long xPos = elemSize * sourceOffsetX * numInterleaved;
                int xLength = sourceWidth * numInterleaved;
                int dstCnt = 0;
                for (int sourceY = sourceOffsetY; sourceY < sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    ImageInputStream imageInputStream = inStream;
                    synchronized (imageInputStream) {
                        inStream.seek((long)sourceY * lineSizeInBytes + xPos);
                        lineData.readFrom(0, xLength, inStream);
                    }
                    for (int x = 0; x < sourceWidth; ++x) {
                        destBuffer.setElemDoubleAt(dstCnt++, lineData.getElemDoubleAt(x * numInterleaved + bandIndex));
                    }
                    pm.worked(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                pm.done();
            }
        } else {
            int sourceMaxY = sourceOffsetY + sourceHeight - 1;
            Product product = destBand.getProduct();
            int elemSize = destBuffer.getElemSize();
            int headerOffset = this.header.getHeaderOffset();
            int bandIndex = product.getBandIndex(destBand.getName());
            long lineSizeInBytes = this.header.getNumSamples() * elemSize;
            ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)sourceWidth);
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    ImageInputStream dstCnt = inStream;
                    synchronized (dstCnt) {
                        long lineStartPos = (long)headerOffset + (long)sourceY * lineSizeInBytes;
                        inStream.seek(lineStartPos + (long)(elemSize * sourceOffsetX));
                        lineData.readFrom(0, sourceWidth, inStream);
                    }
                    for (int x = 0; x < sourceWidth; ++x) {
                        destBuffer.setElemDoubleAt(destPos++, lineData.getElemDoubleAt(x + bandIndex));
                    }
                    pm.worked(1);
                }
            }
            catch (Exception exception) {
            }
            finally {
                pm.done();
            }
        }
    }

    public void close() throws IOException {
        for (ImageInputStream inStream : this.bandImageInputStreamMap.values()) {
            if (inStream == null) continue;
            inStream.close();
        }
        super.close();
    }
}

