/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s1tbx.io.FileImageOutputStreamExtImpl;
import org.esa.s1tbx.io.gamma.HeaderWriter;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.esa.snap.core.util.Guardian;

public class GammaProductWriter
extends AbstractProductWriter {
    private File outputDir;
    private File outputFile;
    private Product srcProduct;
    private Map<Band, ImageOutputStream> bandOutputStreams;
    private HeaderWriter headerWriter;

    public GammaProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    protected void writeProductNodesImpl() throws IOException {
        Object output = this.getOutput();
        this.outputFile = null;
        if (output instanceof String) {
            this.outputFile = new File((String)output);
        } else if (output instanceof File) {
            this.outputFile = (File)output;
        }
        this.outputDir = this.outputFile.getParentFile();
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.srcProduct = this.getSourceProduct();
        this.srcProduct.setProductWriter((ProductWriter)this);
        this.headerWriter = new HeaderWriter(this, this.srcProduct, this.outputFile);
        this.headerWriter.writeParFile();
    }

    private ImageOutputStream createImageOutputStream(Band band) throws IOException {
        FileImageOutputStreamExtImpl out = new FileImageOutputStreamExtImpl(this.getValidImageFile(band));
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        return out;
    }

    private String createImageFilename(Band band) {
        return this.headerWriter.getBaseFileName() + "_" + band.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull((String)"sourceBand", (Object)sourceBand);
        Guardian.assertNotNull((String)"sourceBuffer", (Object)sourceBuffer);
        int sourceBandWidth = sourceBand.getRasterWidth();
        int elemSize = this.headerWriter.getHighestElemSize();
        ImageOutputStream outputStream = this.getOrCreateImageOutputStream(sourceBand);
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", sourceHeight);
        try {
            if (GammaProductWriter.isComplex((RasterDataNode)sourceBand)) {
                int numInterleaved = 2;
                Rectangle rect = new Rectangle(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
                Tile sourceTile = GammaProductWriter.getSourceTile((RasterDataNode)this.getComplexSrcBand(sourceBand), rect);
                ProductData qSourceBuffer = sourceTile.getRawSamples();
                int srcCnt = 0;
                if (elemSize >= 4) {
                    float[] destBuffer = new float[sourceWidth * numInterleaved];
                    for (long y = (long)sourceOffsetY; y < (long)(sourceOffsetY + sourceHeight); ++y) {
                        int dstCnt = 0;
                        for (int x = sourceOffsetX; x < sourceOffsetX + sourceWidth; ++x) {
                            destBuffer[dstCnt++] = sourceBuffer.getElemFloatAt(srcCnt);
                            destBuffer[dstCnt++] = qSourceBuffer.getElemFloatAt(srcCnt);
                            ++srcCnt;
                        }
                        outputStream.seek((long)elemSize * (y * (long)sourceBandWidth + (long)sourceOffsetX) * (long)numInterleaved);
                        outputStream.writeFloats(destBuffer, 0, destBuffer.length);
                    }
                } else {
                    short[] destBuffer = new short[sourceWidth * numInterleaved];
                    for (long y = (long)sourceOffsetY; y < (long)(sourceOffsetY + sourceHeight); ++y) {
                        int dstCnt = 0;
                        for (int x = sourceOffsetX; x < sourceOffsetX + sourceWidth; ++x) {
                            destBuffer[dstCnt++] = (short)sourceBuffer.getElemFloatAt(srcCnt);
                            destBuffer[dstCnt++] = (short)qSourceBuffer.getElemFloatAt(srcCnt);
                            ++srcCnt;
                        }
                        outputStream.seek((long)elemSize * (y * (long)sourceBandWidth + (long)sourceOffsetX) * (long)numInterleaved);
                        outputStream.writeShorts(destBuffer, 0, destBuffer.length);
                    }
                }
            } else {
                long outputPos = (long)sourceOffsetY * (long)sourceBandWidth + (long)sourceOffsetX;
                long max = sourceHeight * sourceWidth;
                int sourcePos = 0;
                while ((long)sourcePos < max) {
                    sourceBuffer.writeTo(sourcePos, sourceWidth, outputStream, outputPos);
                    outputPos += (long)sourceBandWidth;
                    sourcePos += sourceWidth;
                }
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private Band getComplexSrcBand(Band iBand) {
        String name = iBand.getName();
        if (name.startsWith("i_")) {
            name = name.replace("i_", "q_");
        } else if (name.startsWith("q_")) {
            name = name.replace("q_", "i_");
        }
        return this.srcProduct.getBand(name);
    }

    private static Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region) {
        MultiLevelImage image = rasterDataNode.getSourceImage();
        Raster awtRaster = image.getData(region);
        return new TileImpl(rasterDataNode, awtRaster);
    }

    public void flush() throws IOException {
        if (this.bandOutputStreams == null) {
            return;
        }
        for (ImageOutputStream o : this.bandOutputStreams.values()) {
            o.flush();
        }
    }

    public void close() throws IOException {
        if (this.bandOutputStreams == null) {
            return;
        }
        for (ImageOutputStream o : this.bandOutputStreams.values()) {
            o.close();
        }
        this.bandOutputStreams.clear();
        this.bandOutputStreams = null;
    }

    public void deleteOutput() throws IOException {
        this.flush();
        this.close();
        if (this.outputFile != null && this.outputFile.exists() && this.outputFile.isFile()) {
            this.outputFile.delete();
        }
    }

    private ImageOutputStream getOrCreateImageOutputStream(Band band) throws IOException {
        ImageOutputStream outputStream = this.getImageOutputStream(band);
        if (outputStream == null) {
            outputStream = this.createImageOutputStream(band);
            if (this.bandOutputStreams == null) {
                this.bandOutputStreams = new HashMap<Band, ImageOutputStream>();
            }
            this.bandOutputStreams.put(band, outputStream);
        }
        return outputStream;
    }

    private ImageOutputStream getImageOutputStream(Band band) {
        if (this.bandOutputStreams != null) {
            return this.bandOutputStreams.get(band);
        }
        return null;
    }

    public boolean shouldWrite(ProductNode node) {
        Band band;
        if (node instanceof VirtualBand) {
            return false;
        }
        if (node instanceof FilterBand) {
            return false;
        }
        if (node instanceof Band && "imaginary".equals((band = (Band)node).getUnit())) {
            return false;
        }
        if (node.isModified()) {
            return true;
        }
        if (!this.isIncrementalMode()) {
            return true;
        }
        if (!(node instanceof Band)) {
            return true;
        }
        File imageFile = this.getImageFile((Band)node);
        return imageFile == null || !imageFile.exists();
    }

    private File getImageFile(Band band) {
        String filename = band.getName();
        if (!filename.contains(".")) {
            filename = filename + ".rslc";
        }
        if (filename.startsWith("i_") || filename.startsWith("q_")) {
            filename = filename.substring(2);
        }
        return new File(this.outputDir, filename);
    }

    private File getValidImageFile(Band band) throws IOException {
        File file = this.getImageFile(band);
        if (file.exists()) {
            if (file.length() != GammaProductWriter.getImageFileSize((RasterDataNode)band)) {
                GammaProductWriter.createPhysicalFile(file, GammaProductWriter.getImageFileSize((RasterDataNode)band));
            }
        } else {
            GammaProductWriter.createPhysicalFile(file, GammaProductWriter.getImageFileSize((RasterDataNode)band));
        }
        return file;
    }

    private static long getImageFileSize(RasterDataNode band) {
        long numInterleaved = 1L;
        if (GammaProductWriter.isComplex(band)) {
            numInterleaved = 2L;
        }
        return (long)ProductData.getElemSize((int)band.getDataType()) * (long)band.getRasterWidth() * (long)band.getRasterHeight() * numInterleaved;
    }

    private static void createPhysicalFile(File file, long fileSize) throws IOException {
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Unable to create folders in " + parentDir);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.setLength(fileSize);
        randomAccessFile.close();
    }

    private static boolean isComplex(RasterDataNode band) {
        String unit = band.getUnit();
        return unit != null && unit.equals("real");
    }
}

