/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.radarsat;

import Jama.Matrix;
import com.bc.ceres.core.VirtualDir;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatConstants;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatImageFile;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatLeaderFile;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatTrailerFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.Maths;

class RadarsatProductDirectory
extends CEOSProductDirectory {
    private RadarsatImageFile[] imageFiles = null;
    private RadarsatLeaderFile leaderFile = null;
    private RadarsatTrailerFile trailerFile = null;
    private final transient Map<String, RadarsatImageFile> bandImageFileMap = new HashMap<String, RadarsatImageFile>(1);

    public RadarsatProductDirectory(VirtualDir dir) {
        Guardian.assertNotNull((String)"dir", (Object)dir);
        this.constants = new RadarsatConstants();
        this.productDir = dir;
    }

    @Override
    protected void readProductDirectory() throws IOException, IllegalBinaryFormatException {
        BinaryRecord histogramRec;
        this.readVolumeDirectoryFileStream();
        this.leaderFile = new RadarsatLeaderFile(this.getCEOSFile((String[])this.constants.getLeaderFilePrefix())[0].imgInputStream);
        CEOSProductDirectory.CeosFile[] trlFile = this.getCEOSFile(this.constants.getTrailerFilePrefix());
        if (trlFile.length > 0) {
            this.trailerFile = new RadarsatTrailerFile(trlFile[0].imgInputStream);
        }
        if ((histogramRec = this.leaderFile.getHistogramRecord()) == null) {
            histogramRec = this.trailerFile.getHistogramRecord();
        }
        CEOSProductDirectory.CeosFile[] ceosFiles = this.getCEOSFile(this.constants.getImageFilePrefix());
        ArrayList<RadarsatImageFile> imgArray = new ArrayList<RadarsatImageFile>(ceosFiles.length);
        for (CEOSProductDirectory.CeosFile imageFile : ceosFiles) {
            try {
                RadarsatImageFile imgFile = new RadarsatImageFile(imageFile.imgInputStream, histogramRec);
                imgArray.add(imgFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.imageFiles = imgArray.toArray(new RadarsatImageFile[imgArray.size()]);
        this.sceneWidth = this.imageFiles[0].getRasterWidth();
        this.sceneHeight = this.imageFiles[0].getRasterHeight();
        RadarsatProductDirectory.assertSameWidthAndHeightForAllImages(this.imageFiles, this.sceneWidth, this.sceneHeight);
    }

    @Override
    public Product createProduct() throws IOException {
        BinaryRecord mapProjRec;
        BinaryRecord detProcRec;
        BinaryRecord sceneRec;
        assert (this.productType != null);
        this.productType = RadarsatProductDirectory.extractProductType(this.productType);
        Product product = new Product(this.getProductName(), this.productType, this.sceneWidth, this.sceneHeight);
        if (this.imageFiles.length > 1) {
            int index = 1;
            for (RadarsatImageFile imageFile : this.imageFiles) {
                if (this.isProductSLC) {
                    Band bandI = this.createBand(product, "i_" + index, "real", imageFile);
                    Band bandQ = this.createBand(product, "q_" + index, "imaginary", imageFile);
                    ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)("_" + index));
                } else {
                    Band band = this.createBand(product, "Amplitude_" + index, "amplitude", imageFile);
                    SARReader.createVirtualIntensityBand(product, band, "_" + index);
                }
                ++index;
            }
        } else {
            RadarsatImageFile imageFile = this.imageFiles[0];
            if (this.isProductSLC) {
                Band bandI = this.createBand(product, "i", "real", imageFile);
                Band bandQ = this.createBand(product, "q", "imaginary", imageFile);
                ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)"");
            } else {
                Band band = this.createBand(product, "Amplitude", "amplitude", imageFile);
                SARReader.createVirtualIntensityBand(product, band, "");
            }
        }
        BinaryRecord facilityRec = this.leaderFile.getFacilityRecord();
        if (facilityRec == null) {
            facilityRec = this.trailerFile.getFacilityRecord();
        }
        if ((sceneRec = this.leaderFile.getSceneRecord()) == null) {
            sceneRec = this.trailerFile.getSceneRecord();
        }
        if ((detProcRec = this.leaderFile.getDetailedProcessingRecord()) == null) {
            detProcRec = this.trailerFile.getDetailedProcessingRecord();
        }
        if ((mapProjRec = this.leaderFile.getMapProjRecord()) == null) {
            mapProjRec = this.trailerFile.getMapProjRecord();
        }
        product.setStartTime(RadarsatProductDirectory.getUTCScanStartTime(sceneRec, detProcRec));
        product.setEndTime(RadarsatProductDirectory.getUTCScanStopTime(sceneRec, detProcRec));
        product.setDescription(this.getProductDescription());
        this.addMetaData(product);
        this.addRSATTiePointGrids(product, sceneRec, detProcRec);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        TiePointGrid slantRangeTimeTPG = product.getTiePointGrid("slant_range_time");
        if (slantRangeTimeTPG != null) {
            int numOutputLines = absRoot.getAttributeInt("num_output_lines");
            double slantRangeTime = slantRangeTimeTPG.getPixelDouble(numOutputLines / 2, 0) / 1.0E9;
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(slantRangeTime * 1.49896229E8));
        }
        float[] latCorners = RadarsatLeaderFile.getLatCorners(this.leaderFile.getMapProjRecord());
        float[] lonCorners = RadarsatLeaderFile.getLonCorners(this.leaderFile.getMapProjRecord());
        if (latCorners == null || lonCorners == null) {
            latCorners = this.imageFiles[0].getLatCorners();
            lonCorners = this.imageFiles[0].getLonCorners();
        }
        if (latCorners != null && lonCorners != null) {
            ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
        }
        if (product.getSceneGeoCoding() == null) {
            RadarsatProductDirectory.addGeoCodingFromSceneLabel(product);
        }
        if (product.getSceneGeoCoding() == null) {
            RadarsatProductDirectory.addTPGGeoCoding(product, sceneRec);
        }
        if (mapProjRec == null) {
            RadarsatProductDirectory.setLatLonMetadata(product, absRoot);
        }
        return product;
    }

    private static String extractProductType(String productType) {
        if (productType.contains("SLC")) {
            return "SLC";
        }
        if (productType.contains("SGF")) {
            return "SGF";
        }
        if (productType.contains("SGX")) {
            return "SGX";
        }
        if (productType.contains("SSG")) {
            return "SSG";
        }
        if (productType.contains("SCN")) {
            return "SCN";
        }
        if (productType.contains("SCW")) {
            return "SCW";
        }
        return productType;
    }

    public boolean isRadarsat() throws IOException {
        String volumeId = this.getVolumeId().toUpperCase();
        String logicalVolumeId = this.getLogicalVolumeId().toUpperCase();
        return volumeId.contains("RSAT") || volumeId.contains("RADARSAT") || logicalVolumeId.contains("RSAT") || logicalVolumeId.contains("RADARSAT");
    }

    @Override
    public CEOSImageFile getImageFile(Band band) {
        return this.bandImageFileMap.get(band.getName());
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.imageFiles.length; ++i) {
            this.imageFiles[i].close();
            this.imageFiles[i] = null;
        }
        this.imageFiles = null;
    }

    private Band createBand(Product product, String name, String unit, RadarsatImageFile imageFile) {
        Band band = this.createBand(product, name, unit, imageFile.getBitsPerSample());
        this.bandImageFileMap.put(name, imageFile);
        return band;
    }

    private void addMetaData(Product product) throws IOException {
        MetadataElement root = AbstractMetadata.addOriginalProductMetadata((MetadataElement)product.getMetadataRoot());
        MetadataElement leadMetadata = new MetadataElement("Leader");
        this.leaderFile.addMetadata(leadMetadata);
        root.addElement(leadMetadata);
        MetadataElement trailMetadata = new MetadataElement("Trailer");
        this.trailerFile.addMetadata(trailMetadata);
        root.addElement(trailMetadata);
        MetadataElement volMetadata = new MetadataElement("Volume");
        this.volumeDirectoryFile.assignMetadataTo(volMetadata);
        root.addElement(volMetadata);
        int c = 1;
        for (RadarsatImageFile imageFile : this.imageFiles) {
            imageFile.assignMetadataTo(root, c++);
        }
        RadarsatProductDirectory.addSummaryMetadata(this.findFile("summary.txt"), "Summary Information", root);
        RadarsatProductDirectory.addSummaryMetadata(this.findFile("scene01.lbl"), "Scene Label", root);
        RadarsatProductDirectory.addSummaryMetadata(this.findFile("scene01.lbl"), "Scene Label", root);
        this.addAbstractedMetadataHeader(product, product.getMetadataRoot());
    }

    private void addAbstractedMetadataHeader(Product product, MetadataElement root) {
        BinaryRecord detProcRec;
        BinaryRecord sceneRec;
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        BinaryRecord mapProjRec = this.leaderFile.getMapProjRecord();
        if (mapProjRec == null) {
            mapProjRec = this.trailerFile.getMapProjRecord();
        }
        if ((sceneRec = this.leaderFile.getSceneRecord()) == null) {
            sceneRec = this.trailerFile.getSceneRecord();
        }
        BinaryRecord radiometricRec = this.leaderFile.getRadiometricRecord();
        BinaryRecord facilityRec = this.leaderFile.getFacilityRecord();
        if (facilityRec == null) {
            facilityRec = this.trailerFile.getFacilityRecord();
        }
        if ((detProcRec = this.leaderFile.getDetailedProcessingRecord()) == null) {
            detProcRec = this.trailerFile.getDetailedProcessingRecord();
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.getProductName());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.getProductType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)sceneRec.getAttributeString("Product type descriptor"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)"RS1");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)RadarsatProductDirectory.getProcTime(this.volumeDirectoryFile.getVolumeDescriptorRecord()));
        ProductData.UTC startTime = RadarsatProductDirectory.getUTCScanStartTime(sceneRec, detProcRec);
        ProductData.UTC endTime = RadarsatProductDirectory.getUTCScanStopTime(sceneRec, detProcRec);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)endTime);
        if (mapProjRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)RadarsatProductDirectory.getPass(mapProjRec, sceneRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-pixel distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-line distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)RadarsatProductDirectory.isGroundRange(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"map_projection", (String)this.getMapProjection(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"geo_ref_system", (String)mapProjRec.getAttributeString("Name of reference ellipsoid"));
        } else if (sceneRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)sceneRec.getAttributeDouble("Pixel spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)sceneRec.getAttributeDouble("Line spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)RadarsatProductDirectory.getPass(mapProjRec, sceneRec));
        }
        if (sceneRec != null) {
            double radarWaveLength;
            int absOrbit = Integer.parseInt(sceneRec.getAttributeString("Orbit number").trim());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)absOrbit);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)SARReader.findPolarizationInBandName(sceneRec.getAttributeString("Sensor ID and mode of operation for this channel")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"algorithm", (String)sceneRec.getAttributeString("Processing algorithm identifier"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in azimuth"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in range"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (Double)sceneRec.getAttributeDouble("Pulse Repetition Frequency"));
            double radarFreq = sceneRec.getAttributeDouble("Radar frequency");
            if (Double.compare(radarFreq, 0.0) == 0 && Double.compare(radarWaveLength = sceneRec.getAttributeDouble("Radar wavelength").doubleValue(), 0.0) != 0) {
                radarFreq = 2.99792458E8 / radarWaveLength / 1000000.0;
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)radarFreq);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (Double)sceneRec.getAttributeDouble("Range sampling rate"));
            double rangeBW = sceneRec.getAttributeDouble("Total processor bandwidth in range");
            double azimuthBW = sceneRec.getAttributeDouble("Total processor bandwidth in azimuth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeBW / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)this.getSampleType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)endTime, (int)this.sceneHeight));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)product));
        if (facilityRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)AbstractMetadata.parseUTC((String)facilityRec.getAttributeString("Time of input state vector used to processed the image")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)facilityRec.getAttributeInt("Antenna pattern correction flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)facilityRec.getAttributeInt("Range spreading loss compensation flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"replica_power_corr_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"abs_calibration_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"calibration_factor", (Double)facilityRec.getAttributeDouble("Absolute calibration constant K"));
        }
        if (radiometricRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"calibration_factor", (Double)radiometricRec.getAttributeDouble("Calibration constant"));
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"replica_power_corr_flag", (int)0);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"abs_calibration_flag", (int)0);
        RadarsatProductDirectory.addOrbitStateVectors(absRoot, this.leaderFile.getPlatformPositionRecord());
        if (facilityRec != null) {
            RadarsatProductDirectory.addSRGRCoefficients(absRoot, facilityRec);
        } else {
            RadarsatProductDirectory.addSRGRCoefficients(absRoot, detProcRec);
        }
    }

    private String getMapProjection(BinaryRecord mapProjRec) {
        if (this.productType.contains("IMG") || this.productType.contains("GEC") || this.productType.contains("SSG")) {
            return mapProjRec.getAttributeString("Map projection descriptor");
        }
        return " ";
    }

    private String getProductName() {
        return this.volumeDirectoryFile.getProductName();
    }

    private String getProductDescription() {
        BinaryRecord sceneRecord = this.leaderFile.getSceneRecord();
        if (sceneRecord == null) {
            sceneRecord = this.trailerFile.getSceneRecord();
        }
        String level = "";
        if (sceneRecord != null) {
            level = sceneRecord.getAttributeString("Scene reference number").trim();
        }
        return "Radarsat product " + level;
    }

    private static void addGeoCodingFromSceneLabel(Product product) {
        MetadataElement sceneLabelElem = AbstractMetadata.getOriginalProductMetadata((Product)product).getElement("Scene Label");
        if (sceneLabelElem != null) {
            try {
                String ulLatLon = sceneLabelElem.getAttributeString("UL_CORNER_LAT_LON");
                String urLatLon = sceneLabelElem.getAttributeString("UR_CORNER_LAT_LON");
                String llLatLon = sceneLabelElem.getAttributeString("LL_CORNER_LAT_LON");
                String lrLatLon = sceneLabelElem.getAttributeString("LR_CORNER_LAT_LON");
                float latUL = Float.parseFloat(ulLatLon.substring(0, ulLatLon.indexOf(44)));
                float latUR = Float.parseFloat(urLatLon.substring(0, urLatLon.indexOf(44)));
                float latLL = Float.parseFloat(llLatLon.substring(0, llLatLon.indexOf(44)));
                float latLR = Float.parseFloat(lrLatLon.substring(0, lrLatLon.indexOf(44)));
                float[] latCorners = new float[]{latUL, latUR, latLL, latLR};
                float lonUL = Float.parseFloat(ulLatLon.substring(ulLatLon.indexOf(44) + 1, ulLatLon.length() - 1));
                float lonUR = Float.parseFloat(urLatLon.substring(urLatLon.indexOf(44) + 1, urLatLon.length() - 1));
                float lonLL = Float.parseFloat(llLatLon.substring(llLatLon.indexOf(44) + 1, llLatLon.length() - 1));
                float lonLR = Float.parseFloat(lrLatLon.substring(lrLatLon.indexOf(44) + 1, lrLatLon.length() - 1));
                float[] lonCorners = new float[]{lonUL, lonUR, lonLL, lonLR};
                ReaderUtils.addGeoCoding((Product)product, (float[])latCorners, (float[])lonCorners);
            }
            catch (Exception e) {
                Debug.trace((String)e.toString());
            }
        }
    }

    protected static void addOrbitStateVectors(MetadataElement absRoot, BinaryRecord platformPosRec) {
        if (platformPosRec == null) {
            return;
        }
        try {
            MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
            int numPoints = platformPosRec.getAttributeInt("Number of data points");
            double theta = platformPosRec.getAttributeDouble("Greenwich mean hour angle");
            for (int i = 1; i <= numPoints; ++i) {
                RadarsatProductDirectory.addVector("orbit_vector", orbitVectorListElem, platformPosRec, theta, i);
            }
            if (absRoot.getAttributeUTC("STATE_VECTOR_TIME", AbstractMetadata.NO_METADATA_UTC).equalElems((ProductData)AbstractMetadata.NO_METADATA_UTC)) {
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)RadarsatProductDirectory.getOrbitTime(platformPosRec, 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, BinaryRecord platformPosRec, double theta, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        double xPosECI = platformPosRec.getAttributeDouble("Position vector X " + num);
        double yPosECI = platformPosRec.getAttributeDouble("Position vector Y " + num);
        double zPosECI = platformPosRec.getAttributeDouble("Position vector Z " + num);
        double xVelECI = platformPosRec.getAttributeDouble("Velocity vector X' " + num) / 1000.0;
        double yVelECI = platformPosRec.getAttributeDouble("Velocity vector Y' " + num) / 1000.0;
        double zVelECI = platformPosRec.getAttributeDouble("Velocity vector Z' " + num) / 1000.0;
        double thetaInRd = theta * (Math.PI / 180);
        double cosTheta = FastMath.cos((double)thetaInRd);
        double sinTheta = FastMath.sin((double)thetaInRd);
        double xPosECEF = cosTheta * xPosECI + sinTheta * yPosECI;
        double yPosECEF = -sinTheta * xPosECI + cosTheta * yPosECI;
        double zPosECEF = zPosECI;
        double t = RadarsatProductDirectory.getOrbitTime(platformPosRec, num).getMJD() / 36525.0;
        double a1 = 3.164400184812866E9;
        double a2 = 0.093104;
        double a3 = -6.2E-6;
        double thp = (a1 + 2.0 * a2 * t + 3.0 * a3 * t * t) / 240.0 * Math.PI / 180.0 / 3.15576E9;
        double xVelECEF = -sinTheta * thp * xPosECI + cosTheta * thp * yPosECI + cosTheta * xVelECI + sinTheta * yVelECI;
        double yVelECEF = -cosTheta * thp * xPosECI - sinTheta * thp * yPosECI - sinTheta * xVelECI + cosTheta * yVelECI;
        double zVelECEF = zVelECI;
        orbitVectorElem.setAttributeUTC("time", RadarsatProductDirectory.getOrbitTime(platformPosRec, num));
        orbitVectorElem.setAttributeDouble("x_pos", xPosECEF);
        orbitVectorElem.setAttributeDouble("y_pos", yPosECEF);
        orbitVectorElem.setAttributeDouble("z_pos", zPosECEF);
        orbitVectorElem.setAttributeDouble("x_vel", xVelECEF);
        orbitVectorElem.setAttributeDouble("y_vel", yVelECEF);
        orbitVectorElem.setAttributeDouble("z_vel", zVelECEF);
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    protected static void addSRGRCoefficients(MetadataElement absRoot, BinaryRecord detailedProcRec) {
        if (detailedProcRec == null) {
            return;
        }
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        int numSRGRCoefSets = detailedProcRec.getAttributeInt("Number of SRGR coefficient sets");
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-DDD-HH:mm:ss");
        for (int i = 1; i <= numSRGRCoefSets; ++i) {
            MetadataElement srgrListElem = new MetadataElement("srgr_coef_list." + i);
            srgrCoefficientsElem.addElement(srgrListElem);
            String updateTimeStr = detailedProcRec.getAttributeString("SRGR update date/time " + i);
            ProductData.UTC utcTime = AbstractMetadata.parseUTC((String)updateTimeStr, (DateFormat)dateFormat);
            srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
            AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)0.0);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients1 " + i, 1);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients2 " + i, 2);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients3 " + i, 3);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients4 " + i, 4);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients5 " + i, 5);
            RadarsatProductDirectory.addSRGRCoef(srgrListElem, detailedProcRec, "SRGR coefficients6 " + i, 6);
        }
    }

    private void addRSATTiePointGrids(Product product, BinaryRecord sceneRec, BinaryRecord detProcRec) {
        int i;
        int gridWidth = 11;
        int gridHeight = 11;
        int sceneWidth = product.getSceneRasterWidth();
        int sceneHeight = product.getSceneRasterHeight();
        int subSamplingX = sceneWidth / 10;
        int subSamplingY = sceneHeight / 10;
        float[] rangeDist = new float[121];
        float[] rangeTime = new float[121];
        int k = 0;
        for (int j = 0; j < 11; ++j) {
            int y = Math.min(j * subSamplingY, sceneHeight - 1);
            double slantRangeToFirstPixel = this.imageFiles[0].getSlantRangeToFirstPixel(y);
            double slantRangeToMidPixel = this.imageFiles[0].getSlantRangeToMidPixel(y);
            double slantRangeToLastPixel = this.imageFiles[0].getSlantRangeToLastPixel(y);
            double[] polyCoef = RadarsatProductDirectory.computePolynomialCoefficients(slantRangeToFirstPixel, slantRangeToMidPixel, slantRangeToLastPixel, sceneWidth);
            for (i = 0; i < 11; ++i) {
                int x = i * subSamplingX;
                rangeDist[k++] = (float)(polyCoef[0] + polyCoef[1] * (double)x + polyCoef[2] * (double)x * (double)x);
            }
        }
        for (k = 0; k < rangeDist.length; ++k) {
            rangeTime[k] = (float)((double)rangeDist[k] / 1.49896229E8 * 1.0E9);
        }
        TiePointGrid slantRangeGrid = new TiePointGrid("slant_range_time", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, rangeTime);
        slantRangeGrid.setUnit("ns");
        product.addTiePointGrid(slantRangeGrid);
        if (detProcRec == null) {
            return;
        }
        double r = RadarsatProductDirectory.calculateEarthRadius(sceneRec);
        double eph_orb_data = detProcRec.getAttributeDouble("Ephemeris orbit data1");
        double h = eph_orb_data - r;
        float[] angles = new float[121];
        k = 0;
        for (int j = 0; j < 11; ++j) {
            for (i = 0; i < 11; ++i) {
                double RS = rangeDist[k];
                double a = (h * h - RS * RS + 2.0 * r * h) / (2.0 * RS * r);
                angles[k] = (float)(FastMath.acos((double)a) * 57.29577951308232);
                ++k;
            }
        }
        TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, angles);
        incidentAngleGrid.setUnit("deg");
        product.addTiePointGrid(incidentAngleGrid);
    }

    private static double[] computePolynomialCoefficients(double slantRangeToFirstPixel, double slantRangeToMidPixel, double slantRangeToLastPixel, int imageWidth) {
        boolean firstPixel = false;
        int midPixel = imageWidth / 2;
        int lastPixel = imageWidth - 1;
        double[] idxArray = new double[]{0.0, midPixel, lastPixel};
        double[] rangeArray = new double[]{slantRangeToFirstPixel, slantRangeToMidPixel, slantRangeToLastPixel};
        Matrix A = Maths.createVandermondeMatrix((double[])idxArray, (int)2);
        Matrix b = new Matrix(rangeArray, 3);
        Matrix x = A.solve(b);
        return x.getColumnPackedCopy();
    }

    private static double calculateEarthRadius(BinaryRecord sceneRec) {
        double platLat = sceneRec.getAttributeDouble("Sensor platform geodetic latitude at nadir");
        double a = FastMath.tan((double)(platLat * (Math.PI / 180)));
        double a2 = a * a;
        double ellipmin = 6356752.314245179;
        double ellipmin2 = 4.0408299984661445E13;
        double ellipmaj = 6378137.0;
        double ellipmaj2 = 4.0680631590769E13;
        return 6356752.314245179 * (Math.sqrt(1.0 + a2) / Math.sqrt(0.9933056200098587 + a2));
    }

    private static void addTPGGeoCoding(Product product, BinaryRecord sceneRec) throws IOException {
        OrbitStateVector[] orbitStateVectors;
        int gridWidth = 11;
        int gridHeight = 11;
        float[] targetLatTiePoints = new float[121];
        float[] targetLonTiePoints = new float[121];
        int sourceImageWidth = product.getSceneRasterWidth();
        int sourceImageHeight = product.getSceneRasterHeight();
        double subSamplingX = (double)sourceImageWidth / 10.0;
        double subSamplingY = (double)sourceImageHeight / 10.0;
        TiePointGrid slantRangeTime = product.getTiePointGrid("slant_range_time");
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        double firstLineUTC = absRoot.getAttributeUTC("first_line_time").getMJD();
        double lastLineUTC = absRoot.getAttributeUTC("last_line_time").getMJD();
        double lineTimeInterval = absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        double latMid = sceneRec.getAttributeDouble("scene centre geodetic latitude");
        double lonMid = sceneRec.getAttributeDouble("scene centre geodetic longitude");
        try {
            orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)absRoot);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (!RadarsatProductDirectory.checkStateVectorValidity(orbitStateVectors)) {
            return;
        }
        int numVectors = orbitStateVectors.length;
        int startIdx = 0;
        int endIdx = 0;
        double t1 = Math.min(firstLineUTC, lastLineUTC);
        double t2 = Math.max(firstLineUTC, lastLineUTC);
        for (int i = 0; i < numVectors; ++i) {
            double time = orbitStateVectors[i].time_mjd;
            if (time < t1) {
                startIdx = i;
            }
            if (!(time < t2)) continue;
            endIdx = i;
        }
        while (endIdx - startIdx + 1 < Math.min(5, numVectors)) {
            startIdx = Math.max(startIdx - 1, 0);
            endIdx = Math.min(endIdx + 1, numVectors - 1);
        }
        int numVectorsUsed = endIdx - startIdx + 1;
        double[] timeArray = new double[numVectorsUsed];
        double[] xPosArray = new double[numVectorsUsed];
        double[] yPosArray = new double[numVectorsUsed];
        double[] zPosArray = new double[numVectorsUsed];
        double[] xVelArray = new double[numVectorsUsed];
        double[] yVelArray = new double[numVectorsUsed];
        double[] zVelArray = new double[numVectorsUsed];
        for (int i = startIdx; i <= endIdx; ++i) {
            timeArray[i - startIdx] = orbitStateVectors[i].time_mjd;
            xPosArray[i - startIdx] = orbitStateVectors[i].x_pos;
            yPosArray[i - startIdx] = orbitStateVectors[i].y_pos;
            zPosArray[i - startIdx] = orbitStateVectors[i].z_pos;
            xVelArray[i - startIdx] = orbitStateVectors[i].x_vel;
            yVelArray[i - startIdx] = orbitStateVectors[i].y_vel;
            zVelArray[i - startIdx] = orbitStateVectors[i].z_vel;
        }
        int k = 0;
        for (int r = 0; r < 11; ++r) {
            int y = r == 10 ? sourceImageHeight - 1 : (int)((double)r * subSamplingY);
            double curLineUTC = firstLineUTC + (double)y * lineTimeInterval;
            Orbits.OrbitVector data = RadarsatProductDirectory.getOrbitData(curLineUTC, timeArray, xPosArray, yPosArray, zPosArray, xVelArray, yVelArray, zVelArray);
            for (int c = 0; c < 11; ++c) {
                int x = c == 10 ? sourceImageWidth - 1 : (int)((double)c * subSamplingX);
                double slrgTime = slantRangeTime.getPixelDouble(x, y) / 1.0E9;
                GeoPos geoPos = RadarsatProductDirectory.computeLatLon(latMid, lonMid, slrgTime, data);
                targetLatTiePoints[k] = (float)geoPos.lat;
                targetLonTiePoints[k] = (float)geoPos.lon;
                ++k;
            }
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 11, 11, 0.0, 0.0, subSamplingX, subSamplingY, targetLatTiePoints);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 11, 11, 0.0, 0.0, subSamplingX, subSamplingY, targetLonTiePoints, 180);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    private static boolean checkStateVectorValidity(OrbitStateVector[] orbitStateVectors) {
        if (orbitStateVectors == null) {
            return false;
        }
        if (orbitStateVectors.length <= 1) {
            return false;
        }
        for (int i = 1; i < orbitStateVectors.length; ++i) {
            if (orbitStateVectors[i].time_mjd != orbitStateVectors[0].time_mjd) continue;
            return false;
        }
        return true;
    }

    private static void setLatLonMetadata(Product product, MetadataElement absRoot) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return;
        }
        GeoPos geoPosFirstNear = product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, 0.0), null);
        GeoPos geoPosFirstFar = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)(product.getSceneRasterWidth() - 1), 0.0), null);
        GeoPos geoPosLastNear = product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, (double)(product.getSceneRasterHeight() - 1)), null);
        GeoPos geoPosLastFar = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)(product.getSceneRasterWidth() - 1), (double)(product.getSceneRasterHeight() - 1)), null);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)geoPosFirstNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)geoPosFirstNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)geoPosFirstFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)geoPosFirstFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)geoPosLastNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)geoPosLastNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)geoPosLastFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)geoPosLastFar.getLon());
    }

    private static GeoPos computeLatLon(double latMid, double lonMid, double slrgTime, Orbits.OrbitVector data) {
        double[] xyz = new double[3];
        GeoPos geoPos = new GeoPos(latMid, lonMid);
        GeoUtils.geo2xyz((GeoPos)geoPos, (double[])xyz);
        GeoUtils.computeAccurateXYZ((Orbits.OrbitVector)data, (double[])xyz, (double)slrgTime);
        GeoUtils.xyz2geo((double[])xyz, (GeoPos)geoPos);
        return geoPos;
    }

    private static Orbits.OrbitVector getOrbitData(double utc, double[] timeArray, double[] xPosArray, double[] yPosArray, double[] zPosArray, double[] xVelArray, double[] yVelArray, double[] zVelArray) {
        return new Orbits.OrbitVector(utc, Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])xPosArray, (double)utc), Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])yPosArray, (double)utc), Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])zPosArray, (double)utc), Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])xVelArray, (double)utc), Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])yVelArray, (double)utc), Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])zVelArray, (double)utc));
    }
}

