/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.radarsat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CEOSLeaderFile;
import org.jdom2.Document;

class RadarsatLeaderFile
extends CEOSLeaderFile {
    private static final String mission = "radarsat";
    private static final String leader_recordDefinitionFile = "leader_file.xml";
    private static final Document leaderXML = BinaryDBReader.loadDefinitionFile("radarsat", "leader_file.xml");
    private static final Document sceneXML = BinaryDBReader.loadDefinitionFile("radarsat", "scene_record.xml");
    private static final Document mapProjXML = BinaryDBReader.loadDefinitionFile("radarsat", "map_proj_record.xml");
    private static final Document platformXML = BinaryDBReader.loadDefinitionFile("radarsat", "platform_position_record.xml");
    private static final Document attitudeXML = BinaryDBReader.loadDefinitionFile("radarsat", "attitude_record.xml");
    private static final Document radiometricXML = BinaryDBReader.loadDefinitionFile("radarsat", "radiometric_record.xml");
    private static final Document dataQualityXML = BinaryDBReader.loadDefinitionFile("radarsat", "data_quality_summary_record.xml");
    private static final Document facilityXML = BinaryDBReader.loadDefinitionFile("radarsat", "facility_record.xml");
    private static final Document histogramXML = BinaryDBReader.loadDefinitionFile("radarsat", "data_histogram_record.xml");
    private static final Document detailProcXML = BinaryDBReader.loadDefinitionFile("radarsat", "detailed_processing_record.xml");
    private static final Document radiometricCompXML = BinaryDBReader.loadDefinitionFile("radarsat", "radiometric_compensation_record.xml");

    public RadarsatLeaderFile(ImageInputStream stream) throws IOException {
        int i;
        BinaryFileReader reader = new BinaryFileReader(stream);
        Document leaderXML = BinaryDBReader.loadDefinitionFile(mission, leader_recordDefinitionFile);
        this.leaderFDR = new BinaryRecord(reader, -1L, leaderXML, leader_recordDefinitionFile);
        reader.seek(this.leaderFDR.getRecordEndPosition());
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of data set summary records"); ++i) {
            this.sceneHeaderRecord = new BinaryRecord(reader, -1L, sceneXML, "scene_record.xml");
            reader.seek(this.sceneHeaderRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of map projection data records"); ++i) {
            this.mapProjRecord = new BinaryRecord(reader, -1L, mapProjXML, "map_proj_record.xml");
            reader.seek(this.mapProjRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of platform pos. data records"); ++i) {
            this.platformPositionRecord = new BinaryRecord(reader, -1L, platformXML, "platform_position_record.xml");
            reader.seek(this.platformPositionRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of attitude data records"); ++i) {
            this.attitudeRecord = new BinaryRecord(reader, -1L, attitudeXML, "attitude_record.xml");
            reader.seek(this.attitudeRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of radiometric data records"); ++i) {
            this.radiometricRecord = new BinaryRecord(reader, -1L, radiometricXML, "radiometric_record.xml");
            reader.seek(this.radiometricRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of rad. compensation records"); ++i) {
            this.radiometricCompRecord = new BinaryRecord(reader, -1L, radiometricCompXML, "radiometric_compensation_record.xml");
            reader.seek(this.radiometricCompRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of data quality summary records"); ++i) {
            this.dataQualityRecord = new BinaryRecord(reader, -1L, dataQualityXML, "data_quality_summary_record.xml");
            reader.seek(this.dataQualityRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of data histograms records"); ++i) {
            this.histogramRecord = new BinaryRecord(reader, -1L, histogramXML, "data_histogram_record.xml");
            reader.seek(this.histogramRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of det. processing records"); ++i) {
            this.detailedProcessingRecord = new BinaryRecord(reader, -1L, detailProcXML, "detailed_processing_record.xml");
            reader.seek(this.detailedProcessingRecord.getRecordEndPosition());
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of facility data records"); ++i) {
            this.facilityRecord = new BinaryRecord(reader, -1L, facilityXML, "facility_record.xml");
            reader.seek(this.facilityRecord.getRecordEndPosition());
        }
        reader.close();
    }
}

