/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.jers;

import java.io.File;
import org.esa.s1tbx.io.ceos.CEOSProductReaderPlugIn;
import org.esa.s1tbx.io.ceos.jers.JERSConstants;
import org.esa.s1tbx.io.ceos.jers.JERSProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;

public class JERSProductReaderPlugIn
extends CEOSProductReaderPlugIn {
    public JERSProductReaderPlugIn() {
        this.constants = new JERSConstants();
    }

    @Override
    public ProductReader createReaderInstance() {
        return new JERSProductReader(this);
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String name = file.getName().toUpperCase();
        if (name.endsWith(".ZIP") && name.startsWith("J1_")) {
            return DecodeQualification.INTENDED;
        }
        for (String prefix : this.constants.getVolumeFilePrefix()) {
            if (!name.startsWith(prefix)) continue;
            JERSProductReader reader = new JERSProductReader(this);
            return reader.checkProductQualification(file);
        }
        return DecodeQualification.UNABLE;
    }
}

