/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.jers;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.jdom2.Document;

class JERSImageFile
extends CEOSImageFile {
    private static final String mission = "jers";
    private static final String image_DefinitionFile = "image_file.xml";
    private static final String image_recordDefinition = "image_record.xml";
    private static final Document imgDefXML = BinaryDBReader.loadDefinitionFile("jers", "image_file.xml");
    private static final Document imgRecordXML = BinaryDBReader.loadDefinitionFile("jers", "image_record.xml");

    public JERSImageFile(ImageInputStream imageStream) throws IOException, IllegalBinaryFormatException {
        this.binaryReader = new BinaryFileReader(imageStream);
        this.imageFDR = new BinaryRecord(this.binaryReader, -1L, imgDefXML, image_DefinitionFile);
        this.binaryReader.seek(this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()));
        int numLines = this.imageFDR.getAttributeInt("Number of lines per data set");
        if (numLines == 0) {
            throw new IllegalBinaryFormatException("not an image file", 0L);
        }
        this.imageRecords = new BinaryRecord[numLines];
        this.imageRecords[0] = this.createNewImageRecord(0);
        this._imageRecordLength = this.imageRecords[0].getRecordLength();
        this.startPosImageRecords = this.imageRecords[0].getStartPos();
        this.imageHeaderLength = this.imageFDR.getAttributeInt("Number of bytes of prefix data per record");
    }

    @Override
    protected BinaryRecord createNewImageRecord(int line) throws IOException {
        long pos = this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()) + (long)line * this._imageRecordLength;
        return new BinaryRecord(this.binaryReader, pos, imgRecordXML, image_recordDefinition);
    }
}

