/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.ers;

import com.bc.ceres.core.VirtualDir;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.esa.s1tbx.io.ceos.CEOSLeaderFile;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.ers.ERSConstants;
import org.esa.s1tbx.io.ceos.ers.ERSImageFile;
import org.esa.s1tbx.io.ceos.ers.ERSLeaderFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

class ERSProductDirectory
extends CEOSProductDirectory {
    private ERSImageFile[] imageFiles = null;
    private ERSLeaderFile leaderFile = null;
    private final transient Map<String, ERSImageFile> bandImageFileMap = new HashMap<String, ERSImageFile>(1);

    public ERSProductDirectory(VirtualDir dir) {
        Guardian.assertNotNull((String)"dir", (Object)dir);
        this.constants = new ERSConstants();
        this.productDir = dir;
    }

    @Override
    protected void readProductDirectory() throws IOException {
        this.readVolumeDirectoryFileStream();
        this.leaderFile = new ERSLeaderFile(this.getCEOSFile((String[])this.constants.getLeaderFilePrefix())[0].imgInputStream);
        CEOSProductDirectory.CeosFile[] ceosFiles = this.getCEOSFile(this.constants.getImageFilePrefix());
        ArrayList<ERSImageFile> imgArray = new ArrayList<ERSImageFile>(ceosFiles.length);
        for (CEOSProductDirectory.CeosFile imageFile : ceosFiles) {
            try {
                ERSImageFile imgFile = new ERSImageFile(imageFile.imgInputStream);
                imgArray.add(imgFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.imageFiles = imgArray.toArray(new ERSImageFile[imgArray.size()]);
        this.sceneWidth = this.imageFiles[0].getRasterWidth();
        this.sceneHeight = this.imageFiles[0].getRasterHeight();
        ERSProductDirectory.assertSameWidthAndHeightForAllImages(this.imageFiles, this.sceneWidth, this.sceneHeight);
    }

    public boolean isERS() throws IOException {
        boolean isERS;
        String volumeId = this.getVolumeId().toUpperCase();
        String logicalVolumeId = this.getLogicalVolumeId().toUpperCase();
        boolean bl = isERS = volumeId.contains("ERS") && !volumeId.contains("JERS") || logicalVolumeId.contains("ERS") && !logicalVolumeId.contains("JERS");
        if (isERS) {
            return true;
        }
        if (this.productType == null) {
            this.readVolumeDirectoryFileStream();
        }
        return this.productType.contains("ERS") && !this.productType.contains("JERS");
    }

    private boolean isERS1() {
        return !this.productType.contains("RAW") && (this.productType.contains("ERS1") || this.productType.contains("ERS-1") || this.productType.contains("ERS_1"));
    }

    private boolean isERS2() {
        return !this.productType.contains("RAW") && (this.productType.contains("ERS2") || this.productType.contains("ERS-2") || this.productType.contains("ERS_2"));
    }

    String getMission() {
        if (this.isERS1()) {
            return "ERS1";
        }
        if (this.isERS2()) {
            return "ERS2";
        }
        return "";
    }

    @Override
    public Product createProduct() throws IOException {
        Product product = new Product(this.getProductName(), this.productType, this.sceneWidth, this.sceneHeight);
        if (this.imageFiles.length > 1) {
            int index = 1;
            for (ERSImageFile imageFile : this.imageFiles) {
                if (this.isProductSLC) {
                    Band bandI = this.createBand(product, "i_" + index, "real", imageFile);
                    Band bandQ = this.createBand(product, "q_" + index, "imaginary", imageFile);
                    ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)("_" + index));
                } else {
                    Band band = this.createBand(product, "Amplitude_" + index, "amplitude", imageFile);
                    SARReader.createVirtualIntensityBand(product, band, "_" + index);
                }
                ++index;
            }
        } else {
            ERSImageFile imageFile = this.imageFiles[0];
            if (this.isProductSLC) {
                Band bandI = this.createBand(product, "i", "real", imageFile);
                Band bandQ = this.createBand(product, "q", "imaginary", imageFile);
                ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)"");
            } else {
                Band band = this.createBand(product, "Amplitude", "amplitude", imageFile);
                SARReader.createVirtualIntensityBand(product, band, "");
            }
        }
        product.setStartTime(ERSProductDirectory.getUTCScanStartTime(this.leaderFile.getSceneRecord(), null));
        product.setEndTime(ERSProductDirectory.getUTCScanStopTime(this.leaderFile.getSceneRecord(), null));
        product.setDescription(this.getProductDescription());
        ReaderUtils.addGeoCoding((Product)product, (float[])CEOSLeaderFile.getLatCorners(this.leaderFile.getMapProjRecord()), (float[])CEOSLeaderFile.getLonCorners(this.leaderFile.getMapProjRecord()));
        ERSProductDirectory.addTiePointGrids(product, this.leaderFile.getFacilityRecord(), this.leaderFile.getSceneRecord());
        this.addMetaData(product);
        return product;
    }

    @Override
    public CEOSImageFile getImageFile(Band band) {
        return this.bandImageFileMap.get(band.getName());
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.imageFiles.length; ++i) {
            this.imageFiles[i].close();
            this.imageFiles[i] = null;
        }
        this.imageFiles = null;
    }

    private Band createBand(Product product, String name, String unit, ERSImageFile imageFile) {
        Band band = this.createBand(product, name, unit, imageFile.getBitsPerSample());
        this.bandImageFileMap.put(name, imageFile);
        return band;
    }

    private void addMetaData(Product product) throws IOException {
        MetadataElement root = AbstractMetadata.addOriginalProductMetadata((MetadataElement)product.getMetadataRoot());
        MetadataElement leadMetadata = new MetadataElement("Leader");
        this.leaderFile.addLeaderMetadata(leadMetadata);
        root.addElement(leadMetadata);
        MetadataElement volMetadata = new MetadataElement("Volume");
        this.volumeDirectoryFile.assignMetadataTo(volMetadata);
        root.addElement(volMetadata);
        int c = 1;
        for (ERSImageFile imageFile : this.imageFiles) {
            imageFile.assignMetadataTo(root, c++);
        }
        ERSProductDirectory.addSummaryMetadata(this.findFile("summary.txt"), "Summary Information", root);
        this.addAbstractedMetadataHeader(product, product.getMetadataRoot());
    }

    private void addAbstractedMetadataHeader(Product product, MetadataElement root) {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        BinaryRecord sceneRec = this.leaderFile.getSceneRecord();
        BinaryRecord mapProjRec = this.leaderFile.getMapProjRecord();
        BinaryRecord facilityRec = this.leaderFile.getFacilityRecord();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.getProductName());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.getProductType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)sceneRec.getAttributeString("Product type descriptor"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)this.getMission());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)"Stripmap");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)"right");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)ERSProductDirectory.getProcTime(this.volumeDirectoryFile.getVolumeDescriptorRecord()));
        ProductData.UTC startTime = ERSProductDirectory.getUTCScanStartTime(sceneRec, null);
        ProductData.UTC endTime = ERSProductDirectory.getUTCScanStopTime(sceneRec, null);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)endTime);
        if (mapProjRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)ERSProductDirectory.getPass(mapProjRec, sceneRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-pixel distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-line distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)ERSProductDirectory.isGroundRange(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"map_projection", (String)this.getMapProjection(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"geo_ref_system", (String)mapProjRec.getAttributeString("Name of reference ellipsoid"));
        } else if (sceneRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)sceneRec.getAttributeDouble("Pixel spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)sceneRec.getAttributeDouble("Line spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)ERSProductDirectory.getPass(mapProjRec, sceneRec));
        }
        String psID = "VMP";
        if (sceneRec != null) {
            psID = sceneRec.getAttributeString("Processing system identifier").trim();
            if (psID.contains("PGS")) {
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)"PGS");
            } else {
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)"VMP");
            }
            int absOrbit = Integer.parseInt(sceneRec.getAttributeString("Orbit number").trim());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_cycle", (int)this.getCycle(absOrbit));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"REL_ORBIT", (int)this.getRelOrbit(absOrbit));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)absOrbit);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)SARReader.findPolarizationInBandName(sceneRec.getAttributeString("Sensor ID and mode of operation for this channel")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"algorithm", (String)sceneRec.getAttributeString("Processing algorithm identifier"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in azimuth"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in range"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (Double)sceneRec.getAttributeDouble("Pulse Repetition Frequency"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)(sceneRec.getAttributeDouble("Radar frequency") * 1000.0));
            double slantRangeTimeToFirstPixel = sceneRec.getAttributeDouble("Zero-doppler range time of first range pixel");
            double slantRangeTimeToLastPixel = sceneRec.getAttributeDouble("Zero-doppler range time of last range pixel");
            double slantRangeTime = Math.min(slantRangeTimeToFirstPixel, slantRangeTimeToLastPixel) * 0.001;
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(slantRangeTime * 1.49896229E8));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (Double)sceneRec.getAttributeDouble("Range sampling rate"));
            double rangeBW = sceneRec.getAttributeDouble("Total processor bandwidth in range");
            double azimuthBW = sceneRec.getAttributeDouble("Total processor bandwidth in azimuth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)rangeBW);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)this.getSampleType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)endTime, (int)this.sceneHeight));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)product));
        if (facilityRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)AbstractMetadata.parseUTC((String)facilityRec.getAttributeString("Time of input state vector used to processed the image")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)facilityRec.getAttributeInt("Antenna pattern correction flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)facilityRec.getAttributeInt("Range spreading loss compensation flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"replica_power_corr_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"abs_calibration_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"calibration_factor", (Double)facilityRec.getAttributeDouble("Absolute calibration constant K"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
        }
        ERSProductDirectory.addOrbitStateVectors(absRoot, this.leaderFile.getPlatformPositionRecord());
        ERSProductDirectory.addSRGRCoefficients(absRoot, facilityRec);
        if (!psID.contains("PGS")) {
            double Fr = sceneRec.getAttributeDouble("Range sampling rate") * 1000000.0;
            double R0 = absRoot.getAttributeDouble("slant_range_to_first_pixel");
            MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
            MetadataElement srgrListElem = srgrCoefficientsElem.getElement("srgr_coef_list");
            MetadataElement coefElem = srgrListElem.getElementAt(0);
            double c0 = coefElem.getAttributeDouble("srgr_coef");
            c0 = c0 / Fr * 1.49896229E8 + R0;
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)c0);
            coefElem = srgrListElem.getElementAt(1);
            double c1 = coefElem.getAttributeDouble("srgr_coef");
            c1 = c1 / Fr * 1.49896229E8;
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)c1);
            coefElem = srgrListElem.getElementAt(2);
            double c2 = coefElem.getAttributeDouble("srgr_coef");
            c2 = c2 / Fr * 1.49896229E8;
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)c2);
            coefElem = srgrListElem.getElementAt(3);
            double c3 = coefElem.getAttributeDouble("srgr_coef");
            c3 = c3 / Fr * 1.49896229E8;
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)c3);
        }
        ERSProductDirectory.addDopplerCentroidCoefficients(absRoot, sceneRec);
    }

    private String getMapProjection(BinaryRecord mapProjRec) {
        if (this.productType.contains("IMG") || this.productType.contains("GEC")) {
            return mapProjRec.getAttributeString("Map projection descriptor");
        }
        return " ";
    }

    private int getCycle(int absOrbit) {
        if (this.isERS1()) {
            if (absOrbit < 12754) {
                int orbitsPerCycle = 501;
                return (absOrbit + 37930) / 501;
            }
            if (absOrbit < 14302) {
                int orbitsPerCycle = 43;
                return (absOrbit - 8342) / 43;
            }
            if (absOrbit < 16747) {
                int orbitsPerCycle = 2411;
                return (absOrbit - 12511) / 2411 + 139;
            }
            if (absOrbit < 19248) {
                int orbitsPerCycle = 2411;
                return (absOrbit - 14391) / 2411 + 141;
            }
            int orbitsPerCycle = 501;
            return (absOrbit - 19027) / 501 + 144;
        }
        int orbitsPerCycle = 501;
        return (absOrbit + 145) / 501;
    }

    private int getRelOrbit(int absOrbit) {
        if (this.isERS1()) {
            if (absOrbit < 12754) {
                int orbitsPerCycle = 501;
                return absOrbit + 37931 - this.getCycle(absOrbit) * 501;
            }
            if (absOrbit < 14302) {
                int orbitsPerCycle = 43;
                return absOrbit - 8341 - this.getCycle(absOrbit) * 43;
            }
            if (absOrbit < 16747) {
                int orbitsPerCycle = 2411;
                return absOrbit - 12510 - (this.getCycle(absOrbit) - 139) * 2411;
            }
            if (absOrbit < 19248) {
                int orbitsPerCycle = 2411;
                return absOrbit - 14390 - (this.getCycle(absOrbit) - 141) * 2411;
            }
            int orbitsPerCycle = 501;
            return absOrbit - 19026 - (this.getCycle(absOrbit) - 144) * 501;
        }
        int orbitsPerCycle = 501;
        return absOrbit + 146 - this.getCycle(absOrbit) * 501;
    }

    private String getProductName() {
        return this.volumeDirectoryFile.getProductName();
    }

    private String getProductDescription() {
        return "ERS product " + this.leaderFile.getProductLevel();
    }
}

