/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos2;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.CEOSProductReader;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarImageFile;
import org.esa.s1tbx.io.ceos.alos2.Alos2ProductDirectory;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;

public class Alos2ProductReader
extends CEOSProductReader {
    public Alos2ProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    @Override
    protected CEOSProductDirectory createProductDirectory(VirtualDir productDir) {
        return new Alos2ProductDirectory(productDir);
    }

    DecodeQualification checkProductQualification(File file) {
        try {
            this.dataDir = this.createProductDirectory(this.createProductDir(file));
            Alos2ProductDirectory dataDir = (Alos2ProductDirectory)this.dataDir;
            if (dataDir.isALOS2()) {
                return DecodeQualification.INTENDED;
            }
            return DecodeQualification.UNABLE;
        }
        catch (Exception e) {
            return DecodeQualification.UNABLE;
        }
    }

    @Override
    protected void addQuicklooks(Product product, VirtualDir productDir) throws IOException {
        String[] files = productDir.list("");
        if (files != null) {
            for (String file : files) {
                String name = file.toLowerCase();
                if (!name.startsWith("brs") || !name.endsWith(".jpg")) continue;
                this.addQuicklook(product, "Quicklook", productDir.getFile(file));
                return;
            }
        }
    }

    public void readTiePointGridRasterData(TiePointGrid tpg, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Alos2ProductDirectory alosDataDir = (Alos2ProductDirectory)this.dataDir;
        alosDataDir.readTiePointGridRasterData(tpg, destBuffer, pm);
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            Alos2ProductDirectory dataDir = (Alos2ProductDirectory)this.dataDir;
            AlosPalsarImageFile imageFile = (AlosPalsarImageFile)dataDir.getImageFile(destBand);
            if (dataDir.isSLC()) {
                boolean oneOf2;
                boolean bl = oneOf2 = destBand.getUnit().equals("real") || !destBand.getName().startsWith("q");
                if (dataDir.getProductLevel() == 0) {
                    imageFile.readBandRasterDataSLCByte(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, pm);
                } else {
                    imageFile.readBandRasterDataSLCFloat(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, pm);
                }
            } else {
                imageFile.readBandRasterDataShort(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, pm);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

