/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import java.io.IOException;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CeosHelper;
import org.esa.s1tbx.io.ceos.FilePointerRecord;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.util.StringUtils;
import org.jdom2.Document;

public class CEOSVolumeDirectoryFile {
    private BinaryRecord volumeDescriptorRecord;
    private FilePointerRecord[] filePointerRecords;
    private BinaryRecord textRecord;
    private static final String volume_desc_recordDefinitionFile = "volume_descriptor.xml";
    private static final String filePointerDefinitionFile = "file_pointer_record.xml";
    private static final String text_recordDefinitionFile = "text_record.xml";
    private static Document volDescXML;
    private static Document filePointerXML;
    private static Document textRecXML;

    public CEOSVolumeDirectoryFile(BinaryFileReader binaryReader, String mission) throws IOException {
        if (volDescXML == null) {
            volDescXML = BinaryDBReader.loadDefinitionFile(mission, volume_desc_recordDefinitionFile);
        }
        this.volumeDescriptorRecord = new BinaryRecord(binaryReader, -1L, volDescXML, volume_desc_recordDefinitionFile);
    }

    public void readFilePointersAndTextRecords(BinaryFileReader binaryReader, String mission) throws IOException {
        try {
            if (filePointerXML == null) {
                filePointerXML = BinaryDBReader.loadDefinitionFile(mission, filePointerDefinitionFile);
            }
            this.filePointerRecords = CEOSVolumeDirectoryFile.readFilePointers(this.volumeDescriptorRecord, filePointerXML, filePointerDefinitionFile);
        }
        catch (Exception e) {
            System.out.println("Error reading file pointer record: " + e.getMessage());
        }
        try {
            if (textRecXML == null) {
                textRecXML = BinaryDBReader.loadDefinitionFile(mission, text_recordDefinitionFile);
            }
            this.textRecord = new BinaryRecord(binaryReader, -1L, textRecXML, text_recordDefinitionFile);
        }
        catch (Exception e) {
            System.out.println("Error reading text record: " + e.getMessage());
        }
    }

    public BinaryRecord getTextRecord() {
        return this.textRecord;
    }

    public BinaryRecord getVolumeDescriptorRecord() {
        return this.volumeDescriptorRecord;
    }

    public String getProductName() {
        return CEOSVolumeDirectoryFile.getProductName(this.textRecord);
    }

    public String getProductType() {
        return CEOSVolumeDirectoryFile.getProductType(this.textRecord);
    }

    public void assignMetadataTo(MetadataElement rootElem) {
        CeosHelper.addMetadata(rootElem, this.volumeDescriptorRecord, "Volume Descriptor");
        CeosHelper.addMetadata(rootElem, this.textRecord, "Text Record");
        int i = 1;
        for (FilePointerRecord fp : this.filePointerRecords) {
            CeosHelper.addMetadata(rootElem, fp, "File Pointer Record " + i++);
        }
    }

    public static FilePointerRecord[] readFilePointers(BinaryRecord vdr, Document filePointerXML, String recName) throws IOException {
        int numFilePointers = vdr.getAttributeInt("Number of filepointer records");
        BinaryFileReader reader = vdr.getReader();
        reader.seek(vdr.getRecordLength());
        FilePointerRecord[] filePointers = new FilePointerRecord[numFilePointers];
        for (int i = 0; i < numFilePointers; ++i) {
            filePointers[i] = new FilePointerRecord(reader, filePointerXML, recName);
        }
        return filePointers;
    }

    public static String getProductName(BinaryRecord textRecord) {
        if (textRecord == null) {
            return "unknown";
        }
        String name = textRecord.getAttributeString("Product type specifier").trim().replace("PRODUCT:", "") + '-' + textRecord.getAttributeString("Scene identification").trim();
        return StringUtils.createValidName((String)name.trim(), (char[])new char[]{'_', '-'}, (char)'_');
    }

    public static String getProductType(BinaryRecord textRecord) {
        if (textRecord == null) {
            return "unknown";
        }
        String type = textRecord.getAttributeString("Product type specifier").trim();
        type = type.replace("PRODUCT:", "");
        type = type.replace("JERS-1", "JERS1");
        type = type.replace("JERS_1", "JERS1");
        type = type.replace("ERS-1", "ERS1");
        type = type.replace("ERS_1", "ERS1");
        type = type.replace("ERS-2", "ERS2");
        type = type.replace("ERS_2", "ERS2");
        return type.trim();
    }
}

