/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.binary;

import java.io.IOException;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.snap.core.datamodel.MetadataElement;
import org.jdom2.Document;

public class BinaryRecord {
    private final long startPos;
    private final BinaryFileReader reader;
    private final BinaryDBReader db;
    private final Integer recordLength;

    public BinaryRecord(BinaryFileReader reader, long sPos, Document recordDefinitionXML, String recName) throws IOException {
        this.reader = reader;
        if (sPos != -1L) {
            this.startPos = sPos;
            reader.seek(this.startPos);
        } else {
            this.startPos = reader.getCurrentPos();
        }
        this.db = new BinaryDBReader(recordDefinitionXML, recName, this.startPos);
        this.db.readRecord(reader);
        this.recordLength = this.getAttributeInt("Record Length");
    }

    public final String getAttributeString(String name) {
        return this.db.getAttributeString(name);
    }

    public final Integer getAttributeInt(String name) {
        return this.db.getAttributeInt(name);
    }

    public final Double getAttributeDouble(String name) {
        return this.db.getAttributeDouble(name);
    }

    public final int getRecordLength() {
        return this.recordLength;
    }

    public final long getStartPos() {
        return this.startPos;
    }

    public BinaryFileReader getReader() {
        return this.reader;
    }

    public final BinaryDBReader getBinaryDatabase() {
        return this.db;
    }

    public long getRecordEndPosition() {
        if (this.recordLength != null) {
            return this.startPos + (long)this.recordLength.intValue();
        }
        return this.startPos;
    }

    public long getAbsolutPosition(long relativePosition) {
        return this.startPos + relativePosition;
    }

    public void assignMetadataTo(MetadataElement elem) {
        if (this.db != null) {
            this.db.assignMetadataTo(elem);
        }
    }

    protected static MetadataElement createMetadataElement(String name, String suffix) {
        MetadataElement elem = suffix != null && suffix.trim().length() > 0 ? new MetadataElement(name + ' ' + suffix.trim()) : new MetadataElement(name);
        return elem;
    }
}

