/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public final class BinaryDBReader {
    private static final int Skip = 0;
    private static final int An = 1;
    private static final int In = 2;
    private static final int B1 = 3;
    private static final int B4 = 4;
    private static final int Fn = 5;
    private static final int B2 = 6;
    private static final int En = 7;
    private static final int B8 = 8;
    private static final int Debug = -1;
    private final Map<String, Object> metaMap = new HashMap<String, Object>(100);
    private final Document xmlDoc;
    private final String recName;
    private final long startPos;
    private static final boolean DEBUG_MODE = false;

    public BinaryDBReader(Document xmlDoc, String recName, long startPos) {
        this.xmlDoc = xmlDoc;
        this.recName = recName;
        this.startPos = startPos;
    }

    public void assignMetadataTo(MetadataElement elem) {
        Set<String> keys = this.metaMap.keySet();
        for (String key : keys) {
            MetadataAttribute attrib;
            Object value = this.metaMap.get(key);
            if (value == null || key.isEmpty()) continue;
            if (value instanceof Integer) {
                attrib = new MetadataAttribute(key, 12, 1);
                attrib.getData().setElemInt(((Integer)value).intValue());
                elem.addAttribute(attrib);
                continue;
            }
            if (value instanceof Double) {
                attrib = new MetadataAttribute(key, 31, 1);
                attrib.getData().setElemDouble(((Double)value).doubleValue());
                elem.addAttribute(attrib);
                continue;
            }
            elem.setAttributeString(key, String.valueOf(value));
        }
    }

    public void readRecord(BinaryFileReader reader) {
        Element root = this.xmlDoc.getRootElement();
        List children = root.getContent();
        for (Object aChild : children) {
            if (!(aChild instanceof Element)) continue;
            Element child = (Element)aChild;
            if (child.getName().equals("struct")) {
                int loop;
                Attribute loopAttrib = child.getAttribute("loop");
                if (loopAttrib != null) {
                    String loopName = loopAttrib.getValue();
                    loop = this.getAttributeInt(loopName);
                } else {
                    Attribute nloopAttrib = child.getAttribute("nloop");
                    loop = Integer.parseInt(nloopAttrib.getValue());
                }
                List structChildren = child.getChildren();
                for (int l = 1; l <= loop; ++l) {
                    String suffix = " " + l;
                    for (Object aStructChild : structChildren) {
                        if (!(aStructChild instanceof Element)) continue;
                        BinaryDBReader.DecodeElement(reader, this.metaMap, (Element)aStructChild, suffix);
                    }
                }
            }
            BinaryDBReader.DecodeElement(reader, this.metaMap, child, null);
        }
    }

    private static void DecodeElement(BinaryFileReader reader, Map metaMap, Element child, String suffix) {
        String name = "";
        try {
            Attribute nameAttrib = child.getAttribute("name");
            Attribute typeAttrib = child.getAttribute("type");
            Attribute numAttrib = child.getAttribute("num");
            if (nameAttrib != null && typeAttrib != null && numAttrib != null) {
                name = nameAttrib.getValue();
                if (suffix != null) {
                    name = name + suffix;
                }
                int type = Integer.parseInt(typeAttrib.getValue());
                int num = Integer.parseInt(numAttrib.getValue());
                switch (type) {
                    case 0: {
                        reader.skipBytes(num);
                        break;
                    }
                    case 1: {
                        metaMap.put(name, reader.readAn(num));
                        break;
                    }
                    case 2: {
                        metaMap.put(name, (int)reader.readIn(num));
                        break;
                    }
                    case 3: {
                        metaMap.put(name, reader.readB1());
                        break;
                    }
                    case 6: {
                        metaMap.put(name, reader.readB2());
                        break;
                    }
                    case 4: {
                        metaMap.put(name, reader.readB4());
                        break;
                    }
                    case 8: {
                        metaMap.put(name, reader.readB8());
                        break;
                    }
                    case 5: {
                        metaMap.put(name, reader.readFn(num));
                        break;
                    }
                    case 7: {
                        metaMap.put(name, reader.readEn(num));
                        break;
                    }
                    case -1: {
                        System.out.print(" = ");
                        for (int i = 0; i < num; ++i) {
                            String tmp = reader.readAn(1);
                            if (tmp.isEmpty() || tmp.equals(" ")) continue;
                            System.out.print(tmp);
                        }
                        System.out.println();
                        break;
                    }
                    default: {
                        throw new IllegalBinaryFormatException("Unknown type " + type, reader.getCurrentPos());
                    }
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                SystemUtils.LOG.severe(' ' + e.toString() + ':' + e.getCause().toString() + " for " + name);
            }
            SystemUtils.LOG.severe(' ' + e.toString() + ':' + " for " + name);
        }
    }

    private void DecodeElementDebug(BinaryFileReader reader, Map metaMap, Element child, String suffix) {
        String name = "";
        try {
            Attribute nameAttrib = child.getAttribute("name");
            Attribute typeAttrib = child.getAttribute("type");
            Attribute numAttrib = child.getAttribute("num");
            if (nameAttrib != null && typeAttrib != null && numAttrib != null) {
                name = nameAttrib.getValue();
                if (suffix != null) {
                    name = name + suffix;
                }
                int type = Integer.parseInt(typeAttrib.getValue());
                int num = Integer.parseInt(numAttrib.getValue());
                System.out.print(" " + reader.getCurrentPos() + ' ' + (reader.getCurrentPos() - this.startPos + 1L) + ' ' + name + ' ' + type + ' ' + num);
                switch (type) {
                    case 0: {
                        reader.skipBytes(num);
                        break;
                    }
                    case 1: {
                        String tmp = reader.readAn(num);
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 2: {
                        int tmp = (int)reader.readIn(num);
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 3: {
                        int tmp = reader.readB1();
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 6: {
                        short tmp = reader.readB2();
                        System.out.print(" = " + tmp);
                        metaMap.put(name, Integer.valueOf(tmp));
                        break;
                    }
                    case 4: {
                        int tmp = reader.readB4();
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 8: {
                        long tmp = reader.readB8();
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 5: {
                        double tmp = reader.readFn(num);
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case 7: {
                        double tmp = reader.readEn(num);
                        System.out.print(" = " + tmp);
                        metaMap.put(name, tmp);
                        break;
                    }
                    case -1: {
                        System.out.print(" = ");
                        for (int i = 0; i < num; ++i) {
                            String tmp = reader.readAn(1);
                            if (tmp.isEmpty() || tmp.equals(" ")) continue;
                            System.out.print(tmp);
                        }
                        System.out.println();
                        break;
                    }
                    default: {
                        throw new IllegalBinaryFormatException("Unknown type " + type, reader.getCurrentPos());
                    }
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                SystemUtils.LOG.severe(' ' + e.toString() + ':' + e.getCause().toString() + " for " + name);
            }
            SystemUtils.LOG.severe(' ' + e.toString() + ':' + " for " + name);
        }
    }

    private Object get(String name) {
        Object obj = this.metaMap.get(name);
        if (obj == null) {
            // empty if block
        }
        return obj;
    }

    public final String getAttributeString(String name) {
        return (String)this.get(name);
    }

    public final Integer getAttributeInt(String name) {
        Integer i = (Integer)this.get(name);
        return i == null ? 0 : i;
    }

    public final Double getAttributeDouble(String name) {
        Double d = (Double)this.get(name);
        return d == null ? 0.0 : d;
    }

    public final void set(String name, Object o) {
        this.metaMap.put(name, o);
    }

    public static Document loadDefinitionFile(String mission, String fileName) {
        try {
            InputStream defStream = BinaryDBReader.getResStream(mission, fileName);
            return XMLSupport.LoadXML((InputStream)defStream);
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Unable to open " + fileName + ": " + e.getMessage());
            return null;
        }
    }

    private static InputStream getResStream(String mission, String fileName) throws IOException {
        String base = "org/esa/s1tbx/io/ceos_db/";
        String path = "org/esa/s1tbx/io/ceos_db/" + mission.toLowerCase() + "/" + fileName;
        return ResourceUtils.getResourceAsStream((String)path, BinaryDBReader.class);
    }
}

