/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.binary;

public class ArrayCopy {
    public static void copyLine(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(short[] srcLine, short[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(char[] srcLine, char[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(char[] srcLine, short[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = (short)srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(int[] srcLine, int[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(long[] srcLine, long[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(float[] srcLine, float[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine(double[] srcLine, double[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine1Of2(char[] srcLine, char[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine1Of2(short[] srcLine, short[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine1Of2(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine1Of2(int[] srcLine, int[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine1Of2(float[] srcLine, float[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = (int)srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine2Of2(char[] srcLine, char[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine2Of2(short[] srcLine, short[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine2Of2(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine2Of2(int[] srcLine, int[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static void copyLine2Of2(float[] srcLine, float[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = (int)srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public static float convert16BitsTo32BitFloat(char halfFloat) {
        int s = halfFloat >> 15 & 1;
        int e = halfFloat >> 10 & 0x1F;
        int f = halfFloat & 0x3FF;
        if (e == 0) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31);
            }
            while ((f & 0x400) == 0) {
                f <<= 1;
                --e;
            }
            ++e;
            f &= 0xFFFFFBFF;
        } else if (e == 31) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31 | 0x7F800000);
            }
            return Float.intBitsToFloat(s << 31 | 0x7F800000 | f << 13);
        }
        return Float.intBitsToFloat(s << 31 | (e += 112) << 23 | (f <<= 13));
    }

    public static float toFloat(short s) {
        if (s == 0) {
            return 0.0f;
        }
        int i32a = s & 0xFFFF;
        int e_o = (i32a & 0x7800) + 118784 << 13;
        int a1 = (i32a & 0x8000) << 16;
        int a2 = (i32a & 0x7FF) << 13;
        int f32r = a1 | e_o | a2;
        float f = Float.intBitsToFloat(f32r);
        return f;
    }
}

