/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.TAXI;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class TAXIParameterFileReader {
    private final File file;
    public String timeutc;
    public int naz;
    public int nrg;
    public int naz_ml;
    public int nrg_ml;
    public double azml;
    public double rgml;
    public double ps_rg;
    public double ps_az;
    public double tcycle;
    public double sensorVelocity;
    public double radarFrequency;
    public double waveLength;
    public double[] slantRange;
    public double[] kt;
    public double[] v;
    public double[] DopplerCentroid;

    public TAXIParameterFileReader(File file) {
        this.file = file;
    }

    public void readParameterFile() throws Exception {
        try {
            Document xmlDoc = XMLSupport.LoadXML((String)this.file.getAbsolutePath());
            Element xmlRoot = xmlDoc.getRootElement();
            Element object = xmlRoot.getChild("object");
            List children = object.getContent();
            for (Object aChild : children) {
                String name;
                Element elem;
                Attribute nameAttr;
                if (!(aChild instanceof Element) || (nameAttr = (elem = (Element)aChild).getAttribute("name")) == null) continue;
                switch (name = nameAttr.getValue()) {
                    case "timeutc": {
                        this.timeutc = TAXIParameterFileReader.getElementString(elem);
                        break;
                    }
                    case "naz": {
                        this.naz = TAXIParameterFileReader.getElementInt(elem);
                        break;
                    }
                    case "nrg": {
                        this.nrg = TAXIParameterFileReader.getElementInt(elem);
                        break;
                    }
                    case "naz_ml": {
                        this.naz_ml = TAXIParameterFileReader.getElementInt(elem);
                        break;
                    }
                    case "nrg_ml": {
                        this.nrg_ml = TAXIParameterFileReader.getElementInt(elem);
                        break;
                    }
                    case "azml": {
                        this.azml = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "rgml": {
                        this.rgml = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "ps_az": {
                        this.ps_az = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "ps_rg": {
                        this.ps_rg = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "r": {
                        this.slantRange = TAXIParameterFileReader.getElementArray(elem);
                        break;
                    }
                    case "tcycle": {
                        this.tcycle = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "kt": {
                        this.kt = TAXIParameterFileReader.getElementArray(elem);
                        break;
                    }
                    case "v": {
                        this.v = TAXIParameterFileReader.getElementArray(elem);
                        break;
                    }
                    case "vs": {
                        this.sensorVelocity = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "f0": {
                        this.radarFrequency = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "lambda": {
                        this.waveLength = TAXIParameterFileReader.getElementDouble(elem);
                        break;
                    }
                    case "fdc": {
                        this.DopplerCentroid = TAXIParameterFileReader.getElementArray(elem);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getElementString(Element elem) {
        Element value = elem.getChild("value");
        return value.getValue();
    }

    private static int getElementInt(Element elem) {
        Element value = elem.getChild("value");
        return Integer.parseInt(value.getValue());
    }

    private static double getElementDouble(Element elem) {
        Element value = elem.getChild("value");
        return Double.parseDouble(value.getValue());
    }

    private static double[] getElementArray(Element elem) {
        Element value = elem.getChild("value");
        Element ptr = value.getChild("parameter");
        Element val = ptr.getChild("value");
        String str = val.getValue();
        str = str.replace("[", "").replace("]", "");
        return TAXIParameterFileReader.stringToDoubleArray(str, ",");
    }

    public static double[] stringToDoubleArray(String csvString, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(csvString, delim);
        ArrayList<String> strList = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            strList.add(tokenizer.nextToken());
        }
        double[] array = new double[strList.size()];
        int i = 0;
        for (String s : strList) {
            array[i++] = Double.parseDouble(s);
        }
        return array;
    }
}

