/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.RuntimeContext;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.util.ExceptionLog;

public abstract class SARReader
extends AbstractProductReader {
    private static String[] elemsToKeep = new String[]{"Abstracted_Metadata", "MAIN_PROCESSING_PARAMS_ADS", "DSD", "SPH", "lutSigma"};

    protected SARReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected abstract Product readProductNodesImpl() throws IOException;

    protected abstract void readBandRasterDataImpl(int var1, int var2, int var3, int var4, int var5, int var6, Band var7, int var8, int var9, int var10, int var11, ProductData var12, ProgressMonitor var13) throws IOException;

    protected static void setQuicklookBandName(Product product) {
        String unit;
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            unit = band.getUnit();
            if (unit == null || !unit.contains("intensity") && !unit.contains("amplitude")) continue;
            product.setQuicklookBandName(band.getName());
            return;
        }
        for (Band band : bands) {
            unit = band.getUnit();
            if (unit == null || !unit.contains("amplitude")) continue;
            product.setQuicklookBandName(band.getName());
            return;
        }
    }

    protected void addQuicklook(Product product, String name, File qlFile) {
        if (qlFile != null) {
            product.getQuicklookGroup().add((ProductNode)new Quicklook(product, name, qlFile));
        }
    }

    public static void createVirtualIntensityBand(Product product, Band band, String countStr) {
        String expression = band.getName() + " * " + band.getName();
        VirtualBand virtBand = new VirtualBand("Intensity" + countStr, 30, band.getRasterWidth(), band.getRasterHeight(), expression);
        virtBand.setUnit("intensity");
        virtBand.setDescription("Intensity from complex data");
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
    }

    public static String findPolarizationInBandName(String bandName) {
        String id = bandName.toUpperCase();
        if (id.contains("HH") || id.contains("H/H") || id.contains("H-H")) {
            return "HH";
        }
        if (id.contains("VV") || id.contains("V/V") || id.contains("V-V")) {
            return "VV";
        }
        if (id.contains("HV") || id.contains("H/V") || id.contains("H-V")) {
            return "HV";
        }
        if (id.contains("VH") || id.contains("V/H") || id.contains("V-H")) {
            return "VH";
        }
        return null;
    }

    public static void discardUnusedMetadata(Product product) {
        String dicardUnusedMetadata = RuntimeContext.getModuleContext().getRuntimeConfig().getContextProperty("discard.unused.metadata");
        if (dicardUnusedMetadata.equalsIgnoreCase("true")) {
            SARReader.removeUnusedMetadata(AbstractMetadata.getOriginalProductMetadata((Product)product));
        }
    }

    private static void removeUnusedMetadata(MetadataElement root) {
        MetadataElement[] elems;
        for (MetadataElement elem : elems = root.getElements()) {
            String name = elem.getName();
            boolean keep = false;
            for (String toKeep : elemsToKeep) {
                if (!name.equals(toKeep)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            root.removeElement(elem);
            elem.dispose();
        }
    }

    public void handleReaderException(Throwable e) throws IOException {
        String message = this.toString() + ":\n";
        message = message.replace("[input", "\n[input");
        message = e.getMessage() != null ? message + e.getMessage() : message + e.toString();
        if (Boolean.getBoolean("sendErrorOnException")) {
            ExceptionLog.log((String)message);
        }
        SystemUtils.LOG.severe(message);
        throw new IOException(message);
    }

    public static boolean checkIfCrossMeridian(float[] longitudeList) {
        Arrays.sort(longitudeList);
        return longitudeList[longitudeList.length - 1] - longitudeList[0] > 270.0f;
    }
}

