/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io;

import java.util.ArrayList;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;

public class PolBandUtils {
    public static MATRIX getSourceProductType(Product sourceProduct) {
        String[] bandNames = sourceProduct.getBandNames();
        boolean isC3 = false;
        boolean isT3 = false;
        boolean isC2 = false;
        boolean isLCHS2 = false;
        boolean isRCHS2 = false;
        boolean isHH = false;
        boolean isHV = false;
        boolean isVV = false;
        boolean isVH = false;
        for (String name : bandNames) {
            if (name.contains("C44")) {
                return MATRIX.C4;
            }
            if (name.contains("T44")) {
                return MATRIX.T4;
            }
            if (name.contains("C33")) {
                isC3 = true;
                continue;
            }
            if (name.contains("T33")) {
                isT3 = true;
                continue;
            }
            if (name.contains("C22")) {
                isC2 = true;
                continue;
            }
            if (name.contains("LH")) {
                isLCHS2 = true;
                continue;
            }
            if (name.contains("RH")) {
                isRCHS2 = true;
                continue;
            }
            if (name.contains("_HH")) {
                isHH = true;
                continue;
            }
            if (name.contains("_HV")) {
                isHV = true;
                continue;
            }
            if (name.contains("_VV")) {
                isVV = true;
                continue;
            }
            if (!name.contains("_VH")) continue;
            isVH = true;
        }
        if (isC3) {
            return MATRIX.C3;
        }
        if (isT3) {
            return MATRIX.T3;
        }
        if (isC2) {
            return MATRIX.C2;
        }
        if (isLCHS2) {
            return MATRIX.LCHCP;
        }
        if (isRCHS2) {
            return MATRIX.RCHCP;
        }
        if (isHH && isHV && !isVH && !isVV) {
            return MATRIX.DUAL_HH_HV;
        }
        if (!isHH && !isHV && isVH && isVV) {
            return MATRIX.DUAL_VH_VV;
        }
        if (isHH && !isHV && !isVH && isVV) {
            return MATRIX.DUAL_HH_VV;
        }
        if (isHH && isHV && isVH && isVV) {
            return MATRIX.FULL;
        }
        return MATRIX.UNKNOWN;
    }

    public static PolSourceBand[] getSourceBands(Product srcProduct, MATRIX sourceProductType) throws Exception {
        boolean isCoregistered = StackUtils.isCoregisteredStack((Product)srcProduct);
        ArrayList<PolSourceBand> quadSrcBandList = new ArrayList<PolSourceBand>(10);
        if (isCoregistered) {
            String[] slvProductNames;
            String[] mstBandNames = StackUtils.getMasterBandNames((Product)srcProduct);
            Band[] mstBands = PolBandUtils.getBands(srcProduct, sourceProductType, mstBandNames);
            String suffix = mstBandNames[0].substring(mstBandNames[0].lastIndexOf(95), mstBandNames[0].length());
            quadSrcBandList.add(new PolSourceBand(srcProduct.getName(), mstBands, suffix));
            for (String slvProd : slvProductNames = StackUtils.getSlaveProductNames((Product)srcProduct)) {
                String[] slvBandNames = StackUtils.getSlaveBandNames((Product)srcProduct, (String)slvProd);
                Band[] slvBands = PolBandUtils.getBands(srcProduct, sourceProductType, slvBandNames);
                String suf = slvBandNames[0].substring(slvBandNames[0].lastIndexOf(95), slvBandNames[0].length());
                quadSrcBandList.add(new PolSourceBand(slvProd, slvBands, suf));
            }
        } else {
            String[] bandNames = srcProduct.getBandNames();
            Band[] mstBands = PolBandUtils.getBands(srcProduct, sourceProductType, bandNames);
            quadSrcBandList.add(new PolSourceBand(srcProduct.getName(), mstBands, ""));
        }
        return quadSrcBandList.toArray(new PolSourceBand[quadSrcBandList.size()]);
    }

    private static Band[] getBands(Product srcProduct, MATRIX sourceProductType, String[] bandNames) throws Exception {
        if (sourceProductType == MATRIX.DUAL_HH_HV) {
            return PolBandUtils.getDualPolSrcBands(srcProduct, PolBandUtils.getComplexBandNames());
        }
        if (sourceProductType == MATRIX.DUAL_VH_VV) {
            return PolBandUtils.getDualPolSrcBands(srcProduct, PolBandUtils.getComplexBandNames());
        }
        if (sourceProductType == MATRIX.DUAL_HH_VV) {
            return PolBandUtils.getDualPolSrcBands(srcProduct, PolBandUtils.getComplexBandNames());
        }
        if (sourceProductType == MATRIX.FULL) {
            return PolBandUtils.getQuadPolSrcBands(srcProduct, bandNames);
        }
        if (sourceProductType == MATRIX.C3) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getC3BandNames());
        }
        if (sourceProductType == MATRIX.T3) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getT3BandNames());
        }
        if (sourceProductType == MATRIX.C4) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getC4BandNames());
        }
        if (sourceProductType == MATRIX.T4) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getT4BandNames());
        }
        if (sourceProductType == MATRIX.C2) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getC2BandNames());
        }
        if (sourceProductType == MATRIX.LCHCP) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getLCHModeS2BandNames());
        }
        if (sourceProductType == MATRIX.RCHCP) {
            return PolBandUtils.getProductBands(srcProduct, bandNames, PolBandUtils.getRCHModeS2BandNames());
        }
        return null;
    }

    private static Band[] getDualPolSrcBands(Product srcProduct, String[] srcBandNames) {
        ArrayList<Band> bandList = new ArrayList<Band>();
        for (Band srcBand : srcProduct.getBands()) {
            String bandName = srcBand.getName();
            for (String s : srcBandNames) {
                if (!bandName.startsWith(s)) continue;
                bandList.add(srcBand);
            }
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    private static Band[] getQuadPolSrcBands(Product srcProduct, String[] srcBandNames) throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        boolean isComplex = absRoot.getAttributeString("SAMPLE_TYPE").equals("COMPLEX");
        if (!isComplex) {
            ArrayList<Band> bandList = new ArrayList<Band>();
            for (String srcBandName : srcBandNames) {
                String pol;
                Band band = srcProduct.getBand(srcBandName);
                String bandUnit = band.getUnit();
                if (bandUnit == null || !bandUnit.contains("intensity") || !(pol = OperatorUtils.getBandPolarization((String)band.getName(), (MetadataElement)absRoot)).contains("hh") && !pol.contains("hv") && !pol.contains("vh") && !pol.contains("vv")) continue;
                bandList.add(band);
            }
            if (bandList.size() < 4) {
                throw new OperatorException("A full polarization product is expected as input.");
            }
            return bandList.toArray(new Band[bandList.size()]);
        }
        int validBandCnt = 0;
        Band[] sourceBands = new Band[8];
        for (String srcBandName : srcBandNames) {
            Band band = srcProduct.getBand(srcBandName);
            Unit.UnitType bandUnit = Unit.getUnitType((Band)band);
            if (bandUnit != Unit.UnitType.REAL && bandUnit != Unit.UnitType.IMAGINARY) continue;
            String pol = OperatorUtils.getBandPolarization((String)band.getName(), (MetadataElement)absRoot);
            if (pol.contains("hh")) {
                if (bandUnit.equals((Object)Unit.UnitType.REAL)) {
                    sourceBands[0] = band;
                    ++validBandCnt;
                    continue;
                }
                if (!bandUnit.equals((Object)Unit.UnitType.IMAGINARY)) continue;
                sourceBands[1] = band;
                ++validBandCnt;
                continue;
            }
            if (pol.contains("hv")) {
                if (bandUnit.equals((Object)Unit.UnitType.REAL)) {
                    sourceBands[2] = band;
                    ++validBandCnt;
                    continue;
                }
                if (!bandUnit.equals((Object)Unit.UnitType.IMAGINARY)) continue;
                sourceBands[3] = band;
                ++validBandCnt;
                continue;
            }
            if (pol.contains("vh")) {
                if (bandUnit.equals((Object)Unit.UnitType.REAL)) {
                    sourceBands[4] = band;
                    ++validBandCnt;
                    continue;
                }
                if (!bandUnit.equals((Object)Unit.UnitType.IMAGINARY)) continue;
                sourceBands[5] = band;
                ++validBandCnt;
                continue;
            }
            if (!pol.contains("vv")) continue;
            if (bandUnit.equals((Object)Unit.UnitType.REAL)) {
                sourceBands[6] = band;
                ++validBandCnt;
                continue;
            }
            if (!bandUnit.equals((Object)Unit.UnitType.IMAGINARY)) continue;
            sourceBands[7] = band;
            ++validBandCnt;
        }
        if (validBandCnt != 8) {
            throw new OperatorException("A full polarization product is expected as input.");
        }
        return sourceBands;
    }

    private static Band[] getProductBands(Product srcProduct, String[] srcBandNames, String[] validBandNames) throws OperatorException {
        Band[] sourceBands = new Band[validBandNames.length];
        int validBandCnt = 0;
        block0: for (String bandName : srcBandNames) {
            Band band = srcProduct.getBand(bandName);
            if (band == null) {
                throw new OperatorException("Band " + bandName + " not found");
            }
            for (String validName : validBandNames) {
                if (!bandName.contains(validName)) continue;
                sourceBands[validBandCnt++] = band;
                continue block0;
            }
        }
        if (validBandCnt != validBandNames.length) {
            throw new OperatorException("Input is not a valid polarimetric matrix");
        }
        return sourceBands;
    }

    public static void saveNewBandNames(Product targetProduct, PolSourceBand[] srcBandList) {
        if (StackUtils.isCoregisteredStack((Product)targetProduct)) {
            boolean masterProduct = true;
            for (PolSourceBand bandList : srcBandList) {
                String[] bandNames;
                if (masterProduct) {
                    bandNames = StackUtils.bandsToStringArray((Band[])bandList.targetBands);
                    StackUtils.saveMasterProductBandNames((Product)targetProduct, (String[])bandNames);
                    masterProduct = false;
                    continue;
                }
                bandNames = StackUtils.bandsToStringArray((Band[])bandList.targetBands);
                StackUtils.saveSlaveProductBandNames((Product)targetProduct, (String)bandList.productName, (String[])bandNames);
            }
        }
    }

    public static boolean isDualPol(MATRIX m) {
        return m == MATRIX.DUAL_HH_HV || m == MATRIX.DUAL_VH_VV || m == MATRIX.DUAL_HH_VV || m == MATRIX.C2 || m == MATRIX.LCHCP || m == MATRIX.RCHCP;
    }

    public static boolean isQuadPol(MATRIX m) {
        return m == MATRIX.C3 || m == MATRIX.T3 || m == MATRIX.C4 || m == MATRIX.T4;
    }

    public static boolean isFullPol(MATRIX m) {
        return m == MATRIX.FULL;
    }

    public static String[] getComplexBandNames() {
        return new String[]{"i_", "q_"};
    }

    public static String[] getG4BandNames() {
        return new String[]{"g0", "g1", "g2", "g3"};
    }

    public static String[] getLCHModeS2BandNames() {
        return new String[]{"i_LH", "q_LH", "i_LV", "q_LV"};
    }

    public static String[] getRCHModeS2BandNames() {
        return new String[]{"i_RH", "q_RH", "i_RV", "q_RV"};
    }

    public static String[] getC2BandNames() {
        return new String[]{"C11", "C12_real", "C12_imag", "C22"};
    }

    public static String[] getC3BandNames() {
        return new String[]{"C11", "C12_real", "C12_imag", "C13_real", "C13_imag", "C22", "C23_real", "C23_imag", "C33"};
    }

    public static String[] getC4BandNames() {
        return new String[]{"C11", "C12_real", "C12_imag", "C13_real", "C13_imag", "C14_real", "C14_imag", "C22", "C23_real", "C23_imag", "C24_real", "C24_imag", "C33", "C34_real", "C34_imag", "C44"};
    }

    public static String[] getT3BandNames() {
        return new String[]{"T11", "T12_real", "T12_imag", "T13_real", "T13_imag", "T22", "T23_real", "T23_imag", "T33"};
    }

    public static String[] getT4BandNames() {
        return new String[]{"T11", "T12_real", "T12_imag", "T13_real", "T13_imag", "T14_real", "T14_imag", "T22", "T23_real", "T23_imag", "T24_real", "T24_imag", "T33", "T34_real", "T34_imag", "T44"};
    }

    public static String getPolarType(Product product) throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        if (absRoot != null && !AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"mds1_tx_rx_polar") && !AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"mds2_tx_rx_polar")) {
            if (!AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"mds3_tx_rx_polar") && !AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"mds4_tx_rx_polar")) {
                return "full";
            }
            return "dual";
        }
        return "single";
    }

    public static boolean isBandForMatrixElement(String bandName, String elemPrefix) {
        return bandName.length() > elemPrefix.length() && bandName.substring(1, elemPrefix.length() + 1).equals(elemPrefix);
    }

    public static class PolSourceBand {
        public final String productName;
        public final Band[] srcBands;
        public final String suffix;
        public Band[] targetBands;
        public double spanMin = 1.0E30;
        public double spanMax = -1.0E30;
        public boolean spanMinMaxSet = false;

        public PolSourceBand(String productName, Band[] bands, String suffix) {
            this.productName = productName;
            this.srcBands = bands;
            this.suffix = suffix;
        }

        public void addTargetBands(Band[] targetBands) {
            this.targetBands = targetBands;
        }
    }

    public static enum MATRIX {
        DUAL_HH_HV,
        DUAL_VH_VV,
        DUAL_HH_VV,
        C2,
        LCHCP,
        RCHCP,
        C3,
        T3,
        C4,
        T4,
        FULL,
        UNKNOWN;

    }
}

