/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.esa.s1tbx.commons.io.AbstractProductDirectory;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.jdom2.Content;
import org.jdom2.Element;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class JSONProductDirectory
extends AbstractProductDirectory {
    protected JSONObject json;

    public JSONProductDirectory(File headerFile) {
        super(headerFile);
    }

    @Override
    public void readProductDirectory() throws IOException {
        try {
            File headerFile = this.getFile(this.getRootFolder() + this.getHeaderFileName());
            BufferedReader streamReader = new BufferedReader(new FileReader(headerFile.getPath()));
            JSONParser parser = new JSONParser();
            this.json = (JSONObject)parser.parse((Reader)streamReader);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected MetadataElement addMetaData() throws IOException {
        MetadataElement root = new MetadataElement("metadata");
        AbstractMetadataIO.AddXMLMetadata((Element)JSONProductDirectory.jsonToXML("ProductMetadata", this.json), (MetadataElement)AbstractMetadata.addOriginalProductMetadata((MetadataElement)root));
        this.addAbstractedMetadataHeader(root);
        return root;
    }

    public static Element jsonToXML(String name, JSONObject json) {
        Element root = new Element(name);
        for (Object key : json.keySet()) {
            Object obj = json.get(key);
            if (obj instanceof JSONObject) {
                root.addContent((Content)JSONProductDirectory.jsonToXML((String)key, (JSONObject)obj));
                continue;
            }
            if (obj instanceof JSONArray) {
                root.addContent((Content)JSONProductDirectory.jsonArrayToXML((String)key, (JSONArray)obj));
                continue;
            }
            root.setAttribute((String)key, String.valueOf(obj));
        }
        return root;
    }

    private static Element jsonArrayToXML(String name, JSONArray jsonArray) {
        Element root = new Element(name);
        int cnt = 1;
        for (Object obj : jsonArray) {
            if (obj instanceof JSONObject) {
                root.addContent((Content)JSONProductDirectory.jsonToXML(name, (JSONObject)obj));
                continue;
            }
            if (obj instanceof JSONArray) {
                root.addContent((Content)JSONProductDirectory.jsonArrayToXML(name, (JSONArray)obj));
                continue;
            }
            root.setAttribute(name + cnt, String.valueOf(obj));
            ++cnt;
        }
        return root;
    }

    public static GeoPos[] parseCoordinates(JSONArray node) {
        ArrayList<GeoPos> geoPosList = new ArrayList<GeoPos>();
        for (Object o : node) {
            if (!(o instanceof JSONArray)) continue;
            JSONArray latLonList = (JSONArray)o;
            for (Object latlon : latLonList) {
                if (!(latlon instanceof JSONArray)) continue;
                JSONArray coordList = (JSONArray)latlon;
                GeoPos geoPos = new GeoPos(((Double)coordList.get(0)).doubleValue(), ((Double)coordList.get(1)).doubleValue());
                geoPosList.add(geoPos);
            }
        }
        return geoPosList.toArray(new GeoPos[geoPosList.size()]);
    }

    @Override
    protected abstract void addAbstractedMetadataHeader(MetadataElement var1) throws IOException;
}

