/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons.io;

import com.bc.ceres.core.VirtualDir;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.s1tbx.commons.io.ImageIOFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public abstract class AbstractProductDirectory {
    protected VirtualDir productDir = null;
    protected String baseName;
    protected File baseDir;
    protected String rootFolder = null;
    protected final File productInputFile;
    private boolean isSLC = false;
    private boolean isMapProjected;
    protected final transient Map<String, ImageIOFile> bandImageFileMap = new TreeMap<String, ImageIOFile>();
    protected final transient Map<Band, ImageIOFile.BandInfo> bandMap = new HashMap<Band, ImageIOFile.BandInfo>(3);

    protected AbstractProductDirectory(File inputFile) {
        Guardian.assertNotNull((String)"inputFile", (Object)inputFile);
        this.productInputFile = inputFile;
        this.createProductDir(inputFile);
    }

    protected void createProductDir(File inputFile) {
        if (ZipUtils.isZip((File)inputFile)) {
            this.baseDir = inputFile;
            this.productDir = VirtualDir.create((File)this.baseDir);
            this.baseName = this.baseDir.getName();
            if (this.baseName.endsWith(".zip")) {
                this.baseName = this.baseName.substring(0, this.baseName.lastIndexOf(".zip"));
            }
        } else {
            this.baseDir = inputFile.getParentFile();
            this.productDir = VirtualDir.create((File)this.baseDir);
            this.baseName = this.baseDir.getName();
        }
    }

    public final String getRootFolder() {
        if (this.rootFolder == null) {
            this.rootFolder = this.findRootFolder();
        }
        return this.rootFolder;
    }

    protected String findRootFolder() {
        String rootFolder = "";
        try {
            if (this.productDir.isCompressed()) {
                rootFolder = ZipUtils.getRootFolder((File)this.baseDir, (String)this.getHeaderFileName());
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to get root path from zip file " + e.getMessage());
        }
        return rootFolder;
    }

    protected String getRelativePathToImageFolder() {
        return this.getRootFolder();
    }

    public abstract void readProductDirectory() throws IOException;

    protected String getHeaderFileName() {
        return this.productInputFile.getName();
    }

    protected abstract void addImageFile(String var1, MetadataElement var2) throws IOException;

    public boolean isSLC() {
        return this.isSLC;
    }

    protected void setSLC(boolean flag) {
        this.isSLC = flag;
    }

    public boolean isMapProjected() {
        return this.isMapProjected;
    }

    protected boolean isCompressed() {
        return this.productDir.isCompressed();
    }

    protected final void findImages(String parentPath, MetadataElement newRoot) throws IOException {
        String[] listing;
        try {
            listing = this.productDir.list(parentPath);
        }
        catch (FileNotFoundException e) {
            listing = null;
        }
        if (listing != null) {
            List<String> sortedList = Arrays.asList(listing);
            Collections.sort(sortedList);
            for (String fileName : sortedList) {
                this.addImageFile(parentPath + fileName, newRoot);
            }
        }
    }

    protected String getBandFileNameFromImage(String imgPath) {
        if (imgPath.contains("/")) {
            return imgPath.substring(imgPath.lastIndexOf(47) + 1, imgPath.length()).toLowerCase();
        }
        return imgPath;
    }

    protected Dimension getBandDimensions(MetadataElement newRoot, String bandMetadataName) {
        int height;
        int width;
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        MetadataElement bandMetadata = absRoot.getElement(bandMetadataName);
        if (bandMetadata != null) {
            width = bandMetadata.getAttributeInt("num_samples_per_line");
            height = bandMetadata.getAttributeInt("num_output_lines");
        } else {
            width = absRoot.getAttributeInt("num_samples_per_line");
            height = absRoot.getAttributeInt("num_output_lines");
        }
        return new Dimension(width, height);
    }

    protected void findImages(MetadataElement newRoot) throws IOException {
        String parentPath = this.getRelativePathToImageFolder();
        this.findImages(parentPath, newRoot);
    }

    public ImageIOFile.BandInfo getBandInfo(Band destBand) {
        ImageIOFile.BandInfo bandInfo = this.bandMap.get(destBand);
        if (bandInfo == null) {
            for (Band srcBand : this.bandMap.keySet()) {
                if (!srcBand.getName().equals(destBand.getName())) continue;
                bandInfo = this.bandMap.get(srcBand);
            }
        }
        return bandInfo;
    }

    public void close() throws IOException {
        Set<String> keys = this.bandImageFileMap.keySet();
        for (String key : keys) {
            ImageIOFile img = this.bandImageFileMap.get(key);
            img.close();
        }
        this.productDir.close();
    }

    protected abstract void addBands(Product var1) throws IOException;

    protected abstract void addGeoCoding(Product var1);

    protected abstract void addTiePointGrids(Product var1);

    protected abstract void addAbstractedMetadataHeader(MetadataElement var1) throws IOException;

    protected abstract String getProductName();

    protected abstract String getProductType();

    protected String getProductDescription() {
        return "";
    }

    protected abstract MetadataElement addMetaData() throws IOException;

    public String[] listFiles(String path) throws IOException {
        try {
            String[] listing = this.productDir.list(path);
            List<String> sortedList = Arrays.asList(listing);
            Collections.sort(sortedList);
            ArrayList<String> files = new ArrayList<String>(listing.length);
            for (String listEntry : sortedList) {
                if (this.isDirectory(path + '/' + listEntry)) continue;
                files.add(listEntry);
            }
            return files.toArray(new String[files.size()]);
        }
        catch (Exception e) {
            throw new IOException("Product is corrupt or incomplete\n" + e.getMessage());
        }
    }

    public String[] findFilesContaining(String path, String searchString) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] files;
            for (String file : files = this.listFiles(path)) {
                if (!file.contains(searchString)) continue;
                list.add(file);
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Error listing files in " + path);
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean isDirectory(String path) throws IOException {
        if (this.productDir.isCompressed()) {
            if (path.contains(".")) {
                int sepIndex = path.lastIndexOf(47);
                int dotIndex = path.lastIndexOf(46);
                return dotIndex < sepIndex;
            }
            ZipFile productZip = new ZipFile(this.baseDir, 1);
            Optional<ZipEntry> result = productZip.stream().filter(ze -> ze.isDirectory()).filter(ze -> ze.getName().equals(path)).findFirst();
            return result.isPresent();
        }
        return this.productDir.getFile(path).isDirectory();
    }

    public File getFile(String path) throws IOException {
        return this.productDir.getFile(path);
    }

    public boolean exists(String path) {
        return this.productDir.exists(path);
    }

    public InputStream getInputStream(String path) throws IOException {
        InputStream inStream = this.productDir.getInputStream(path);
        if (inStream == null) {
            throw new IOException("Product is corrupt or incomplete: unreadable " + path);
        }
        return inStream;
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    public Product createProduct() throws Exception {
        MetadataElement newRoot = this.addMetaData();
        this.findImages(newRoot);
        Dimension dim = this.getProductDimensions(newRoot);
        Product product = new Product(this.getProductName(), this.getProductType(), dim.width, dim.height);
        AbstractProductDirectory.updateProduct(product, newRoot);
        this.addBands(product);
        InputProductValidator validator = new InputProductValidator(product);
        this.isMapProjected = validator.isMapProjected();
        this.addGeoCoding(product);
        this.addTiePointGrids(product);
        product.setName(this.getProductName());
        product.setProductType(this.getProductType());
        product.setDescription(this.getProductDescription());
        ReaderUtils.addMetadataIncidenceAngles((Product)product);
        ReaderUtils.addMetadataProductSize((Product)product);
        return product;
    }

    protected Dimension getProductDimensions(MetadataElement newRoot) {
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        int sceneWidth = absRoot.getAttributeInt("num_samples_per_line");
        int sceneHeight = absRoot.getAttributeInt("num_output_lines");
        return new Dimension(sceneWidth, sceneHeight);
    }

    protected static void updateProduct(Product product, MetadataElement newRoot) {
        MetadataElement root = product.getMetadataRoot();
        for (MetadataElement elem : newRoot.getElements()) {
            root.addElement(elem);
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        product.setStartTime(absRoot.getAttributeUTC("first_line_time"));
        product.setEndTime(absRoot.getAttributeUTC("last_line_time"));
        product.setProductType(absRoot.getAttributeString("PRODUCT_TYPE"));
        product.setDescription(absRoot.getAttributeString("SPH_DESCRIPTOR"));
    }

    protected static float[][] getBoundingBox(float[][] coordinateList) {
        float[][] boundingBox = new float[4][2];
        float minX = coordinateList[0][0];
        float minY = coordinateList[0][1];
        float maxX = coordinateList[0][0];
        float maxY = coordinateList[0][1];
        for (float[] coordinate : coordinateList) {
            if (coordinate[0] < minX) {
                minX = coordinate[0];
            } else if (coordinate[0] > maxX) {
                maxX = coordinate[0];
            }
            if (coordinate[1] < minY) {
                minY = coordinate[1];
                continue;
            }
            if (!(coordinate[1] > maxY)) continue;
            maxY = coordinate[1];
        }
        boundingBox[0] = new float[]{minX, maxY};
        boundingBox[1] = new float[]{maxX, maxY};
        boundingBox[2] = new float[]{minX, minY};
        boundingBox[3] = new float[]{maxX, minY};
        return boundingBox;
    }
}

