/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.commons.OrbitStateVectors;
import org.esa.s1tbx.commons.SARUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.PosVector;

public final class Sentinel1Utils {
    private Product sourceProduct = null;
    private MetadataElement absRoot = null;
    private MetadataElement origProdRoot = null;
    private int numOfSubSwath = 0;
    private String acquisitionMode = null;
    private SubSwathInfo[] subSwath = null;
    private OrbitStateVectors orbit = null;
    private String[] polarizations = null;
    private String[] subSwathNames = null;
    private boolean isDopplerCentroidAvailable = false;
    private boolean isRangeDependDopplerRateAvailable = false;
    public double firstLineUTC = 0.0;
    public double lastLineUTC = 0.0;
    public double lineTimeInterval = 0.0;
    public double nearEdgeSlantRange = 0.0;
    public double wavelength = 0.0;
    public double rangeSpacing = 0.0;
    public double azimuthSpacing = 0.0;
    public int sourceImageWidth = 0;
    public int sourceImageHeight = 0;
    public boolean nearRangeOnLeft = true;
    public boolean srgrFlag = false;
    public AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;

    public Sentinel1Utils(Product sourceProduct) throws Exception {
        this.sourceProduct = sourceProduct;
        this.getMetadataRoot();
        this.getAbstractedMetadata();
        this.getProductAcquisitionMode();
        this.getProductPolarizations();
        this.getProductSubSwathNames();
        this.getSubSwathParameters();
        this.nearRangeOnLeft = this.subSwath[0].incidenceAngle[0][0] < this.subSwath[0].incidenceAngle[0][1];
    }

    private void getMetadataRoot() {
        MetadataElement root = this.sourceProduct.getMetadataRoot();
        if (root == null) {
            throw new OperatorException("Root Metadata not found");
        }
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        if (this.absRoot == root) {
            throw new OperatorException("Abstracted_Metadata not found.");
        }
        this.origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
        if (this.origProdRoot == root) {
            throw new OperatorException("Original_Product_Metadata not found.");
        }
        String mission = this.absRoot.getAttributeString("MISSION");
        if (!mission.startsWith("SENTINEL-1")) {
            throw new OperatorException(mission + " is not a valid mission for Sentinel1 product.");
        }
    }

    private void getAbstractedMetadata() throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"srgr_flag");
        this.wavelength = SARUtils.getRadarFrequency(absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
        this.firstLineUTC = absRoot.getAttributeUTC("first_line_time").getMJD();
        this.lastLineUTC = absRoot.getAttributeUTC("last_line_time").getMJD();
        this.lineTimeInterval = absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        OrbitStateVector[] orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)absRoot);
        this.orbit = new OrbitStateVectors(orbitStateVectors, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)absRoot);
        } else {
            this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"slant_range_to_first_pixel");
        }
    }

    private void getProductAcquisitionMode() {
        this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
    }

    private void getProductPolarizations() {
        String[] sourceBandNames;
        MetadataElement[] elems = this.absRoot.getElements();
        ArrayList<String> polList = new ArrayList<String>(4);
        for (MetadataElement elem : elems) {
            String pol;
            if (!elem.getName().contains("Band_") || polList.contains(pol = elem.getAttributeString("polarization"))) continue;
            polList.add(pol);
        }
        if (polList.size() > 0) {
            this.polarizations = polList.toArray(new String[polList.size()]);
            Arrays.sort(this.polarizations);
            return;
        }
        for (String bandName : sourceBandNames = this.sourceProduct.getBandNames()) {
            if (bandName.contains("HH")) {
                if (polList.contains("HH")) continue;
                polList.add("HH");
                continue;
            }
            if (bandName.contains("HV")) {
                if (polList.contains("HV")) continue;
                polList.add("HV");
                continue;
            }
            if (bandName.contains("VH")) {
                if (polList.contains("VH")) continue;
                polList.add("VH");
                continue;
            }
            if (!bandName.contains("VV") || polList.contains("VV")) continue;
            polList.add("VV");
        }
        this.polarizations = polList.toArray(new String[polList.size()]);
        Arrays.sort(this.polarizations);
    }

    private void getProductSubSwathNames() {
        MetadataElement[] elems = this.absRoot.getElements();
        ArrayList<String> subSwathNameList = new ArrayList<String>(4);
        for (MetadataElement elem : elems) {
            String swath;
            if (!elem.getName().contains(this.acquisitionMode) || subSwathNameList.contains(swath = elem.getAttributeString("swath"))) continue;
            subSwathNameList.add(swath);
        }
        if (subSwathNameList.size() < 1) {
            String[] sourceBandNames;
            for (String bandName : sourceBandNames = this.sourceProduct.getBandNames()) {
                int idx;
                String subSwathName;
                if (!bandName.contains(this.acquisitionMode) || subSwathNameList.contains(subSwathName = bandName.substring(idx = bandName.indexOf(this.acquisitionMode), idx + 3))) continue;
                subSwathNameList.add(subSwathName);
            }
        }
        this.subSwathNames = subSwathNameList.toArray(new String[subSwathNameList.size()]);
        Arrays.sort(this.subSwathNames);
        this.numOfSubSwath = this.subSwathNames.length;
    }

    private void getSubSwathParameters() {
        this.subSwath = new SubSwathInfo[this.numOfSubSwath];
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            this.subSwath[i] = new SubSwathInfo();
            this.subSwath[i].subSwathName = this.subSwathNames[i];
            MetadataElement subSwathMetadata = this.getSubSwathMetadata(this.subSwath[i].subSwathName);
            Sentinel1Utils.getSubSwathParameters(subSwathMetadata, this.subSwath[i]);
        }
    }

    private MetadataElement getSubSwathMetadata(String subSwathName) {
        MetadataElement[] elems;
        MetadataElement annotation = this.origProdRoot.getElement("annotation");
        if (annotation == null) {
            throw new OperatorException("Annotation Metadata not found");
        }
        for (MetadataElement elem : elems = annotation.getElements()) {
            if (!elem.getName().contains(subSwathName.toLowerCase())) continue;
            return elem;
        }
        return null;
    }

    private static void getSubSwathParameters(MetadataElement subSwathMetadata, SubSwathInfo subSwath) {
        int n;
        MetadataElement product = subSwathMetadata.getElement("product");
        MetadataElement imageAnnotation = product.getElement("imageAnnotation");
        MetadataElement imageInformation = imageAnnotation.getElement("imageInformation");
        MetadataElement swathTiming = product.getElement("swathTiming");
        MetadataElement burstList = swathTiming.getElement("burstList");
        MetadataElement generalAnnotation = product.getElement("generalAnnotation");
        MetadataElement productInformation = generalAnnotation.getElement("productInformation");
        MetadataElement antennaPattern = product.getElement("antennaPattern");
        MetadataElement antennaPatternList = antennaPattern.getElement("antennaPatternList");
        subSwath.firstLineTime = Sentinel1Utils.getTime(imageInformation, "productFirstLineUtcTime").getMJD() * 86400.0;
        subSwath.lastLineTime = Sentinel1Utils.getTime(imageInformation, "productLastLineUtcTime").getMJD() * 86400.0;
        subSwath.ascendingNodeTime = Sentinel1Utils.getTime(imageInformation, "ascendingNodeTime").getMJD() * 86400.0;
        subSwath.numOfSamples = Integer.parseInt(imageInformation.getAttributeString("numberOfSamples"));
        subSwath.numOfLines = Integer.parseInt(imageInformation.getAttributeString("numberOfLines"));
        subSwath.azimuthTimeInterval = Double.parseDouble(imageInformation.getAttributeString("azimuthTimeInterval"));
        subSwath.rangePixelSpacing = Double.parseDouble(imageInformation.getAttributeString("rangePixelSpacing"));
        subSwath.azimuthPixelSpacing = Double.parseDouble(imageInformation.getAttributeString("azimuthPixelSpacing"));
        subSwath.slrTimeToFirstPixel = Double.parseDouble(imageInformation.getAttributeString("slantRangeTime")) / 2.0;
        subSwath.slrTimeToLastPixel = subSwath.slrTimeToFirstPixel + (double)(subSwath.numOfSamples - 1) * subSwath.rangePixelSpacing / 2.99792458E8;
        subSwath.numOfBursts = Integer.parseInt(burstList.getAttributeString("count"));
        subSwath.linesPerBurst = Integer.parseInt(swathTiming.getAttributeString("linesPerBurst"));
        subSwath.samplesPerBurst = Integer.parseInt(swathTiming.getAttributeString("samplesPerBurst"));
        subSwath.radarFrequency = Double.parseDouble(productInformation.getAttributeString("radarFrequency"));
        subSwath.rangeSamplingRate = Double.parseDouble(productInformation.getAttributeString("rangeSamplingRate"));
        subSwath.azimuthSteeringRate = Double.parseDouble(productInformation.getAttributeString("azimuthSteeringRate"));
        subSwath.burstFirstLineTime = new double[subSwath.numOfBursts];
        subSwath.burstLastLineTime = new double[subSwath.numOfBursts];
        subSwath.burstFirstValidLineTime = new double[subSwath.numOfBursts];
        subSwath.burstLastValidLineTime = new double[subSwath.numOfBursts];
        subSwath.firstValidSample = new int[subSwath.numOfBursts][];
        subSwath.lastValidSample = new int[subSwath.numOfBursts][];
        subSwath.firstValidLine = new int[subSwath.numOfBursts];
        subSwath.lastValidLine = new int[subSwath.numOfBursts];
        subSwath.firstValidPixel = 0;
        subSwath.lastValidPixel = subSwath.numOfSamples;
        int k = 0;
        if (subSwath.numOfBursts > 0) {
            MetadataElement[] burstListElem;
            int firstValidPixel = 0;
            int lastValidPixel = subSwath.numOfSamples;
            for (MetadataElement metadataElement : burstListElem = burstList.getElements()) {
                int lineIdx;
                subSwath.burstFirstLineTime[k] = Sentinel1Utils.getTime(metadataElement, "azimuthTime").getMJD() * 86400.0;
                subSwath.burstLastLineTime[k] = subSwath.burstFirstLineTime[k] + (double)(subSwath.linesPerBurst - 1) * subSwath.azimuthTimeInterval;
                MetadataElement firstValidSampleElem = metadataElement.getElement("firstValidSample");
                MetadataElement lastValidSampleElem = metadataElement.getElement("lastValidSample");
                subSwath.firstValidSample[k] = Sentinel1Utils.getIntArray(firstValidSampleElem, "firstValidSample");
                subSwath.lastValidSample[k] = Sentinel1Utils.getIntArray(lastValidSampleElem, "lastValidSample");
                int firstValidLineIdx = -1;
                int lastValidLineIdx = -1;
                for (lineIdx = 0; lineIdx < subSwath.firstValidSample[k].length; ++lineIdx) {
                    if (subSwath.firstValidSample[k][lineIdx] == -1) continue;
                    if (subSwath.firstValidSample[k][lineIdx] > firstValidPixel) {
                        firstValidPixel = subSwath.firstValidSample[k][lineIdx];
                    }
                    if (firstValidLineIdx == -1) {
                        firstValidLineIdx = lineIdx;
                        lastValidLineIdx = lineIdx;
                        continue;
                    }
                    ++lastValidLineIdx;
                }
                for (lineIdx = 0; lineIdx < subSwath.lastValidSample[k].length; ++lineIdx) {
                    if (subSwath.lastValidSample[k][lineIdx] == -1 || subSwath.lastValidSample[k][lineIdx] >= lastValidPixel) continue;
                    lastValidPixel = subSwath.lastValidSample[k][lineIdx];
                }
                subSwath.burstFirstValidLineTime[k] = subSwath.burstFirstLineTime[k] + (double)firstValidLineIdx * subSwath.azimuthTimeInterval;
                subSwath.burstLastValidLineTime[k] = subSwath.burstFirstLineTime[k] + (double)lastValidLineIdx * subSwath.azimuthTimeInterval;
                subSwath.firstValidLine[k] = firstValidLineIdx;
                subSwath.lastValidLine[k] = lastValidLineIdx;
                ++k;
            }
            subSwath.firstValidPixel = firstValidPixel;
            subSwath.lastValidPixel = lastValidPixel;
            subSwath.firstValidLineTime = subSwath.burstFirstValidLineTime[0];
            subSwath.lastValidLineTime = subSwath.burstLastValidLineTime[subSwath.numOfBursts - 1];
        }
        subSwath.slrTimeToFirstValidPixel = subSwath.slrTimeToFirstPixel + (double)subSwath.firstValidPixel * subSwath.rangePixelSpacing / 2.99792458E8;
        subSwath.slrTimeToLastValidPixel = subSwath.slrTimeToFirstPixel + (double)subSwath.lastValidPixel * subSwath.rangePixelSpacing / 2.99792458E8;
        MetadataElement geolocationGrid = product.getElement("geolocationGrid");
        MetadataElement geolocationGridPointList = geolocationGrid.getElement("geolocationGridPointList");
        int numOfGeoLocationGridPoints = Integer.parseInt(geolocationGridPointList.getAttributeString("count"));
        MetadataElement[] geolocationGridPointListElem = geolocationGridPointList.getElements();
        int numOfGeoPointsPerLine = 0;
        int line = 0;
        for (MetadataElement listElem : geolocationGridPointListElem) {
            if (numOfGeoPointsPerLine == 0) {
                line = Integer.parseInt(listElem.getAttributeString("line"));
                ++numOfGeoPointsPerLine;
                continue;
            }
            if (line != Integer.parseInt(listElem.getAttributeString("line"))) break;
            ++numOfGeoPointsPerLine;
        }
        int n2 = numOfGeoLocationGridPoints / numOfGeoPointsPerLine;
        boolean missingTiePoints = false;
        int firstMissingLineIdx = -1;
        if (n2 <= subSwath.numOfBursts) {
            missingTiePoints = true;
            firstMissingLineIdx = n2;
            n = subSwath.numOfBursts + 1;
        }
        subSwath.numOfGeoLines = n;
        subSwath.numOfGeoPointsPerLine = numOfGeoPointsPerLine;
        subSwath.azimuthTime = new double[n][numOfGeoPointsPerLine];
        subSwath.slantRangeTime = new double[n][numOfGeoPointsPerLine];
        subSwath.latitude = new double[n][numOfGeoPointsPerLine];
        subSwath.longitude = new double[n][numOfGeoPointsPerLine];
        subSwath.incidenceAngle = new double[n][numOfGeoPointsPerLine];
        k = 0;
        for (MetadataElement listElem : geolocationGridPointListElem) {
            int i = k / numOfGeoPointsPerLine;
            int j = k - i * numOfGeoPointsPerLine;
            subSwath.azimuthTime[i][j] = Sentinel1Utils.getTime(listElem, "azimuthTime").getMJD() * 86400.0;
            subSwath.slantRangeTime[i][j] = Double.parseDouble(listElem.getAttributeString("slantRangeTime")) / 2.0;
            subSwath.latitude[i][j] = Double.parseDouble(listElem.getAttributeString("latitude"));
            subSwath.longitude[i][j] = Double.parseDouble(listElem.getAttributeString("longitude"));
            subSwath.incidenceAngle[i][j] = Double.parseDouble(listElem.getAttributeString("incidenceAngle"));
            ++k;
        }
        if (missingTiePoints && firstMissingLineIdx >= 2) {
            for (int lineIdx = firstMissingLineIdx; lineIdx < n; ++lineIdx) {
                double mu = (double)(lineIdx - firstMissingLineIdx) + 2.0;
                for (int pixelIdx = 0; pixelIdx < numOfGeoPointsPerLine; ++pixelIdx) {
                    subSwath.azimuthTime[lineIdx][pixelIdx] = mu * subSwath.azimuthTime[firstMissingLineIdx - 1][pixelIdx] + (1.0 - mu) * subSwath.azimuthTime[firstMissingLineIdx - 2][pixelIdx];
                    subSwath.slantRangeTime[lineIdx][pixelIdx] = mu * subSwath.slantRangeTime[firstMissingLineIdx - 1][pixelIdx] + (1.0 - mu) * subSwath.slantRangeTime[firstMissingLineIdx - 2][pixelIdx];
                    subSwath.latitude[lineIdx][pixelIdx] = mu * subSwath.latitude[firstMissingLineIdx - 1][pixelIdx] + (1.0 - mu) * subSwath.latitude[firstMissingLineIdx - 2][pixelIdx];
                    subSwath.longitude[lineIdx][pixelIdx] = mu * subSwath.longitude[firstMissingLineIdx - 1][pixelIdx] + (1.0 - mu) * subSwath.longitude[firstMissingLineIdx - 2][pixelIdx];
                    subSwath.incidenceAngle[lineIdx][pixelIdx] = mu * subSwath.incidenceAngle[firstMissingLineIdx - 1][pixelIdx] + (1.0 - mu) * subSwath.incidenceAngle[firstMissingLineIdx - 2][pixelIdx];
                }
            }
        }
        int numAPRecords = Integer.parseInt(antennaPatternList.getAttributeString("count"));
        subSwath.apSlantRangeTime = new double[numAPRecords][];
        subSwath.apElevationAngle = new double[numAPRecords][];
        k = 0;
        if (numAPRecords > 0) {
            MetadataElement[] antennaPatternListElem;
            for (MetadataElement listElem : antennaPatternListElem = antennaPatternList.getElements()) {
                MetadataElement slantRangeTimeElem = listElem.getElement("slantRangeTime");
                MetadataElement elevationAngleElem = listElem.getElement("elevationAngle");
                subSwath.apSlantRangeTime[k] = Sentinel1Utils.getDoubleArray(slantRangeTimeElem, "slantRangeTime");
                subSwath.apElevationAngle[k] = Sentinel1Utils.getDoubleArray(elevationAngleElem, "elevationAngle");
                ++k;
            }
        }
    }

    private void getProductOrbit() {
        OrbitStateVector[] orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
        this.orbit = new OrbitStateVectors(orbitStateVectors);
    }

    public OrbitStateVectors getOrbit() {
        if (this.orbit == null) {
            this.getProductOrbit();
        }
        return this.orbit;
    }

    private void getSubSwathNoiseVectors() {
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            for (String pol : this.polarizations) {
                if (pol == null) continue;
                Band srcBand = this.getSourceBand(this.subSwath[i].subSwathName, pol);
                NoiseVector[] noiseVectors = this.getNoiseVector(srcBand);
                this.subSwath[i].noise.put(pol, noiseVectors);
            }
        }
    }

    private Band getSourceBand(String subSwathName, String polarization) {
        Band[] sourceBands;
        for (Band band : sourceBands = this.sourceProduct.getBands()) {
            if (!band.getName().contains(subSwathName + '_' + polarization)) continue;
            return band;
        }
        return null;
    }

    private NoiseVector[] getNoiseVector(Band band) {
        MetadataElement bandAbsMetadata = AbstractMetadata.getBandAbsMetadata((MetadataElement)this.absRoot, (Band)band);
        String annotation = bandAbsMetadata.getAttributeString("annotation");
        MetadataElement noiseElem = this.origProdRoot.getElement("noise");
        MetadataElement bandNoise = noiseElem.getElement(annotation);
        MetadataElement noise = bandNoise.getElement("noise");
        MetadataElement noiseVectorListElem = noise.getElement("noiseVectorList");
        MetadataElement[] list = noiseVectorListElem.getElements();
        ArrayList<NoiseVector> noiseVectorList = new ArrayList<NoiseVector>(5);
        for (MetadataElement noiseVectorElem : list) {
            ProductData.UTC time = Sentinel1Utils.getTime(noiseVectorElem, "azimuthTime");
            int line = Integer.parseInt(noiseVectorElem.getAttributeString("line"));
            MetadataElement pixelElem = noiseVectorElem.getElement("pixel");
            String pixel = pixelElem.getAttributeString("pixel");
            int count = Integer.parseInt(pixelElem.getAttributeString("count"));
            MetadataElement noiseLutElem = noiseVectorElem.getElement("noiseLut");
            String noiseLUT = noiseLutElem.getAttributeString("noiseLut");
            int[] pixelArray = new int[count];
            float[] noiseLUTArray = new float[count];
            Sentinel1Utils.addToArray(pixelArray, 0, pixel, " ");
            Sentinel1Utils.addToArray(noiseLUTArray, 0, noiseLUT, " ");
            noiseVectorList.add(new NoiseVector(time, line, pixelArray, noiseLUTArray));
        }
        return noiseVectorList.toArray(new NoiseVector[noiseVectorList.size()]);
    }

    private void getSubSwathCalibrationVectors(boolean outputSigmaBand, boolean outputBetaBand, boolean outputGammaBand, boolean outputDNBand) {
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            for (String pol : this.polarizations) {
                if (pol == null) continue;
                CalibrationVector[] calibrationVectors = this.getCalibrationVector(i + 1, pol, outputSigmaBand, outputBetaBand, outputGammaBand, outputDNBand);
                this.subSwath[i].calibration.put(pol, calibrationVectors);
            }
        }
    }

    private CalibrationVector[] getCalibrationVector(int subSwathIndex, String polarization, boolean outputSigmaBand, boolean outputBetaBand, boolean outputGammaBand, boolean outputDNBand) {
        MetadataElement calibrationVectorListElem = this.getCalibrationVectorList(subSwathIndex, polarization);
        MetadataElement[] list = calibrationVectorListElem.getElements();
        ArrayList<CalibrationVector> calibrationVectorList = new ArrayList<CalibrationVector>(5);
        for (MetadataElement calibrationVectorElem : list) {
            ProductData.UTC time = Sentinel1Utils.getTime(calibrationVectorElem, "azimuthTime");
            int line = Integer.parseInt(calibrationVectorElem.getAttributeString("line"));
            MetadataElement pixelElem = calibrationVectorElem.getElement("pixel");
            String pixel = pixelElem.getAttributeString("pixel");
            int count = Integer.parseInt(pixelElem.getAttributeString("count"));
            int[] pixelArray = new int[count];
            Sentinel1Utils.addToArray(pixelArray, 0, pixel, " ");
            float[] sigmaNoughtArray = null;
            if (outputSigmaBand) {
                MetadataElement sigmaNoughtElem = calibrationVectorElem.getElement("sigmaNought");
                String sigmaNought = sigmaNoughtElem.getAttributeString("sigmaNought");
                sigmaNoughtArray = new float[count];
                Sentinel1Utils.addToArray(sigmaNoughtArray, 0, sigmaNought, " ");
            }
            float[] betaNoughtArray = null;
            if (outputBetaBand) {
                MetadataElement betaNoughtElem = calibrationVectorElem.getElement("betaNought");
                String betaNought = betaNoughtElem.getAttributeString("betaNought");
                betaNoughtArray = new float[count];
                Sentinel1Utils.addToArray(betaNoughtArray, 0, betaNought, " ");
            }
            float[] gammaArray = null;
            if (outputGammaBand) {
                MetadataElement gammaElem = calibrationVectorElem.getElement("gamma");
                String gamma = gammaElem.getAttributeString("gamma");
                gammaArray = new float[count];
                Sentinel1Utils.addToArray(gammaArray, 0, gamma, " ");
            }
            float[] dnArray = null;
            if (outputDNBand) {
                MetadataElement dnElem = calibrationVectorElem.getElement("dn");
                String dn = dnElem.getAttributeString("dn");
                dnArray = new float[count];
                Sentinel1Utils.addToArray(dnArray, 0, dn, " ");
            }
            calibrationVectorList.add(new CalibrationVector(time, line, pixelArray, sigmaNoughtArray, betaNoughtArray, gammaArray, dnArray));
        }
        return calibrationVectorList.toArray(new CalibrationVector[calibrationVectorList.size()]);
    }

    private void computeRangeDependentDopplerRate() {
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            AzimuthFmRate[] azFmRateList = this.getAzimuthFmRateList(this.subSwath[s].subSwathName);
            this.subSwath[s].rangeDependDopplerRate = new double[this.subSwath[s].numOfBursts][this.subSwath[s].samplesPerBurst];
            for (int b = 0; b < this.subSwath[s].numOfBursts; ++b) {
                for (int x = 0; x < this.subSwath[s].samplesPerBurst; ++x) {
                    double slrt = this.getSlantRangeTime(x, s + 1) * 2.0;
                    double dt = slrt - azFmRateList[b].t0;
                    this.subSwath[s].rangeDependDopplerRate[b][x] = azFmRateList[b].c0 + azFmRateList[b].c1 * dt + azFmRateList[b].c2 * dt * dt;
                }
            }
        }
        this.isRangeDependDopplerRateAvailable = true;
    }

    private AzimuthFmRate[] getAzimuthFmRateList(String subSwathName) {
        MetadataElement subSwathMetadata = this.getSubSwathMetadata(subSwathName);
        MetadataElement product = subSwathMetadata.getElement("product");
        MetadataElement generalAnnotation = product.getElement("generalAnnotation");
        MetadataElement azimuthFmRateList = generalAnnotation.getElement("azimuthFmRateList");
        int count = Integer.parseInt(azimuthFmRateList.getAttributeString("count"));
        AzimuthFmRate[] azFmRateList = null;
        int k = 0;
        if (count > 0) {
            MetadataElement[] azFmRateListElem;
            azFmRateList = new AzimuthFmRate[count];
            for (MetadataElement listElem : azFmRateListElem = azimuthFmRateList.getElements()) {
                azFmRateList[k] = new AzimuthFmRate();
                azFmRateList[k].time = Sentinel1Utils.getTime(listElem, "azimuthTime").getMJD() * 86400.0;
                azFmRateList[k].t0 = Double.parseDouble(listElem.getAttributeString("t0"));
                MetadataElement azimuthFmRatePolynomialElem = listElem.getElement("azimuthFmRatePolynomial");
                if (azimuthFmRatePolynomialElem != null) {
                    double[] coeffs = Sentinel1Utils.getDoubleArray(azimuthFmRatePolynomialElem, "azimuthFmRatePolynomial");
                    azFmRateList[k].c0 = coeffs[0];
                    azFmRateList[k].c1 = coeffs[1];
                    azFmRateList[k].c2 = coeffs[2];
                } else {
                    azFmRateList[k].c0 = Double.parseDouble(listElem.getAttributeString("c0"));
                    azFmRateList[k].c1 = Double.parseDouble(listElem.getAttributeString("c1"));
                    azFmRateList[k].c2 = Double.parseDouble(listElem.getAttributeString("c2"));
                }
                ++k;
            }
        }
        return azFmRateList;
    }

    public void computeDopplerRate() {
        if (this.orbit == null) {
            this.getProductOrbit();
        }
        if (!this.isRangeDependDopplerRateAvailable) {
            this.computeRangeDependentDopplerRate();
        }
        double waveLength = 2.99792458E8 / this.subSwath[0].radarFrequency;
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            double azTime = (this.subSwath[s].firstLineTime + this.subSwath[s].lastLineTime) / 2.0;
            this.subSwath[s].dopplerRate = new double[this.subSwath[s].numOfBursts][this.subSwath[s].samplesPerBurst];
            for (int b = 0; b < this.subSwath[s].numOfBursts; ++b) {
                double v = this.getVelocity(azTime / 86400.0);
                double steeringRate = this.subSwath[s].azimuthSteeringRate * (Math.PI / 180);
                double krot = 2.0 * v * steeringRate / waveLength;
                for (int x = 0; x < this.subSwath[s].samplesPerBurst; ++x) {
                    this.subSwath[s].dopplerRate[b][x] = this.subSwath[s].rangeDependDopplerRate[b][x] * krot / (this.subSwath[s].rangeDependDopplerRate[b][x] - krot);
                }
            }
        }
    }

    private double getVelocity(double time) {
        PosVector velocity = this.orbit.getVelocity(time);
        return Math.sqrt(velocity.x * velocity.x + velocity.y * velocity.y + velocity.z * velocity.z);
    }

    public void computeReferenceTime() {
        if (!this.isDopplerCentroidAvailable) {
            this.computeDopplerCentroid();
        }
        if (!this.isRangeDependDopplerRateAvailable) {
            this.computeRangeDependentDopplerRate();
        }
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            this.subSwath[s].referenceTime = new double[this.subSwath[s].numOfBursts][this.subSwath[s].samplesPerBurst];
            double tmp1 = (double)this.subSwath[s].linesPerBurst * this.subSwath[s].azimuthTimeInterval / 2.0;
            for (int b = 0; b < this.subSwath[s].numOfBursts; ++b) {
                double tmp2 = tmp1 + this.subSwath[s].dopplerCentroid[b][this.subSwath[s].firstValidPixel] / this.subSwath[s].rangeDependDopplerRate[b][this.subSwath[s].firstValidPixel];
                for (int x = 0; x < this.subSwath[s].samplesPerBurst; ++x) {
                    this.subSwath[s].referenceTime[b][x] = tmp2 - this.subSwath[s].dopplerCentroid[b][x] / this.subSwath[s].rangeDependDopplerRate[b][x];
                }
            }
        }
    }

    private void computeDopplerCentroid() {
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            DCPolynomial[] dcEstimateList = this.getDCEstimateList(this.subSwath[s].subSwathName);
            DCPolynomial[] dcBurstList = this.computeDCForBurstCenters(dcEstimateList, s + 1);
            this.subSwath[s].dopplerCentroid = new double[this.subSwath[s].numOfBursts][this.subSwath[s].samplesPerBurst];
            for (int b = 0; b < this.subSwath[s].numOfBursts; ++b) {
                for (int x = 0; x < this.subSwath[s].samplesPerBurst; ++x) {
                    double slrt = this.getSlantRangeTime(x, s + 1) * 2.0;
                    double dt = slrt - dcBurstList[b].t0;
                    double dcValue = 0.0;
                    for (int i = 0; i < dcBurstList[b].dataDcPolynomial.length; ++i) {
                        dcValue += dcBurstList[b].dataDcPolynomial[i] * FastMath.pow((double)dt, (int)i);
                    }
                    this.subSwath[s].dopplerCentroid[b][x] = dcValue;
                }
            }
        }
        this.isDopplerCentroidAvailable = true;
    }

    private DCPolynomial[] getDCEstimateList(String subSwathName) {
        MetadataElement subSwathMetadata = this.getSubSwathMetadata(subSwathName);
        MetadataElement product = subSwathMetadata.getElement("product");
        MetadataElement imageAnnotation = product.getElement("imageAnnotation");
        MetadataElement processingInformation = imageAnnotation.getElement("processingInformation");
        String dcMethod = processingInformation.getAttributeString("dcMethod");
        MetadataElement dopplerCentroid = product.getElement("dopplerCentroid");
        MetadataElement dcEstimateList = dopplerCentroid.getElement("dcEstimateList");
        int count = Integer.parseInt(dcEstimateList.getAttributeString("count"));
        DCPolynomial[] dcPolynomial = null;
        int k = 0;
        if (count > 0) {
            MetadataElement[] dcEstimateListElem;
            dcPolynomial = new DCPolynomial[count];
            for (MetadataElement listElem : dcEstimateListElem = dcEstimateList.getElements()) {
                dcPolynomial[k] = new DCPolynomial();
                dcPolynomial[k].time = Sentinel1Utils.getTime(listElem, "azimuthTime").getMJD() * 86400.0;
                dcPolynomial[k].t0 = listElem.getAttributeDouble("t0");
                if (dcMethod.contains("Data Analysis")) {
                    MetadataElement dataDcPolynomialElem = listElem.getElement("dataDcPolynomial");
                    dcPolynomial[k].dataDcPolynomial = Sentinel1Utils.getDoubleArray(dataDcPolynomialElem, "dataDcPolynomial");
                } else {
                    MetadataElement geometryDcPolynomialElem = listElem.getElement("geometryDcPolynomial");
                    dcPolynomial[k].dataDcPolynomial = Sentinel1Utils.getDoubleArray(geometryDcPolynomialElem, "geometryDcPolynomial");
                }
                ++k;
            }
        }
        return dcPolynomial;
    }

    private DCPolynomial[] computeDCForBurstCenters(DCPolynomial[] dcEstimateList, int subSwathIndex) {
        if (dcEstimateList.length >= this.subSwath[subSwathIndex - 1].numOfBursts) {
            return dcEstimateList;
        }
        DCPolynomial[] dcBurstList = new DCPolynomial[this.subSwath[subSwathIndex - 1].numOfBursts];
        for (int b = 0; b < this.subSwath[subSwathIndex - 1].numOfBursts; ++b) {
            if (b < dcEstimateList.length) {
                dcBurstList[b] = dcEstimateList[b];
                continue;
            }
            double centerTime = 0.5 * (this.subSwath[subSwathIndex - 1].burstFirstLineTime[b] + this.subSwath[subSwathIndex - 1].burstLastLineTime[b]);
            dcBurstList[b] = this.computeDC(centerTime, dcEstimateList);
        }
        return dcBurstList;
    }

    private DCPolynomial computeDC(double centerTime, DCPolynomial[] dcEstimateList) {
        int i0 = 0;
        int i1 = 0;
        if (centerTime < dcEstimateList[0].time) {
            i0 = 0;
            i1 = 1;
        } else if (centerTime > dcEstimateList[dcEstimateList.length - 1].time) {
            i0 = dcEstimateList.length - 2;
            i1 = dcEstimateList.length - 1;
        } else {
            for (int i = 0; i < dcEstimateList.length - 1; ++i) {
                if (!(centerTime >= dcEstimateList[i].time) || !(centerTime < dcEstimateList[i + 1].time)) continue;
                i0 = i;
                i1 = i + 1;
                break;
            }
        }
        DCPolynomial dcPolynomial = new DCPolynomial();
        dcPolynomial.time = centerTime;
        dcPolynomial.t0 = dcEstimateList[i0].t0;
        dcPolynomial.dataDcPolynomial = new double[dcEstimateList[i0].dataDcPolynomial.length];
        double mu = (centerTime - dcEstimateList[i0].time) / (dcEstimateList[i1].time - dcEstimateList[i0].time);
        for (int j = 0; j < dcEstimateList[i0].dataDcPolynomial.length; ++j) {
            dcPolynomial.dataDcPolynomial[j] = (1.0 - mu) * dcEstimateList[i0].dataDcPolynomial[j] + mu * dcEstimateList[i1].dataDcPolynomial[j];
        }
        return dcPolynomial;
    }

    public double[][] computeDerampDemodPhase(SubSwathInfo[] subSwath, int subSwathIndex, int sBurstIndex, Rectangle rectangle) {
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int s = subSwathIndex - 1;
        double[][] phase = new double[h][w];
        int firstLineInBurst = sBurstIndex * subSwath[s].linesPerBurst;
        for (int y = y0; y < yMax; ++y) {
            int yy = y - y0;
            double ta = (double)(y - firstLineInBurst) * subSwath[s].azimuthTimeInterval;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                double kt = subSwath[s].dopplerRate[sBurstIndex][x];
                double deramp = -Math.PI * kt * FastMath.pow((double)(ta - subSwath[s].referenceTime[sBurstIndex][x]), (int)2);
                double demod = Math.PI * -2 * subSwath[s].dopplerCentroid[sBurstIndex][x] * ta;
                phase[yy][xx] = deramp + demod;
            }
        }
        return phase;
    }

    public double[][] computeDerampPhase(SubSwathInfo[] subSwath, int subSwathIndex, int burstIndex, Rectangle rectangle) {
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int s = subSwathIndex - 1;
        double[][] phase = new double[h][w];
        int firstLineInBurst = burstIndex * subSwath[s].linesPerBurst;
        for (int y = y0; y < yMax; ++y) {
            int yy = y - y0;
            double ta = (double)(y - firstLineInBurst) * subSwath[s].azimuthTimeInterval;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                double kt = subSwath[s].dopplerRate[burstIndex][x];
                phase[yy][xx] = -Math.PI * kt * FastMath.pow((double)(ta - subSwath[s].referenceTime[burstIndex][x]), (int)2);
            }
        }
        return phase;
    }

    public double[][] computeDemodPhase(SubSwathInfo[] subSwath, int subSwathIndex, int sBurstIndex, Rectangle rectangle) {
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int s = subSwathIndex - 1;
        double[][] phase = new double[h][w];
        int firstLineInBurst = sBurstIndex * subSwath[s].linesPerBurst;
        for (int y = y0; y < yMax; ++y) {
            int yy = y - y0;
            double ta = (double)(y - firstLineInBurst) * subSwath[s].azimuthTimeInterval;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                double kt = subSwath[s].dopplerRate[sBurstIndex][x];
                phase[yy][xx] = Math.PI * -2 * subSwath[s].dopplerCentroid[sBurstIndex][x] * ta;
            }
        }
        return phase;
    }

    private MetadataElement getCalibrationVectorList(int subSwathIndex, String polarization) {
        Band srcBand = this.getSourceBand(this.subSwath[subSwathIndex - 1].subSwathName, polarization);
        MetadataElement bandAbsMetadata = AbstractMetadata.getBandAbsMetadata((MetadataElement)this.absRoot, (Band)srcBand);
        String annotation = bandAbsMetadata.getAttributeString("annotation");
        MetadataElement calibrationElem = this.origProdRoot.getElement("calibration");
        MetadataElement bandCalibration = calibrationElem.getElement(annotation);
        MetadataElement calibration = bandCalibration.getElement("calibration");
        return calibration.getElement("calibrationVectorList");
    }

    public float[] getCalibrationVector(int subSwathIndex, String polarization, int vectorIndex, String vectorName) {
        MetadataElement calibrationVectorListElem = this.getCalibrationVectorList(subSwathIndex, polarization);
        MetadataElement[] list = calibrationVectorListElem.getElements();
        MetadataElement vectorElem = list[vectorIndex].getElement(vectorName);
        String vectorStr = vectorElem.getAttributeString(vectorName);
        int count = Integer.parseInt(vectorElem.getAttributeString("count"));
        float[] vectorArray = new float[count];
        Sentinel1Utils.addToArray(vectorArray, 0, vectorStr, " ");
        return vectorArray;
    }

    public int[] getCalibrationPixel(int subSwathIndex, String polarization, int vectorIndex) {
        MetadataElement calibrationVectorListElem = this.getCalibrationVectorList(subSwathIndex, polarization);
        MetadataElement[] list = calibrationVectorListElem.getElements();
        MetadataElement pixelElem = list[vectorIndex].getElement("pixel");
        String pixel = pixelElem.getAttributeString("pixel");
        int count = Integer.parseInt(pixelElem.getAttributeString("count"));
        int[] pixelArray = new int[count];
        Sentinel1Utils.addToArray(pixelArray, 0, pixel, " ");
        return pixelArray;
    }

    public static NoiseVector[] getNoiseVector(MetadataElement noiseVectorListElem) {
        MetadataElement[] list = noiseVectorListElem.getElements();
        ArrayList<NoiseVector> noiseVectorList = new ArrayList<NoiseVector>(5);
        for (MetadataElement noiseVectorElem : list) {
            MetadataAttribute attribute;
            ProductData.UTC time = Sentinel1Utils.getTime(noiseVectorElem, "azimuthTime");
            int line = Integer.parseInt(noiseVectorElem.getAttributeString("line"));
            MetadataElement pixelElem = noiseVectorElem.getElement("pixel");
            String pixel = pixelElem.getAttributeString("pixel");
            int count = Integer.parseInt(pixelElem.getAttributeString("count"));
            MetadataElement noiseLutElem = noiseVectorElem.getElement("noiseLut");
            if (noiseLutElem == null) {
                noiseLutElem = noiseVectorElem.getElement("noiseRangeLut");
            }
            if ((attribute = noiseLutElem.getAttribute("noiseLut")) == null) {
                attribute = noiseLutElem.getAttribute("noiseRangeLut");
            }
            String noiseLUT = attribute.getData().getElemString();
            int[] pixelArray = new int[count];
            float[] noiseLUTArray = new float[count];
            Sentinel1Utils.addToArray(pixelArray, 0, pixel, " ");
            Sentinel1Utils.addToArray(noiseLUTArray, 0, noiseLUT, " ");
            noiseVectorList.add(new NoiseVector(time, line, pixelArray, noiseLUTArray));
        }
        return noiseVectorList.toArray(new NoiseVector[noiseVectorList.size()]);
    }

    public static NoiseAzimuthVector[] getAzimuthNoiseVector(MetadataElement azimNoiseVectorListElem) {
        MetadataElement[] list = azimNoiseVectorListElem.getElements();
        ArrayList<NoiseAzimuthVector> noiseVectorList = new ArrayList<NoiseAzimuthVector>(5);
        for (MetadataElement noiseVectorElem : list) {
            MetadataElement lineElem = noiseVectorElem.getElement("line");
            String line = lineElem.getAttributeString("line");
            int count = Integer.parseInt(lineElem.getAttributeString("count"));
            MetadataElement noiseLutElem = noiseVectorElem.getElement("noiseAzimuthLut");
            MetadataAttribute attribute = noiseLutElem.getAttribute("noiseAzimuthLut");
            String noiseLUT = attribute.getData().getElemString();
            int[] lineArray = new int[count];
            float[] noiseLUTArray = new float[count];
            Sentinel1Utils.addToArray(lineArray, 0, line, " ");
            Sentinel1Utils.addToArray(noiseLUTArray, 0, noiseLUT, " ");
            String swath = noiseVectorElem.containsAttribute("swath") ? noiseVectorElem.getAttributeString("swath") : null;
            int firstAzimuthLine = noiseVectorElem.containsAttribute("firstAzimuthLine") ? Integer.parseInt(noiseVectorElem.getAttributeString("firstAzimuthLine")) : -1;
            int firstRangeSample = noiseVectorElem.containsAttribute("firstRangeSample") ? Integer.parseInt(noiseVectorElem.getAttributeString("firstRangeSample")) : -1;
            int lastAzimuthLine = noiseVectorElem.containsAttribute("lastAzimuthLine") ? Integer.parseInt(noiseVectorElem.getAttributeString("lastAzimuthLine")) : -1;
            int lastRangeSample = noiseVectorElem.containsAttribute("lastRangeSample") ? Integer.parseInt(noiseVectorElem.getAttributeString("lastRangeSample")) : -1;
            noiseVectorList.add(new NoiseAzimuthVector(swath, firstAzimuthLine, firstRangeSample, lastAzimuthLine, lastRangeSample, lineArray, noiseLUTArray));
        }
        return noiseVectorList.toArray(new NoiseAzimuthVector[noiseVectorList.size()]);
    }

    public static CalibrationVector[] getCalibrationVector(MetadataElement calibrationVectorListElem, boolean outputSigmaBand, boolean outputBetaBand, boolean outputGammaBand, boolean outputDNBand) {
        MetadataElement[] list = calibrationVectorListElem.getElements();
        ArrayList<CalibrationVector> calibrationVectorList = new ArrayList<CalibrationVector>(5);
        for (MetadataElement calibrationVectorElem : list) {
            ProductData.UTC time = Sentinel1Utils.getTime(calibrationVectorElem, "azimuthTime");
            int line = Integer.parseInt(calibrationVectorElem.getAttributeString("line"));
            MetadataElement pixelElem = calibrationVectorElem.getElement("pixel");
            String pixel = pixelElem.getAttributeString("pixel");
            int count = Integer.parseInt(pixelElem.getAttributeString("count"));
            int[] pixelArray = new int[count];
            Sentinel1Utils.addToArray(pixelArray, 0, pixel, " ");
            float[] sigmaNoughtArray = null;
            if (outputSigmaBand) {
                MetadataElement sigmaNoughtElem = calibrationVectorElem.getElement("sigmaNought");
                String sigmaNought = sigmaNoughtElem.getAttributeString("sigmaNought");
                sigmaNoughtArray = new float[count];
                Sentinel1Utils.addToArray(sigmaNoughtArray, 0, sigmaNought, " ");
            }
            float[] betaNoughtArray = null;
            if (outputBetaBand) {
                MetadataElement betaNoughtElem = calibrationVectorElem.getElement("betaNought");
                String betaNought = betaNoughtElem.getAttributeString("betaNought");
                betaNoughtArray = new float[count];
                Sentinel1Utils.addToArray(betaNoughtArray, 0, betaNought, " ");
            }
            float[] gammaArray = null;
            if (outputGammaBand) {
                MetadataElement gammaElem = calibrationVectorElem.getElement("gamma");
                String gamma = gammaElem.getAttributeString("gamma");
                gammaArray = new float[count];
                Sentinel1Utils.addToArray(gammaArray, 0, gamma, " ");
            }
            float[] dnArray = null;
            if (outputDNBand) {
                MetadataElement dnElem = calibrationVectorElem.getElement("dn");
                String dn = dnElem.getAttributeString("dn");
                dnArray = new float[count];
                Sentinel1Utils.addToArray(dnArray, 0, dn, " ");
            }
            calibrationVectorList.add(new CalibrationVector(time, line, pixelArray, sigmaNoughtArray, betaNoughtArray, gammaArray, dnArray));
        }
        return calibrationVectorList.toArray(new CalibrationVector[calibrationVectorList.size()]);
    }

    public static String[] getProductPolarizations(MetadataElement absRoot) {
        String[] sourceBandNames;
        MetadataElement[] elems = absRoot.getElements();
        ArrayList<String> polList = new ArrayList<String>(4);
        for (MetadataElement elem : elems) {
            String pol;
            if (!elem.getName().contains("Band_") || (pol = elem.getAttributeString("polarization", null)) == null || polList.contains(pol)) continue;
            polList.add(pol);
        }
        if (polList.size() > 0) {
            Object[] polArray = polList.toArray(new String[polList.size()]);
            Arrays.sort(polArray);
            return polArray;
        }
        Product sourceProduct = absRoot.getProduct();
        for (String bandName : sourceBandNames = sourceProduct.getBandNames()) {
            if (bandName.contains("HH")) {
                if (polList.contains("HH")) continue;
                polList.add("HH");
                continue;
            }
            if (bandName.contains("HV")) {
                if (polList.contains("HV")) continue;
                polList.add("HV");
                continue;
            }
            if (bandName.contains("VH")) {
                if (polList.contains("VH")) continue;
                polList.add("VH");
                continue;
            }
            if (!bandName.contains("VV") || polList.contains("VV")) continue;
            polList.add("VV");
        }
        Object[] polArray = polList.toArray(new String[polList.size()]);
        Arrays.sort(polArray);
        return polArray;
    }

    public static String[] getProductSubswaths(MetadataElement absRoot) {
        String[] sourceBandNames;
        MetadataElement[] elems = absRoot.getElements();
        ArrayList<String> swathList = new ArrayList<String>(4);
        for (MetadataElement elem : elems) {
            String swath;
            if (!elem.getName().contains("Band_") || (swath = elem.getAttributeString("swath", null)) == null || swathList.contains(swath)) continue;
            swathList.add(swath);
        }
        if (swathList.size() > 0) {
            return swathList.toArray(new String[swathList.size()]);
        }
        Product sourceProduct = absRoot.getProduct();
        String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
        for (String bandName : sourceBandNames = sourceProduct.getBandNames()) {
            int idx;
            String subSwathName;
            if (!bandName.contains(acquisitionMode) || swathList.contains(subSwathName = bandName.substring(idx = bandName.indexOf(acquisitionMode), idx + 3))) continue;
            swathList.add(subSwathName);
        }
        return swathList.toArray(new String[swathList.size()]);
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag) {
        String start = elem.getAttributeString(tag, "-");
        start = start.replace("T", "_");
        return AbstractMetadata.parseUTC((String)start, (DateFormat)ProductData.UTC.createDateFormat((String)"yyyy-MM-dd_HH:mm:ss"));
    }

    public String getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public String[] getPolarizations() {
        return this.polarizations;
    }

    public String[] getSubSwathNames() {
        return this.subSwathNames;
    }

    public SubSwathInfo[] getSubSwath() {
        return this.subSwath;
    }

    public int getNumOfSubSwath() {
        return this.numOfSubSwath;
    }

    public int getNumOfBursts(String subswath) {
        for (SubSwathInfo aSubSwathInfo : this.subSwath) {
            if (!aSubSwathInfo.subSwathName.contains(subswath)) continue;
            return aSubSwathInfo.numOfBursts;
        }
        return 0;
    }

    private static boolean contains(String[] list, String tag) {
        for (String s : list) {
            if (!s.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public double getAzimuthTime(int y, int subSwathIndex) {
        int burstIdx = y / this.subSwath[subSwathIndex - 1].linesPerBurst;
        int lineIdxInBurst = y - burstIdx * this.subSwath[subSwathIndex - 1].linesPerBurst;
        return this.subSwath[subSwathIndex - 1].burstFirstLineTime[burstIdx] + (double)lineIdxInBurst * this.subSwath[subSwathIndex - 1].azimuthTimeInterval;
    }

    public double getSlantRangeTime(int x, int subSwathIndex) {
        return this.subSwath[subSwathIndex - 1].slrTimeToFirstPixel + (double)x * this.subSwath[subSwathIndex - 1].rangePixelSpacing / 2.99792458E8;
    }

    public int getSubSwathIndex(double slrTime) {
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            double startTime = i == 0 ? this.subSwath[i].slrTimeToFirstPixel : 0.5 * (this.subSwath[i].slrTimeToFirstPixel + this.subSwath[i - 1].slrTimeToLastPixel);
            double endTime = i == this.numOfSubSwath - 1 ? this.subSwath[i].slrTimeToLastPixel : 0.5 * (this.subSwath[i].slrTimeToLastPixel + this.subSwath[i + 1].slrTimeToFirstPixel);
            if (!(slrTime >= startTime) || !(slrTime <= endTime)) continue;
            return i + 1;
        }
        return 0;
    }

    public void computeIndex(double azTime, double slrTime, int subSwathIndex, Index index) {
        int j0 = -1;
        int j1 = -1;
        double muX = 0.0;
        if (slrTime < this.subSwath[subSwathIndex - 1].slantRangeTime[0][0]) {
            j0 = 0;
            j1 = 1;
        } else if (slrTime > this.subSwath[subSwathIndex - 1].slantRangeTime[0][this.subSwath[subSwathIndex - 1].numOfGeoPointsPerLine - 1]) {
            j0 = this.subSwath[subSwathIndex - 1].numOfGeoPointsPerLine - 2;
            j1 = this.subSwath[subSwathIndex - 1].numOfGeoPointsPerLine - 1;
        } else {
            for (int j = 0; j < this.subSwath[subSwathIndex - 1].numOfGeoPointsPerLine - 1; ++j) {
                if (!(this.subSwath[subSwathIndex - 1].slantRangeTime[0][j] <= slrTime) || !(this.subSwath[subSwathIndex - 1].slantRangeTime[0][j + 1] > slrTime)) continue;
                j0 = j;
                j1 = j + 1;
                break;
            }
        }
        muX = (slrTime - this.subSwath[subSwathIndex - 1].slantRangeTime[0][j0]) / (this.subSwath[subSwathIndex - 1].slantRangeTime[0][j1] - this.subSwath[subSwathIndex - 1].slantRangeTime[0][j0]);
        int i0 = -1;
        int i1 = -1;
        double muY = 0.0;
        for (int i = 0; i < this.subSwath[subSwathIndex - 1].numOfGeoLines - 1; ++i) {
            double i0AzTime = (1.0 - muX) * this.subSwath[subSwathIndex - 1].azimuthTime[i][j0] + muX * this.subSwath[subSwathIndex - 1].azimuthTime[i][j1];
            double i1AzTime = (1.0 - muX) * this.subSwath[subSwathIndex - 1].azimuthTime[i + 1][j0] + muX * this.subSwath[subSwathIndex - 1].azimuthTime[i + 1][j1];
            if (!(i == 0 && azTime < i0AzTime || i == this.subSwath[subSwathIndex - 1].numOfGeoLines - 2 && azTime >= i1AzTime) && (!(i0AzTime <= azTime) || !(i1AzTime > azTime))) continue;
            i0 = i;
            i1 = i + 1;
            muY = (azTime - i0AzTime) / (i1AzTime - i0AzTime);
            break;
        }
        index.i0 = i0;
        index.i1 = i1;
        index.j0 = j0;
        index.j1 = j1;
        index.muX = muX;
        index.muY = muY;
    }

    public double getLatitude(double azimuthTime, double slantRangeTime) {
        Index index = new Index();
        int subSwathIndex = this.getSubSwathIndex(slantRangeTime);
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getLatitudeValue(index, subSwathIndex);
    }

    public double getLatitude(double azimuthTime, double slantRangeTime, int subSwathIndex) {
        Index index = new Index();
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getLatitudeValue(index, subSwathIndex);
    }

    public double getLongitude(double azimuthTime, double slantRangeTime) {
        Index index = new Index();
        int subSwathIndex = this.getSubSwathIndex(slantRangeTime);
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getLongitudeValue(index, subSwathIndex);
    }

    public double getLongitude(double azimuthTime, double slantRangeTime, int subSwathIndex) {
        Index index = new Index();
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getLongitudeValue(index, subSwathIndex);
    }

    public double getSlantRangeTime(double azimuthTime, double slantRangeTime) {
        Index index = new Index();
        int subSwathIndex = this.getSubSwathIndex(slantRangeTime);
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getSlantRangeTimeValue(index, subSwathIndex);
    }

    public double getIncidenceAngle(double azimuthTime, double slantRangeTime) {
        Index index = new Index();
        int subSwathIndex = this.getSubSwathIndex(slantRangeTime);
        this.computeIndex(azimuthTime, slantRangeTime, subSwathIndex, index);
        return this.getIncidenceAngleValue(index, subSwathIndex);
    }

    private double getLatitudeValue(Index index, int subSwathIndex) {
        double lat00 = this.subSwath[subSwathIndex - 1].latitude[index.i0][index.j0];
        double lat01 = this.subSwath[subSwathIndex - 1].latitude[index.i0][index.j1];
        double lat10 = this.subSwath[subSwathIndex - 1].latitude[index.i1][index.j0];
        double lat11 = this.subSwath[subSwathIndex - 1].latitude[index.i1][index.j1];
        return (1.0 - index.muY) * ((1.0 - index.muX) * lat00 + index.muX * lat01) + index.muY * ((1.0 - index.muX) * lat10 + index.muX * lat11);
    }

    private double getLongitudeValue(Index index, int subSwathIndex) {
        double lon00 = this.subSwath[subSwathIndex - 1].longitude[index.i0][index.j0];
        double lon01 = this.subSwath[subSwathIndex - 1].longitude[index.i0][index.j1];
        double lon10 = this.subSwath[subSwathIndex - 1].longitude[index.i1][index.j0];
        double lon11 = this.subSwath[subSwathIndex - 1].longitude[index.i1][index.j1];
        return (1.0 - index.muY) * ((1.0 - index.muX) * lon00 + index.muX * lon01) + index.muY * ((1.0 - index.muX) * lon10 + index.muX * lon11);
    }

    private double getSlantRangeTimeValue(Index index, int subSwathIndex) {
        double slrt00 = this.subSwath[subSwathIndex - 1].slantRangeTime[index.i0][index.j0];
        double slrt01 = this.subSwath[subSwathIndex - 1].slantRangeTime[index.i0][index.j1];
        double slrt10 = this.subSwath[subSwathIndex - 1].slantRangeTime[index.i1][index.j0];
        double slrt11 = this.subSwath[subSwathIndex - 1].slantRangeTime[index.i1][index.j1];
        return (1.0 - index.muY) * ((1.0 - index.muX) * slrt00 + index.muX * slrt01) + index.muY * ((1.0 - index.muX) * slrt10 + index.muX * slrt11);
    }

    private double getIncidenceAngleValue(Index index, int subSwathIndex) {
        double inc00 = this.subSwath[subSwathIndex - 1].incidenceAngle[index.i0][index.j0];
        double inc01 = this.subSwath[subSwathIndex - 1].incidenceAngle[index.i0][index.j1];
        double inc10 = this.subSwath[subSwathIndex - 1].incidenceAngle[index.i1][index.j0];
        double inc11 = this.subSwath[subSwathIndex - 1].incidenceAngle[index.i1][index.j1];
        return (1.0 - index.muY) * ((1.0 - index.muX) * inc00 + index.muX * inc01) + index.muY * ((1.0 - index.muX) * inc10 + index.muX * inc11);
    }

    public static void updateBandNames(MetadataElement absRoot, List<String> selectedPolList, String[] bandNames) {
        MetadataElement[] children;
        for (MetadataElement child : children = absRoot.getElements()) {
            String childName = child.getName();
            if (!childName.startsWith("Band_")) continue;
            String pol = childName.substring(childName.lastIndexOf("_") + 1);
            String sw_pol = childName.substring(childName.indexOf("_") + 1);
            if (selectedPolList.contains(pol)) {
                String bandNameArray = "";
                for (String bandName : bandNames) {
                    if (bandName.contains(sw_pol)) {
                        bandNameArray = bandNameArray + bandName + " ";
                        continue;
                    }
                    if (!bandName.contains(pol)) continue;
                    bandNameArray = bandNameArray + bandName + " ";
                }
                if (bandNameArray.isEmpty()) continue;
                child.setAttributeString("band_names", bandNameArray);
                continue;
            }
            absRoot.removeElement(child);
        }
    }

    private static int[] getIntArray(MetadataElement elem, String tag) {
        MetadataAttribute attribute = elem.getAttribute(tag);
        if (attribute == null) {
            throw new OperatorException(tag + " attribute not found");
        }
        int[] array = null;
        if (attribute.getDataType() == 41) {
            String dataStr = attribute.getData().getElemString();
            String[] items = dataStr.split(" ");
            array = new int[items.length];
            for (int i = 0; i < items.length; ++i) {
                try {
                    array[i] = Integer.parseInt(items[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new OperatorException("Failed in getting" + tag + " array");
                }
            }
        }
        return array;
    }

    private static double[] getDoubleArray(MetadataElement elem, String tag) {
        MetadataAttribute attribute = elem.getAttribute(tag);
        if (attribute == null) {
            throw new OperatorException(tag + " attribute not found");
        }
        double[] array = null;
        if (attribute.getData() instanceof ProductData.ASCII) {
            String dataStr = attribute.getData().getElemString();
            String[] items = dataStr.split(" ");
            array = new double[items.length];
            for (int i = 0; i < items.length; ++i) {
                try {
                    array[i] = Double.parseDouble(items[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new OperatorException("Failed in getting" + tag + " array");
                }
            }
        }
        return array;
    }

    private static int addToArray(int[] array, int index, String csvString, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(csvString, delim);
        while (tokenizer.hasMoreTokens()) {
            array[index++] = Integer.parseInt(tokenizer.nextToken());
        }
        return index;
    }

    private static int addToArray(float[] array, int index, String csvString, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(csvString, delim);
        while (tokenizer.hasMoreTokens()) {
            array[index++] = Float.parseFloat(tokenizer.nextToken());
        }
        return index;
    }

    private static final class Index {
        public int i0;
        public int i1;
        public int j0;
        public int j1;
        public double muX;
        public double muY;
    }

    public static final class CalibrationVector {
        public final double timeMJD;
        public final int line;
        public final int[] pixels;
        public final float[] sigmaNought;
        public final float[] betaNought;
        public final float[] gamma;
        public final float[] dn;

        public CalibrationVector(ProductData.UTC time, int line, int[] pixels, float[] sigmaNought, float[] betaNought, float[] gamma, float[] dn) {
            this.timeMJD = time.getMJD();
            this.line = line;
            this.pixels = pixels;
            this.sigmaNought = sigmaNought;
            this.betaNought = betaNought;
            this.gamma = gamma;
            this.dn = dn;
        }

        public int getPixelIndex(int x) {
            int i = 0;
            for (int pixel : this.pixels) {
                if (x < pixel) {
                    return i - 1;
                }
                ++i;
            }
            return this.pixels.length - 2;
        }
    }

    public static final class NoiseAzimuthVector {
        public final String swath;
        public final int firstAzimuthLine;
        public final int firstRangeSample;
        public final int lastAzimuthLine;
        public final int lastRangeSample;
        public final int[] lines;
        public final float[] noiseAzimuthLUT;

        public NoiseAzimuthVector(String swath, int firstAzimuthLine, int firstRangeSample, int lastAzimuthLine, int lastRangeSample, int[] lines, float[] noiseAzimuthLUT) {
            this.swath = swath;
            this.firstAzimuthLine = firstAzimuthLine;
            this.firstRangeSample = firstRangeSample;
            this.lastAzimuthLine = lastAzimuthLine;
            this.lastRangeSample = lastRangeSample;
            this.lines = lines;
            this.noiseAzimuthLUT = noiseAzimuthLUT;
        }
    }

    public static final class NoiseVector {
        public final double timeMJD;
        public final int line;
        public final int[] pixels;
        public final float[] noiseLUT;

        public NoiseVector(ProductData.UTC time, int line, int[] pixels, float[] noiseLUT) {
            this.timeMJD = time.getMJD();
            this.line = line;
            this.pixels = pixels;
            this.noiseLUT = noiseLUT;
        }
    }

    public static final class DCPolynomial {
        public double time;
        public double t0;
        public double[] dataDcPolynomial;
    }

    public static final class AzimuthFmRate {
        public double time;
        public double t0;
        public double c0;
        public double c1;
        public double c2;
    }

    public static final class SubSwathInfo {
        public String subSwathName;
        public int numOfLines;
        public int numOfSamples;
        public double firstLineTime;
        public double lastLineTime;
        public double firstValidLineTime;
        public double lastValidLineTime;
        public double slrTimeToFirstPixel;
        public double slrTimeToLastPixel;
        public double slrTimeToFirstValidPixel;
        public double slrTimeToLastValidPixel;
        public double azimuthTimeInterval;
        public double rangePixelSpacing;
        public double azimuthPixelSpacing;
        public double radarFrequency;
        public double rangeSamplingRate;
        public double azimuthSteeringRate;
        public double ascendingNodeTime;
        public int firstValidPixel;
        public int lastValidPixel;
        public int numOfBursts;
        public int linesPerBurst;
        public int samplesPerBurst;
        public double[] burstFirstLineTime;
        public double[] burstLastLineTime;
        public double[] burstFirstValidLineTime;
        public double[] burstLastValidLineTime;
        public int[][] firstValidSample;
        public int[][] lastValidSample;
        public int[] firstValidLine;
        public int[] lastValidLine;
        public double[][] rangeDependDopplerRate;
        public double[][] dopplerRate;
        public double[][] referenceTime;
        public double[][] dopplerCentroid;
        public double[][] apSlantRangeTime;
        public double[][] apElevationAngle;
        public int numOfGeoLines;
        public int numOfGeoPointsPerLine;
        public double[][] azimuthTime;
        public double[][] slantRangeTime;
        public double[][] latitude;
        public double[][] longitude;
        public double[][] incidenceAngle;
        public Map<String, NoiseVector[]> noise = new HashMap<String, NoiseVector[]>();
        public Map<String, CalibrationVector[]> calibration = new HashMap<String, CalibrationVector[]>();
    }
}

